/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductInfo {
    private int m_M_Product_ID = 0;
    private String m_trxName = null;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private String m_productType = null;
    private String m_ProductCategory = null;
    private boolean m_isBOM = false;
    private boolean m_isStocked = true;
    private int m_C_RevenueRecognition_ID = 0;
    private int m_C_UOM_ID = 0;
    private BigDecimal m_qty = Env.ZERO;
    private static final CLogger log = CLogger.getCLogger(ProductInfo.class);

    public ProductInfo(int M_Product_ID, String trxName) {
        this.m_trxName = trxName;
        this.init(M_Product_ID);
    }

    private void init(int M_Product_ID) {
        block7: {
            this.m_M_Product_ID = M_Product_ID;
            if (this.m_M_Product_ID == 0) {
                return;
            }
            String sql = "SELECT p.ProductType, pc.Value, p.C_RevenueRecognition_ID,p.C_UOM_ID, p.AD_Client_ID,p.AD_Org_ID, p.IsBOM, p.IsStocked FROM M_Product_Category pc INNER JOIN M_Product p ON (pc.M_Product_Category_ID=p.M_Product_Category_ID) WHERE p.M_Product_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_productType = rs.getString(1);
                        this.m_ProductCategory = rs.getString(2);
                        this.m_C_RevenueRecognition_ID = rs.getInt(3);
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_AD_Client_ID = rs.getInt(5);
                        this.m_AD_Org_ID = rs.getInt(6);
                        this.m_isBOM = "Y".equals(rs.getString(7));
                        this.m_isStocked = "Y".equals(rs.getString(8));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public boolean isProduct() {
        return "I".equals(this.m_productType);
    }

    public boolean isBOM() {
        return this.m_isBOM;
    }

    public boolean isStocked() {
        return this.m_isStocked;
    }

    public boolean isService() {
        return "S".equals(this.m_productType);
    }

    public String getProductCategory() {
        return this.m_ProductCategory;
    }

    public boolean isRevenueRecognition() {
        return this.m_C_RevenueRecognition_ID != 0;
    }

    public int getC_RevenueRecognition_ID() {
        return this.m_C_RevenueRecognition_ID;
    }

    public int getC_UOM_ID() {
        return this.m_C_UOM_ID;
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public void setQty(BigDecimal qty, int C_UOM_ID) {
        this.m_qty = MUOMConversion.convert(C_UOM_ID, this.m_C_UOM_ID, qty, true);
        if (qty != null && this.m_qty == null) {
            log.severe("Conversion error - set to " + String.valueOf(qty));
            this.m_qty = qty;
        }
    }

    public BigDecimal getQty() {
        return this.m_qty;
    }
}

