/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductPriceValidator
implements ModelValidator {
    private static final CLogger log = CLogger.getCLogger(ProductPriceValidator.class);
    private int m_AD_Client_ID;

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addModelChange("M_ProductPrice", this);
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        block9: {
            MPriceListVersion plv;
            int M_Pricelist_Version_Base_ID;
            MProductPrice pp;
            int M_PriceList_Version_ID;
            if (po instanceof MProductPrice && (type == 5 || type == 4 || type == 6) && (M_PriceList_Version_ID = (pp = (MProductPrice)po).getM_PriceList_Version_ID()) > 0 && (M_Pricelist_Version_Base_ID = (plv = new MPriceListVersion(Env.getCtx(), M_PriceList_Version_ID, null)).getM_Pricelist_Version_Base_ID()) > 0) {
                int M_Product_ID = pp.getM_Product_ID();
                BigDecimal priceLimit = pp.getPriceLimit();
                BigDecimal priceList = pp.getPriceList();
                BigDecimal priceStd = pp.getPriceStd();
                boolean isActive = pp.isActive();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM M_PriceList_Version ");
                sql.append("WHERE IsActive = 'Y' AND AD_Client_ID = ? ");
                sql.append("AND M_DiscountSchema_ID = ? ");
                sql.append("AND M_Pricelist_Version_Base_ID = ? ");
                sql.append("AND M_PriceList_Version_ID <> ? ");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), po.get_TrxName());
                        int count = 1;
                        pstmt.setInt(count++, Env.getAD_Client_ID(Env.getCtx()));
                        pstmt.setInt(count++, plv.getM_DiscountSchema_ID());
                        pstmt.setInt(count++, M_Pricelist_Version_Base_ID);
                        pstmt.setInt(count++, M_PriceList_Version_ID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MPriceListVersion plv1 = new MPriceListVersion(Env.getCtx(), rs, po.get_TrxName());
                            MProductPrice pp1 = MProductPrice.get(Env.getCtx(), plv1.getM_PriceList_Version_ID(), M_Product_ID, po.get_TrxName());
                            if (type == 5 || type == 4) {
                                if (pp1 == null) {
                                    pp1 = new MProductPrice(Env.getCtx(), plv1.getM_PriceList_Version_ID(), M_Product_ID, po.get_TrxName());
                                }
                                if (priceList.compareTo(pp1.getPriceList()) == 0 && priceStd.compareTo(pp1.getPriceStd()) == 0 && priceLimit.compareTo(pp1.getPriceLimit()) == 0 && isActive == pp1.isActive()) continue;
                                pp1.setPrices(priceList, priceStd, priceLimit);
                                pp1.setIsActive(isActive);
                                pp1.saveEx(po.get_TrxName());
                                continue;
                            }
                            if (type != 6 || pp1 == null) continue;
                            pp1.delete(false, po.get_TrxName());
                        }
                    }
                    catch (SQLException ex) {
                        log.log(Level.SEVERE, sql.toString(), ex);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }
}

