/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.base.IProductPricing;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.I_C_Project;
import org.compiere.model.I_C_ProjectLine;
import org.compiere.model.I_M_RMA;
import org.compiere.model.I_M_RMALine;
import org.compiere.model.I_M_RequisitionLine;
import org.compiere.util.Env;

public abstract class AbstractProductPricing
implements IProductPricing {
    protected int m_M_Product_ID;
    protected int m_C_BPartner_ID;
    protected BigDecimal m_Qty = Env.ONE;
    protected boolean m_isSOTrx = true;
    protected String trxName = null;
    protected int m_M_PriceList_Version_ID = 0;
    protected int m_M_PriceList_ID = 0;
    protected Timestamp m_PriceDate;

    @Override
    public void setInitialValues(int M_Product_ID, int C_BPartner_ID, BigDecimal qty, boolean isSOTrx, String trxName) {
        this.trxName = trxName;
        this.m_M_Product_ID = M_Product_ID;
        this.m_C_BPartner_ID = C_BPartner_ID;
        if (qty != null && Env.ZERO.compareTo(qty) != 0) {
            this.m_Qty = qty;
        }
        this.m_isSOTrx = isSOTrx;
    }

    @Override
    public int getM_Product_ID() {
        return this.m_M_Product_ID;
    }

    @Override
    public int getM_PriceList_ID() {
        return this.m_M_PriceList_ID;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        this.m_M_PriceList_ID = M_PriceList_ID;
    }

    @Override
    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        this.m_M_PriceList_Version_ID = M_PriceList_Version_ID;
    }

    @Override
    public void setQty(BigDecimal qty) {
        this.m_Qty = qty;
    }

    @Override
    public Timestamp getPriceDate() {
        return this.m_PriceDate;
    }

    @Override
    public void setPriceDate(Timestamp priceDate) {
        this.m_PriceDate = priceDate;
    }

    @Override
    public void setOrderLine(I_C_OrderLine orderLine, String trxName) {
        this.m_M_Product_ID = orderLine.getM_Product_ID();
        if (orderLine.getC_Order_ID() > 0) {
            I_C_Order order = orderLine.getC_Order();
            this.m_isSOTrx = order.isSOTrx();
        }
        this.m_C_BPartner_ID = orderLine.getC_BPartner_ID();
        BigDecimal qty = orderLine.getQtyOrdered();
        if (qty != null && Env.ZERO.compareTo(qty) != 0) {
            this.m_Qty = qty;
        }
        this.m_PriceDate = orderLine.getDateOrdered();
        this.trxName = trxName;
    }

    @Override
    public void setInvoiceLine(I_C_InvoiceLine invoiceLine, String trxName) {
        BigDecimal qty;
        this.m_M_Product_ID = invoiceLine.getM_Product_ID();
        if (invoiceLine.getC_Invoice_ID() > 0) {
            I_C_Invoice invoice = invoiceLine.getC_Invoice();
            this.m_C_BPartner_ID = invoice.getC_BPartner_ID();
            this.m_isSOTrx = invoice.isSOTrx();
            this.m_PriceDate = invoice.getDateInvoiced();
        }
        BigDecimal bigDecimal = qty = invoiceLine.getQtyInvoiced() != null ? invoiceLine.getQtyInvoiced() : invoiceLine.getQtyEntered();
        if (qty != null && Env.ZERO.compareTo(qty) != 0) {
            this.m_Qty = qty;
        }
        this.trxName = trxName;
    }

    @Override
    public void setProjectLine(I_C_ProjectLine projectLine, String trxName) {
        BigDecimal qty;
        this.m_M_Product_ID = projectLine.getM_Product_ID();
        if (projectLine.getC_Project_ID() > 0) {
            I_C_Project project = projectLine.getC_Project();
            this.m_C_BPartner_ID = project.getC_BPartner_ID();
        }
        if ((qty = projectLine.getPlannedQty()) != null && Env.ZERO.compareTo(qty) != 0) {
            this.m_Qty = qty;
        }
        this.m_isSOTrx = true;
        this.trxName = trxName;
    }

    @Override
    public void setRequisitionLine(I_M_RequisitionLine reqLine, String trxName) {
        this.m_M_Product_ID = reqLine.getM_Product_ID();
        this.m_C_BPartner_ID = reqLine.getC_BPartner_ID();
        BigDecimal qty = reqLine.getQty();
        if (qty != null && Env.ZERO.compareTo(qty) != 0) {
            this.m_Qty = qty;
        }
        this.m_isSOTrx = false;
        this.trxName = trxName;
    }

    @Override
    public void setRMALine(I_M_RMALine rmaLine, String trxName) {
        this.m_M_Product_ID = rmaLine.getM_Product_ID();
        if (rmaLine.getM_RMA_ID() > 0) {
            I_M_RMA rma = rmaLine.getM_RMA();
            this.m_C_BPartner_ID = rma.getC_BPartner_ID();
            this.m_isSOTrx = rma.isSOTrx();
        }
        this.m_Qty = Env.ONE;
        this.trxName = trxName;
    }
}

