/*
 * Decompiled with CFR 0.152.
 */
package com.akunagroup.uk.postcode;

import com.akunagroup.uk.postcode.AddressLookupInterface;
import com.akunagroup.uk.postcode.Postcode;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.compiere.util.CLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated(forRemoval=true, since="11")
public class AddressLookup
implements AddressLookupInterface {
    private static final CLogger log = CLogger.getCLogger(AddressLookup.class);
    private String accessCode = null;
    private String clientID = null;
    private String serverUrl = null;
    private HashMap<String, Object> postcodeData = new HashMap();

    public AddressLookup() {
    }

    public AddressLookup(String serverUrl, String serialNo, String password) {
        this.serverUrl = serverUrl.trim();
        this.clientID = serialNo.trim();
        this.accessCode = password.trim();
    }

    private URL buildUrl(String postcode) {
        try {
            StringBuilder urlStr = new StringBuilder();
            urlStr.append(this.serverUrl);
            urlStr.append(this.serverUrl.endsWith("/") ? "" : "/");
            urlStr.append("/query?op=query&");
            urlStr.append("cc=" + this.clientID + "&");
            urlStr.append("ac=" + this.accessCode + "&");
            urlStr.append("DSGID=1&AmbiguityId=1&MaxReturns=250&FieldList=&ParamList=&sAppID=Adempiere&MaxReturns=200");
            urlStr.append("&Lookfor=" + postcode);
            URL url = new URL(urlStr.toString());
            return url;
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, "Lookup URL: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private int extractPCodeInfo(Document xmlDoc) {
        Postcode postcode = new Postcode();
        int resultCode = 0;
        xmlDoc.getDocumentElement().normalize();
        Element doc = xmlDoc.getDocumentElement();
        NodeList DataElements = doc.getElementsByTagName("DataElement");
        System.out.println("Number of DataElements: " + DataElements.getLength());
        int i = 0;
        while (i < DataElements.getLength()) {
            Node firstDataNode = DataElements.item(i);
            if (firstDataNode.getNodeType() == 1) {
                Element ValueElement;
                NodeList firstValueList;
                Element firstElement = (Element)firstDataNode;
                NodeList firstNameList = firstElement.getElementsByTagName("Name");
                Element NameElement = (Element)firstNameList.item(0);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Name: " + NameElement.getChildNodes().item(0).getNodeValue().trim() + " Node: " + i);
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("ADDR")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setAddr(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("STREET")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setStreet1(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("LOCALITY")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setStreet2(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("POSTTOWN")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setCity(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("COUNTY")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setRegion(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("POSTCODE")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setPostcode(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("COUNTRY")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setCountry(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("COUNTRYCODE")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setCountryCode(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("TRADCOUNTY")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setTradCounty(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("LONLOCOUT")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setLonLocation(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("ADMINCOUNTY")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    postcode.setAdminCounty(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
                if (NameElement.getChildNodes().item(0).getNodeValue().trim().equals("RESCODE")) {
                    firstValueList = firstElement.getElementsByTagName("Value");
                    ValueElement = (Element)firstValueList.item(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Value: " + ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim() + " Node: " + i);
                    }
                    resultCode = Integer.valueOf(ValueElement.getChildNodes().item(0).getNodeValue().replaceAll("\n", "").trim());
                }
            }
            ++i;
        }
        int returnValue = 0;
        switch (resultCode) {
            case 0: {
                String errorMsg = "An internal error occurred when connecting to Capscan Service";
                String errorTitle = "Error";
                JOptionPane.showMessageDialog(null, errorMsg, errorTitle, 0);
                break;
            }
            case 1: {
                returnValue = 1;
                break;
            }
            case 2: {
                String errorMsg = "No matching addresses found for this post code";
                String errorTitle = "Error";
                JOptionPane.showMessageDialog(null, errorMsg, errorTitle, 0);
                break;
            }
            case 3: {
                String errorMsg = "Insufficient information provided to determin post code";
                String errorTitle = "Error";
                JOptionPane.showMessageDialog(null, errorMsg, errorTitle, 0);
                break;
            }
            case 4: {
                String errorMsg = "The results cover more than one postcode";
                String errorTitle = "Error";
                JOptionPane.showMessageDialog(null, errorMsg, errorTitle, 0);
                break;
            }
            case 5: {
                String errorMsg = "Not a UK address";
                String errorTitle = "Error";
                JOptionPane.showMessageDialog(null, errorMsg, errorTitle, 0);
            }
        }
        if (returnValue == 1) {
            if (postcode.getRegion().equals("London") && (postcode.getCountryCode().equals("UK") || postcode.getCountryCode().equals("GB"))) {
                postcode.setCity(postcode.getLonLocation());
            } else {
                postcode.setRegion(postcode.getAdminCounty());
            }
            this.postcodeData.put(postcode.getPostcode(), postcode);
        } else {
            log.log(Level.WARNING, "Postcode lookup error: " + postcode.getPostcode());
        }
        return returnValue;
    }

    private Document fetchResult(URL cgiUrl) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            URLConnection URLconnection = cgiUrl.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)URLconnection;
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream inStream = httpConnection.getInputStream();
                try {
                    Document doc = docBuilder.parse(inStream);
                    return doc;
                }
                catch (SAXException e) {
                    log.log(Level.SEVERE, "Fetch Result: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Fetch Result: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public String getPassword() {
        return this.accessCode;
    }

    @Override
    public HashMap<String, Object> getAddressData() {
        return this.postcodeData;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public int lookupPostcode(String postcode) {
        URL url = this.buildUrl(postcode);
        if (url == null) {
            log.log(Level.SEVERE, "URL: Can't build URL.");
            return -1;
        }
        Document resultDoc = this.fetchResult(url);
        if (resultDoc == null) {
            log.log(Level.SEVERE, "Result document is null.");
            return -1;
        }
        return this.extractPCodeInfo(resultDoc);
    }

    @Override
    public void setPassword(String password) {
        this.accessCode = password.trim();
    }

    @Override
    public void setClientID(String clientID) {
        this.clientID = clientID.trim();
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl.trim();
    }

    @Override
    public AddressLookupInterface newInstance() {
        return new AddressLookup();
    }
}

