/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcessPara;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class DatabaseElementColumnRename
extends SvrProcess {
    private int p_AD_Element_ID = 0;
    private String p_NewColumnName;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("NewColumnName".equals(name)) {
                this.p_NewColumnName = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
        this.p_AD_Element_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        M_Element element = new M_Element(this.getCtx(), this.p_AD_Element_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(element.toString());
        }
        if (Util.isEmpty(this.p_NewColumnName, true) || this.p_NewColumnName.toLowerCase().equals(element.getColumnName().toLowerCase())) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@NotValid@: @NewColumnName@")));
        }
        int cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Element WHERE UPPER(ColumnName)=UPPER(?)", this.p_NewColumnName);
        if (cnt > 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@AlreadyExists@: @ColumnName@ = " + this.p_NewColumnName)));
        }
        cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Column c JOIN AD_Table t ON (t.AD_Table_ID=c.AD_Table_ID) WHERE c.AD_Element_ID=? AND t.IsView='Y'", this.p_AD_Element_ID);
        if (cnt > 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "Not implemented yet - cannot change column in view")));
        }
        element.renameDBColumn(this.p_NewColumnName, this.getProcessInfo());
        element.saveEx();
        return "@OK@";
    }
}

