/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.sql.RowSet;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;

@Process
public class RollUpCosts
extends SvrProcess {
    private int category = 0;
    private int product_id = 0;
    private int costelement_id = 0;
    private int charge_id = 0;
    private HashSet<Integer> processed;
    private Map<Integer, MInventory> inventoryDocs = new HashMap<Integer, MInventory>();
    private Map<String, MInventoryLine> inventoryLines = new HashMap<String, MInventoryLine>();
    private MDocType adjustmentDocType = null;

    protected void prepare() {
        int chosen_id = 0;
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.category = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    chosen_id = para[i].getParameterAsInt();
                } else if (name.equals("M_CostElement_ID")) {
                    this.costelement_id = para[i].getParameterAsInt();
                } else if (name.equals("C_Charge_ID")) {
                    this.charge_id = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.getTable_ID() == 208) {
            this.product_id = this.getRecord_ID();
            if (this.product_id == 0) {
                this.product_id = chosen_id;
            }
        } else {
            this.product_id = chosen_id;
        }
    }

    protected String doIt() throws Exception {
        MDocType[] doctypes;
        this.processed = new HashSet();
        MDocType[] mDocTypeArray = doctypes = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"MMI");
        int n = doctypes.length;
        int n2 = 0;
        while (n2 < n) {
            MDocType dt = mDocTypeArray[n2];
            if ("CA".equals(dt.getDocSubTypeInv())) {
                this.adjustmentDocType = dt;
                break;
            }
            ++n2;
        }
        if (this.adjustmentDocType == null) {
            throw new IllegalStateException("Failed to find cost adjustment document type");
        }
        String result = this.rollUp();
        if (this.inventoryDocs.size() > 0) {
            for (MInventory costingDoc : this.inventoryDocs.values()) {
                ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)costingDoc, (String)"CO");
                if (info.isError()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessFailed")).append(": ");
                    msg.append(info.getSummary());
                    this.addLog(this.getAD_PInstance_ID(), null, null, msg.toString());
                    continue;
                }
                costingDoc.saveEx();
                this.addBufferLog(this.getAD_PInstance_ID(), null, null, costingDoc.toString(), 321, costingDoc.get_ID());
            }
        }
        return result;
    }

    protected String rollUp() throws Exception {
        int count = 0;
        if (this.product_id != 0) {
            String error = this.rollUpCosts(this.product_id);
            if (!Util.isEmpty((String)error)) {
                this.addLog(this.getAD_PInstance_ID(), null, null, "Rollup BOM Cost is not applicable for the product " + MProduct.get((Properties)this.getCtx(), (int)this.product_id).getName() + ". Details: " + error, 208, this.product_id);
            } else {
                ++count;
            }
        } else {
            if (this.category != 0) {
                String sql = "SELECT M_PRODUCT_ID FROM M_PRODUCT WHERE M_PRODUCT_CATEGORY_ID = " + this.category + " AND AD_CLIENT_ID = " + this.getAD_Client_ID() + " AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b  JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID WHERE b.AD_Client_ID=" + this.getAD_Client_ID() + " AND b.IsActive='Y' AND bl.IsActive='Y' AND b.BOMType='A' AND b.BOMUse='A')";
                Trx trx = Trx.get((String)this.get_TrxName(), (boolean)false);
                RowSet results = null;
                try {
                    results = DB.getRowSet((String)sql);
                    while (results.next()) {
                        Savepoint savepoint = trx.setSavepoint(null);
                        int id = results.getInt(1);
                        String error = this.rollUpCosts(id);
                        if (!Util.isEmpty((String)error)) {
                            this.addLog(this.getAD_PInstance_ID(), null, null, "Rollup BOM Cost is not applicable for the product " + MProduct.get((Properties)this.getCtx(), (int)id).getName() + ". Details: " + error, 208, this.product_id);
                            trx.rollback(savepoint);
                            continue;
                        }
                        trx.releaseSavepoint(savepoint);
                        ++count;
                    }
                }
                finally {
                    DB.close((ResultSet)results);
                }
            }
            String sql = "SELECT M_PRODUCT_ID FROM M_PRODUCT WHERE AD_CLIENT_ID = " + this.getAD_Client_ID() + " AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b  JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID WHERE b.AD_Client_ID=" + this.getAD_Client_ID() + " AND b.IsActive='Y' AND bl.IsActive='Y' AND b.BOMType='A' AND b.BOMUse='A')";
            Trx trx = Trx.get((String)this.get_TrxName(), (boolean)false);
            RowSet results = null;
            try {
                results = DB.getRowSet((String)sql);
                while (results.next()) {
                    Savepoint savepoint = trx.setSavepoint(null);
                    int id = results.getInt(1);
                    String error = this.rollUpCosts(id);
                    if (!Util.isEmpty((String)error)) {
                        this.addLog(this.getAD_PInstance_ID(), null, null, "Rollup BOM Cost is not applicable for the product " + MProduct.get((Properties)this.getCtx(), (int)id).getName() + ". Details: " + error, 208, this.product_id);
                        trx.rollback(savepoint);
                        continue;
                    }
                    trx.releaseSavepoint(savepoint);
                    ++count;
                }
            }
            finally {
                DB.close((ResultSet)results);
            }
        }
        return count + " Product Cost Updated.";
    }

    protected String rollUpCosts(int productId) throws Exception {
        int[] prodbomids;
        String sql = "SELECT bl.M_Product_ID FROM PP_Product_BOMLine bl  JOIN PP_PRODUCT_BOM b  ON ( b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID ) WHERE b.M_Product_ID = ? AND b.AD_Client_ID = " + this.getAD_Client_ID() + " AND b.BOMUse='A' AND b.BOMType='A' AND b.IsActive='Y' AND bl.IsActive='Y' ";
        int[] nArray = prodbomids = DB.getIDsEx((String)this.get_TrxName(), (String)sql.toString(), (Object[])new Object[]{productId});
        int n = prodbomids.length;
        int n2 = 0;
        while (n2 < n) {
            String error;
            int prodbomid = nArray[n2];
            if (!this.processed.contains(prodbomid) && !Util.isEmpty((String)(error = this.rollUpCosts(prodbomid)))) {
                return error;
            }
            ++n2;
        }
        MProduct product = new MProduct(this.getCtx(), productId, this.get_TrxName());
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder productCostSql = new StringBuilder("SELECT * FROM M_Cost ").append(" WHERE M_Product_ID = ").append(productId).append(" AND AD_Client_ID = ").append(this.getAD_Client_ID()).append(" AND M_CostElement_ID = ").append(this.costelement_id).append(" AND C_AcctSchema_ID = ").append(MClient.get((int)this.getAD_Client_ID()).getAcctSchema().getC_AcctSchema_ID()).append(" AND M_PRODUCT_ID IN (SELECT b.M_PRODUCT_ID FROM PP_PRODUCT_BOM b ").append(" JOIN PP_PRODUCT_BOMLINE bl ON b.PP_PRODUCT_BOM_ID = bl.PP_PRODUCT_BOM_ID").append(" WHERE b.BOMType='A' AND b.BOMUse='A' AND b.IsActive='Y' ").append(" AND b.AD_Client_ID=").append(this.getAD_Client_ID()).append(")");
            pstmt = DB.prepareStatement((String)productCostSql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal qtyOnHand;
                MCost cost = new MCost(this.getCtx(), rs, this.get_TrxName());
                StringBuilder newCurrentCostPriceSql = new StringBuilder("SELECT SUM(b.QtyBOM * c.CurrentCostPrice)").append(" FROM PP_Product_BOMLine b ").append(" INNER JOIN M_Cost c ON (b.M_PRODUCT_ID = c.M_Product_ID) ").append(" JOIN PP_Product_BOM bom ON (bom.PP_PRODUCT_BOM_ID = b.PP_PRODUCT_BOM_ID AND bom.IsActive='Y') ").append(" WHERE bom.M_Product_ID = ").append(productId).append(" AND bom.BOMType='A' AND bom.BOMUse='A' AND M_CostElement_ID = ").append(this.costelement_id).append(" AND c.C_AcctSchema_ID = ").append(cost.getC_AcctSchema_ID());
                BigDecimal newCurrentCostPrice = DB.getSQLValueBD((String)this.get_TrxName(), (String)newCurrentCostPriceSql.toString(), (Object[])new Object[0]);
                if (newCurrentCostPrice == null) {
                    newCurrentCostPrice = BigDecimal.ZERO;
                }
                StringBuilder newFutureCostPriceSql = new StringBuilder("SELECT SUM(b.QtyBOM * c.FutureCostPrice)").append(" FROM PP_Product_BOMLine b ").append(" INNER JOIN M_Cost c ON (b.M_PRODUCT_ID = c.M_Product_ID) ").append(" JOIN PP_Product_BOM bom ON (bom.PP_PRODUCT_BOM_ID = b.PP_PRODUCT_BOM_ID AND bom.IsActive='Y') ").append(" WHERE bom.M_Product_ID = ").append(productId).append(" AND M_CostElement_ID = ").append(this.costelement_id).append(" AND c.C_AcctSchema_ID = ").append(cost.getC_AcctSchema_ID());
                BigDecimal newFutureCostPrice = DB.getSQLValueBD((String)this.get_TrxName(), (String)newFutureCostPriceSql.toString(), (Object[])new Object[0]);
                if (newFutureCostPrice == null) {
                    newFutureCostPrice = BigDecimal.ZERO;
                }
                StringBuilder qtyOnHandSql = new StringBuilder("SELECT SUM(QtyOnHand)").append(" FROM M_StorageOnHand oh ").append(" JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID)").append(" JOIN M_Warehouse w ON (w.M_Warehouse_ID=loc.M_Warehouse_ID)").append(" WHERE oh.M_Product_ID=").append(productId).append(" AND w.IsActive='Y'").append(" AND w.AD_Client_ID=").append(this.getAD_Client_ID());
                if (cost.getM_AttributeSetInstance_ID() != 0) {
                    qtyOnHandSql.append(" AND oh.M_AttributeSetInstance_ID=").append(cost.getM_AttributeSetInstance_ID());
                }
                if ((qtyOnHand = DB.getSQLValueBD((String)this.get_TrxName(), (String)qtyOnHandSql.toString(), (Object[])new Object[0])) == null) {
                    qtyOnHand = BigDecimal.ZERO;
                }
                if (cost.getCurrentCostPrice().compareTo(newCurrentCostPrice) != 0) {
                    MInventory costingDoc = this.createCostingDoc(product);
                    String key = costingDoc.getM_Inventory_ID() + "_" + cost.getM_Product_ID() + "_" + cost.getM_AttributeSetInstance_ID();
                    MInventoryLine costingLine = this.inventoryLines.get(key);
                    if (costingLine == null) {
                        costingLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
                        costingLine.setAD_Org_ID(costingDoc.getAD_Org_ID());
                        costingLine.setM_Inventory_ID(costingDoc.getM_Inventory_ID());
                        costingLine.setM_Product_ID(cost.getM_Product_ID());
                        costingLine.setM_AttributeSetInstance_ID(cost.getM_AttributeSetInstance_ID());
                        costingLine.setC_Charge_ID(this.charge_id);
                        costingLine.setCurrentCostPrice(cost.getCurrentCostPrice());
                        costingLine.setM_Locator_ID(0);
                    }
                    costingLine.setNewCostPrice(newCurrentCostPrice);
                    costingLine.saveEx();
                    this.inventoryLines.put(key, costingLine);
                }
                if (cost.getFutureCostPrice().compareTo(newFutureCostPrice) != 0) {
                    cost.setFutureCostPrice(newFutureCostPrice);
                }
                if (!cost.is_Changed()) continue;
                cost.saveEx();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        this.processed.add(productId);
        return null;
    }

    private MInventory createCostingDoc(MProduct product) {
        int AD_Org_ID = product.getAD_Org_ID() > 0 ? product.getAD_Org_ID() : Env.getAD_Org_ID((Properties)this.getCtx());
        MInventory costingDoc = this.inventoryDocs.get(AD_Org_ID);
        if (costingDoc == null) {
            costingDoc = new MInventory(this.getCtx(), 0, this.get_TrxName());
            costingDoc.setAD_Org_ID(AD_Org_ID);
            costingDoc.setDescription("Created due to rollup BOM cost process ID " + this.getAD_PInstance_ID());
            costingDoc.setC_DocType_ID(this.adjustmentDocType.getC_DocType_ID());
            costingDoc.setCostingMethod(MCostElement.get((Properties)this.getCtx(), (int)this.costelement_id).getCostingMethod());
            costingDoc.setDocAction("CO");
            costingDoc.saveEx();
            this.inventoryDocs.put(AD_Org_ID, costingDoc);
        }
        return costingDoc;
    }
}

