/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.SecureEngine;

public final class Ini
implements Serializable {
    private static final long serialVersionUID = -8936090051638559660L;
    private static CLogger log = CLogger.getCLogger(Ini.class);
    public static final String IDEMPIERE_PROPERTY_FILE = "idempiere.properties";
    public static final String P_UID = "ApplicationUserID";
    private static final String DEFAULT_UID = "GardenAdmin";
    public static final String P_PWD = "ApplicationPassword";
    private static final String DEFAULT_PWD = "";
    public static final String P_STORE_PWD = "StorePassword";
    private static final boolean DEFAULT_STORE_PWD = false;
    public static final String P_TRACELEVEL = "TraceLevel";
    private static final String DEFAULT_TRACELEVEL = "WARNING";
    public static final String P_TRACEFILE = "TraceFile";
    private static final boolean DEFAULT_TRACEFILE = false;
    public static final String P_LANGUAGE = "Language";
    private static final String DEFAULT_LANGUAGE = Language.getName(System.getProperty("user.language") + "_" + System.getProperty("user.country"));
    public static final String P_INI = "FileNameINI";
    private static final String DEFAULT_INI = "";
    public static final String P_CONNECTION = "Connection";
    private static final String DEFAULT_CONNECTION = "";
    public static final String P_CONTEXT = "DataSource";
    private static final String DEFAULT_CONTEXT = "java:adempiereDB";
    public static final String P_UI_LOOK = "UILookFeel";
    private static final String DEFAULT_UI_LOOK = "Adempiere";
    private static final String DEFAULT_UI_THEME = "Adempiere Theme";
    public static final String P_UI_THEME = "UITheme";
    public static final String P_A_COMMIT = "AutoCommit";
    private static final boolean DEFAULT_A_COMMIT = true;
    public static final String P_A_LOGIN = "AutoLogin";
    private static final boolean DEFAULT_A_LOGIN = false;
    public static final String P_A_NEW = "AutoNew";
    private static final boolean DEFAULT_A_NEW = false;
    public static final String P_ADEMPIERESYS = "AdempiereSys";
    private static final boolean DEFAULT_ADEMPIERESYS = false;
    public static final String P_LOGMIGRATIONSCRIPT = "LogMigrationScript";
    private static final boolean DEFAULT_LOGMIGRATIONSCRIPT = false;
    public static final String P_SHOW_ACCT = "ShowAcct";
    private static final boolean DEFAULT_SHOW_ACCT = true;
    public static final String P_SHOW_TRL = "ShowTrl";
    private static final boolean DEFAULT_SHOW_TRL = false;
    public static final String P_CACHE_WINDOW = "CacheWindow";
    private static final boolean DEFAULT_CACHE_WINDOW = true;
    public static final String P_TEMP_DIR = "TempDir";
    private static final String DEFAULT_TEMP_DIR = "";
    public static final String P_ROLE = "Role";
    private static final String DEFAULT_ROLE = "";
    public static final String P_CLIENT = "Client";
    private static final String DEFAULT_CLIENT = "";
    public static final String P_ORG = "Organization";
    private static final String DEFAULT_ORG = "";
    public static final String P_PRINTER = "Printer";
    private static final String DEFAULT_PRINTER = "";
    public static final String P_WAREHOUSE = "Warehouse";
    private static final String DEFAULT_WAREHOUSE = "";
    public static final String P_TODAY = "CDate";
    private static final Timestamp DEFAULT_TODAY = new Timestamp(System.currentTimeMillis());
    public static final String P_PRINTPREVIEW = "PrintPreview";
    private static final boolean DEFAULT_PRINTPREVIEW = false;
    public static final String P_VALIDATE_CONNECTION_ON_STARTUP = "ValidateConnectionOnStartup";
    private static final boolean DEFAULT_VALIDATE_CONNECTION_ON_STARTUP = false;
    public static final String P_SINGLE_INSTANCE_PER_WINDOW = "SingleInstancePerWindow";
    public static final boolean DEFAULT_SINGLE_INSTANCE_PER_WINDOW = false;
    public static final String P_OPEN_WINDOW_MAXIMIZED = "OpenWindowMaximized";
    public static final boolean DEFAULT_OPEN_WINDOW_MAXIMIZED = false;
    private static final String P_WARNING = "Warning";
    private static final String DEFAULT_WARNING = "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.";
    private static final String P_WARNING_de = "WarningD";
    private static final String DEFAULT_WARNING_de = "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.";
    public static final String P_CHARSET = "Charset";
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final String P_LOAD_TAB_META_DATA_BG = "LoadTabMetaDataBackground";
    public static final String DEFAULT_LOAD_TAB_META_DATA_BG = "N";
    private static final String[] PROPERTIES = new String[]{"ApplicationUserID", "ApplicationPassword", "TraceLevel", "TraceFile", "Language", "FileNameINI", "Connection", "StorePassword", "UILookFeel", "UITheme", "AutoCommit", "AutoLogin", "AutoNew", "AdempiereSys", "LogMigrationScript", "ShowAcct", "ShowTrl", "CacheWindow", "DataSource", "TempDir", "Role", "Client", "Organization", "Printer", "Warehouse", "CDate", "PrintPreview", "ValidateConnectionOnStartup", "SingleInstancePerWindow", "OpenWindowMaximized", "Warning", "WarningD", "Charset", "LoadTabMetaDataBackground"};
    private static final String[] VALUES = new String[]{"GardenAdmin", "", "WARNING", "N", DEFAULT_LANGUAGE, "", "", "N", "Adempiere", "Adempiere Theme", "Y", "N", "N", "N", "N", "Y", "N", "Y", "java:adempiereDB", "", "", "", "", "", "", DEFAULT_TODAY.toString(), "N", "N", "N", "N", "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.", "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.", "UTF-8", "N"};
    private static volatile Properties s_prop = new Properties();
    private static String s_propertyFileName = null;
    public static final String ENV_PREFIX = "env.";
    public static final String IDEMPIERE_HOME = "IDEMPIERE_HOME";
    private static boolean s_client = false;
    private static boolean s_loaded = false;
    private static boolean s_license_dialog = true;

    public static void saveProperties(boolean tryUserHome) {
        if (Ini.isClient() && DB.isConnected()) {
            ModelValidationEngine.get().beforeSaveProperties();
        }
        String fileName = Ini.getFileName(tryUserHome);
        FileOutputStream fos = null;
        try {
            File f = new File(fileName);
            f.getAbsoluteFile().getParentFile().mkdirs();
            fos = new FileOutputStream(f);
            s_prop.store(fos, DEFAULT_UI_LOOK);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + e.toString());
            return;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + t.toString());
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(fileName);
        }
    }

    public static void loadProperties(boolean reload) {
        if (reload || s_prop.size() == 0) {
            Ini.loadProperties(Ini.getFileName(s_client));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean loadProperties(String filename) {
        block26: {
            loadOK = true;
            firstTime = false;
            Ini.s_prop = new Properties();
            fis = null;
            try {
                fis = new FileInputStream(filename);
                Ini.s_prop.load(fis);
            }
            catch (FileNotFoundException v0) {
                Ini.log.warning(filename + " not found");
                loadOK = false;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception v1) {}
                }
                break block26;
            }
            catch (Exception e) {
                Ini.log.log(Level.SEVERE, filename + " - " + e.toString());
                loadOK = false;
                ** if (fis == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (Exception v2) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block26;
                }
            }
            catch (Throwable t) {
                Ini.log.log(Level.SEVERE, filename + " - " + t.toString());
                loadOK = false;
                ** if (fis == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (Exception v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block26;
                }
                {
                    catch (Throwable var5_6) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception v4) {}
                        }
                        throw var5_6;
                    }
                }
            }
            if (fis == null) break block26;
            try {
                fis.close();
            }
            catch (Exception v5) {}
        }
        if (!loadOK || Ini.s_prop.getProperty("CDate", "").equals("")) {
            if (Ini.log.isLoggable(Level.CONFIG)) {
                Ini.log.config(filename);
            }
            firstTime = true;
        }
        Ini.checkProperties();
        if (!loadOK || firstTime) {
            Ini.saveProperties(true);
        }
        Ini.s_loaded = true;
        if (Ini.log.isLoggable(Level.INFO)) {
            Ini.log.info(filename + " #" + Ini.s_prop.size());
        }
        Ini.s_propertyFileName = filename;
        return firstTime;
    }

    private static void checkProperties() {
        int i2 = 0;
        while (i2 < PROPERTIES.length) {
            if (VALUES[i2].length() > 0) {
                Ini.checkProperty(PROPERTIES[i2], VALUES[i2]);
            }
            ++i2;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            tempDir = Ini.getAdempiereHome();
        }
        if (tempDir == null) {
            tempDir = "";
        }
        Ini.checkProperty(P_TEMP_DIR, tempDir);
    }

    public static void deletePropertyFile() {
        String fileName = Ini.getFileName(s_client);
        File file = new File(fileName);
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                s_prop = new Properties();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(fileName);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Cannot delete Property file", e);
            }
        }
    }

    private static String checkProperty(String key, String defaultValue) {
        String result = null;
        result = key.equals(P_WARNING) || key.equals(P_WARNING_de) ? defaultValue : (!Ini.isClient() ? s_prop.getProperty(key, "xyz" + defaultValue) : s_prop.getProperty(key, SecureEngine.encrypt(defaultValue, 0)));
        s_prop.setProperty(key, result);
        return result;
    }

    public static String getFileName(boolean tryUserHome) {
        String home;
        if (SystemProperties.getPropertyFile() != null) {
            return SystemProperties.getPropertyFile();
        }
        Object base = null;
        if (tryUserHome && s_client) {
            base = System.getProperty("user.home");
        }
        if (!(s_client && base != null && ((String)base).length() != 0 || (home = Ini.getAdempiereHome()) == null)) {
            base = home;
        }
        if (base != null && !((String)base).endsWith(File.separator)) {
            base = (String)base + File.separator;
        }
        if (base == null) {
            base = "";
        }
        return (String)base + IDEMPIERE_PROPERTY_FILE;
    }

    public static void setProperty(String key, String value) {
        if (s_prop == null) {
            s_prop = new Properties();
        }
        if (key.equals(P_WARNING) || key.equals(P_WARNING_de)) {
            s_prop.setProperty(key, value);
        } else if (key.endsWith(".TraceLevel")) {
            s_prop.setProperty(key, value);
        } else if (!Ini.isClient()) {
            s_prop.setProperty(key, "xyz" + value);
        } else if (value == null) {
            s_prop.setProperty(key, "");
        } else {
            String eValue = SecureEngine.encrypt(value, 0);
            if (eValue == null) {
                s_prop.setProperty(key, "");
            } else {
                s_prop.setProperty(key, eValue);
            }
        }
    }

    public static void setProperty(String key, boolean value) {
        Ini.setProperty(key, value ? "Y" : DEFAULT_LOAD_TAB_META_DATA_BG);
    }

    public static void setProperty(String key, int value) {
        Ini.setProperty(key, String.valueOf(value));
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        if (retStr == null || retStr.length() == 0) {
            return "";
        }
        String value = SecureEngine.decrypt(retStr, 0);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static boolean isPropertyBool(String key) {
        return Ini.getProperty(key).equals("Y");
    }

    @Deprecated
    public static boolean isCacheWindow() {
        return Ini.getProperty(P_CACHE_WINDOW).equals("Y");
    }

    public static Properties getProperties() {
        return s_prop;
    }

    public static String getAsString() {
        StringBuilder buf = new StringBuilder("Ini[");
        Enumeration<Object> e = s_prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buf.append(key).append("=");
            buf.append(Ini.getProperty(key)).append("; ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static boolean isClient() {
        return s_client;
    }

    public static void setClient(boolean client) {
        s_client = client;
    }

    public static void setShowLicenseDialog(boolean b2) {
        s_license_dialog = b2;
    }

    public static boolean isShowLicenseDialog() {
        return s_license_dialog;
    }

    public static boolean isLoaded() {
        return s_loaded;
    }

    public static String getAdempiereHome() {
        Object env = SystemProperties.getEnvIdempiereHome();
        if (env == null || ((String)env).trim().length() == 0) {
            env = SystemProperties.getIdempiereHome();
        }
        if (env == null || ((String)env).trim().length() == 0) {
            File file;
            String current;
            String string = current = Ini.isClient() ? System.getProperty("user.home") : System.getProperty("user.dir");
            if (current != null && current.trim().length() > 0 && (file = new File(current)).exists() && file.canWrite()) {
                env = current;
            }
        }
        if (env == null || ((String)env).trim().length() == 0) {
            env = File.separator + "idempiere";
        }
        return env;
    }

    public static void setAdempiereHome(String idempiereHome) {
        if (idempiereHome != null && idempiereHome.length() > 0) {
            System.setProperty(IDEMPIERE_HOME, idempiereHome);
        }
    }

    public static String findAdempiereHome() {
        return Ini.getAdempiereHome();
    }

    @Deprecated
    public static Dimension getWindowDimension(int AD_Window_ID) {
        String key = "WindowDim" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(124);
        if (index == -1) {
            return null;
        }
        try {
            String w = value.substring(0, index);
            String h = value.substring(index + 1);
            return new Dimension(Integer.parseInt(w), Integer.parseInt(h));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static void setWindowDimension(int AD_Window_ID, Dimension windowDimension) {
        String key = "WindowDim" + AD_Window_ID;
        if (windowDimension != null) {
            String value = windowDimension.width + "|" + windowDimension.height;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    @Deprecated
    public static Point getWindowLocation(int AD_Window_ID) {
        String key = "WindowLoc" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(124);
        if (index == -1) {
            return null;
        }
        try {
            String x = value.substring(0, index);
            String y = value.substring(index + 1);
            return new Point(Integer.parseInt(x), Integer.parseInt(y));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static void setWindowLocation(int AD_Window_ID, Point windowLocation) {
        String key = "WindowLoc" + AD_Window_ID;
        if (windowLocation != null) {
            String value = windowLocation.x + "|" + windowLocation.y;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    @Deprecated
    public static int getDividerLocation() {
        String key = "Divider";
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Deprecated
    public static void setDividerLocation(int dividerLocation) {
        String key = "Divider";
        String value = String.valueOf(dividerLocation);
        s_prop.put(key, value);
    }

    public static Charset[] getAvailableCharsets() {
        Collection<Charset> col = Charset.availableCharsets().values();
        Charset[] arr = new Charset[col.size()];
        col.toArray(arr);
        return arr;
    }

    public static Charset getCharset() {
        String charsetName = Ini.getProperty(P_CHARSET);
        if (charsetName == null || charsetName.length() == 0) {
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception exception) {
            return Charset.defaultCharset();
        }
    }

    public static String getPropertyFileName() {
        return s_propertyFileName;
    }

    public static String getVar(String secretVar) {
        String cmd = Ini.getUtilsCmd("getVar");
        String[] command = new String[]{cmd, secretVar};
        String retValue = Ini.runCommand(command);
        return retValue;
    }

    public static void setVar(String secretVar, String secretValue) {
        String cmd = Ini.getUtilsCmd("setVar");
        String[] command = new String[]{cmd, secretVar, secretValue};
        Ini.runCommand(command);
    }

    private static String getUtilsCmd(String script2) {
        File utilsFolder = new File(Ini.getAdempiereHome() + File.separator + "utils");
        if (!utilsFolder.exists() && !(utilsFolder = Env.isWindows() ? new File(Ini.getAdempiereHome() + File.separator + "org.adempiere.server-feature" + File.separator + "utils.windows") : new File(Ini.getAdempiereHome() + File.separator + "org.adempiere.server-feature" + File.separator + "utils.unix")).exists()) {
            throw new AdempiereException("Folder utils does not exist");
        }
        File cmd = new File(utilsFolder, script2 + (Env.isWindows() ? ".bat" : ".sh"));
        if (!cmd.exists() || !cmd.canExecute()) {
            throw new AdempiereException("File does not exist or canno execute " + cmd.getAbsolutePath());
        }
        return cmd.getAbsolutePath();
    }

    public static String runCommand(String[] command) {
        StringBuilder msg = new StringBuilder();
        try {
            String s;
            Process p2 = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                msg.append(s);
            }
            while ((s = stdError.readLine()) != null) {
                msg.append(s);
            }
            if (!p2.waitFor(5L, TimeUnit.SECONDS)) {
                throw new AdempiereException("Timeout waiting 5 seconds for " + command[0]);
            }
            if (p2.exitValue() != 0) {
                throw new Exception(msg.toString());
            }
        }
        catch (Exception e) {
            throw new AdempiereException("Could not execute " + command[0], e);
        }
        return msg.toString();
    }
}

