/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WRecordEditor;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class WRecordUUIDEditor
extends WRecordEditor<String> {
    public WRecordUUIDEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super(gridField, tableEditor, editorConfiguration);
    }

    @Override
    public void actionZoom() {
        String recordUU;
        String s = this.tableIDValue != null ? String.valueOf(this.tableIDValue) : "";
        int tableID = s.length() > 0 ? Integer.parseInt(s) : 0;
        String string = recordUU = this.recordIDValue != null ? this.recordIDValue.toString() : "";
        if (tableID <= 0) {
            return;
        }
        if (!MRole.getDefault().isTableAccess(tableID, false)) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AccessTableNoView"));
        }
        AEnv.zoomUU(tableID, recordUU);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("FieldValue".equals(evt.getPropertyName())) {
            int tableID;
            int n = tableID = this.tableIDValue != null ? Integer.parseInt(String.valueOf(this.tableIDValue)) : 0;
            if (tableID > 0) {
                MTable table2 = MTable.get((int)tableID);
                String recordUU = Objects.toString(evt.getNewValue(), "");
                if (tableID > 0 && recordUU.length() > 0) {
                    table2.getPOByUU(recordUU, null);
                }
            }
            this.setValue(evt.getNewValue(), false);
        }
    }

    @Override
    public String toKeyValue(Object value) {
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean isUseUUIDKey() {
        return true;
    }

    @Override
    public String validateTableIdValue(int tableId) {
        MTable table2 = MTable.get((int)tableId);
        if (!table2.hasUUIDKey()) {
            return "TableHasNoKeyColumn";
        }
        return null;
    }
}

