/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ChosenSearchBox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MRefList;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.addon.chosenbox.Chosenbox;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.South;

public class WChosenboxListEditor
extends WEditor
implements ContextMenuListener {
    public static final String[] LISTENER_EVENTS = new String[]{"onSelect"};
    private static final CLogger logger = CLogger.getCLogger(WChosenboxListEditor.class);
    private Lookup lookup;
    private Object oldValue;
    private CCacheListener tableCacheListener;
    private boolean onselecting = false;
    private ListModelList<ValueNamePair> model = new ListModelList();

    public WChosenboxListEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WChosenboxListEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        this((Component)new ChosenSearchBox(new ChosenboxEditor()), gridField, tableEditor, editorConfiguration);
    }

    private WChosenboxListEditor(Component comp, GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super(comp, gridField, tableEditor, editorConfiguration);
        this.lookup = gridField.getLookup();
        this.init();
    }

    public WChosenboxListEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        this(lookup, label, description, mandatory, readonly, updateable, false);
    }

    public WChosenboxListEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable, boolean autocomplete) {
        this((Component)new ChosenSearchBox(new ChosenboxEditor()), lookup, label, description, mandatory, readonly, updateable);
    }

    private WChosenboxListEditor(Component comp, Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super(comp, label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        super.setColumnName(lookup.getColumnName());
        this.init();
    }

    public WChosenboxListEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        this(columnName, mandatory, isReadOnly, isUpdateable, lookup, false);
    }

    public WChosenboxListEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup, boolean autocomplete) {
        this((Component)new ChosenSearchBox(new ChosenboxEditor()), columnName, mandatory, isReadOnly, isUpdateable, lookup);
    }

    private WChosenboxListEditor(Component comp, String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super(comp, columnName, null, null, mandatory, isReadOnly, isUpdateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.init();
    }

    private void init() {
        this.getComponent().setHflex("true");
        ((ChosenboxEditor)this.getComponent().getChosenbox()).editor = this;
        this.getComponent().getChosenbox().setModel(this.model);
        String imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-More" : ThemeManager.getThemeResource("images/ShowMore16.png");
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(imageUrl);
        } else {
            this.getComponent().getButton().setImage(imageUrl);
        }
        this.getComponent().getButton().addEventListener("onClick", e -> {
            if (this.getComponent().isEnabled() && !this.getComponent().getChosenbox().isOpen()) {
                this.getComponent().getChosenbox().setOpen(true);
                this.getComponent().getChosenbox().focus();
            }
        });
        if (this.lookup != null) {
            this.lookup.setMandatory(true);
            if (this.isReadWrite()) {
                this.refreshLookup();
            } else {
                this.updateModel();
            }
        }
        if (this.gridField != null) {
            this.popupMenu = new WEditorPopupMenu(false, true, this.isShowPreference(), false, false, false, this.lookup);
            this.addChangeLogMenu(this.popupMenu);
            this.popupMenu.removeNewUpdateMenu();
            Menuitem editor = new Menuitem();
            editor.setAttribute("EVENT", (Object)"ASSISTANT");
            editor.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Assistant"));
            if (ThemeManager.isUseFontIconForImage()) {
                editor.setIconSclass("z-icon-Wizard");
            } else {
                editor.setImage(ThemeManager.getThemeResource("images/Wizard16.png"));
            }
            editor.addEventListener("onClick", (EventListener)this.popupMenu);
            this.popupMenu.appendChild((Component)editor);
        }
    }

    protected void refreshLookup() {
        this.lookup.refresh();
        this.updateModel();
    }

    @Override
    public String getDisplay() {
        StringBuilder display = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                if (display.length() > 0) {
                    display.append(", ");
                }
                display.append(pair.getName());
            }
        }
        return display.toString();
    }

    @Override
    public Object getValue() {
        return this.oldValue;
    }

    private String getValueFromComponent() {
        StringBuilder retVal = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                StringBuilder builder;
                if (retVal.length() > 0) {
                    retVal.append(",");
                }
                if ((builder = new StringBuilder(pair.getValue())).indexOf(",") >= 0) {
                    builder.insert(0, "\"");
                    builder.append("\"");
                }
                retVal.append(builder.toString());
            }
        }
        return retVal.length() > 0 ? retVal.toString() : null;
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && value instanceof String && !Util.isEmpty((String)((String)value), (boolean)true)) {
            String[] values = ((String)value).split("[,]");
            LinkedHashSet<ValueNamePair> selected = new LinkedHashSet<ValueNamePair>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!Util.isEmpty((String)key)) {
                    if (key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    String name = this.lookup.getDisplay((Object)key);
                    ValueNamePair pair = new ValueNamePair(key, name);
                    selected.add(pair);
                }
                ++n2;
            }
            this.getComponent().getChosenbox().setSelectedObjects(selected);
            if (this.getComponent().getChosenbox().getSelectedObjects().size() != selected.size()) {
                Object curValue = this.oldValue;
                this.oldValue = value;
                if (this.isReadWrite() && this.lookup != null) {
                    this.refreshLookup();
                } else {
                    this.updateModel();
                }
                this.getComponent().getChosenbox().setSelectedObjects(selected);
                if (this.getComponent().getChosenbox().getSelectedObjects().size() != selected.size()) {
                    this.getComponent().getChosenbox().setSelectedObjects(new LinkedHashSet());
                    if (curValue == null) {
                        curValue = value;
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                    super.fireValueChange(changeEvent);
                    this.oldValue = null;
                }
            } else {
                this.oldValue = value;
            }
        } else {
            this.getComponent().getChosenbox().setSelectedObjects(new LinkedHashSet());
            this.oldValue = value;
        }
    }

    public ChosenSearchBox getComponent() {
        return (ChosenSearchBox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    private void updateModel() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.isReadWrite()) {
            if (this.lookup != null) {
                int size = this.lookup.getSize();
                int i = 0;
                while (i < size) {
                    Object obj = this.lookup.getElementAt(i);
                    if (obj instanceof KeyNamePair) {
                        lookupKNPair = (KeyNamePair)obj;
                        ValueNamePair vnp = new ValueNamePair(Integer.toString(lookupKNPair.getKey()), lookupKNPair.getName());
                        list.add(vnp);
                    } else if (obj instanceof ValueNamePair) {
                        lookupKNPair = (ValueNamePair)obj;
                        list.add(lookupKNPair);
                    }
                    ++i;
                }
            }
        } else if (this.lookup != null && this.oldValue != null) {
            String[] values = ((String)this.oldValue).split("[,]");
            ArrayList<ValueNamePair> selected = new ArrayList<ValueNamePair>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!Util.isEmpty((String)key)) {
                    if (key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    String name = this.lookup.getDisplay((Object)key);
                    ValueNamePair pair = new ValueNamePair(key, name);
                    selected.add(pair);
                }
                ++n2;
            }
            list = selected;
        }
        this.model.clear();
        this.model.addAll(list);
    }

    public void onEvent(Event event) {
        if ("onSelect".equalsIgnoreCase(event.getName())) {
            this.updateValue(this.getValueFromComponent());
        }
    }

    private void updateValue(Object newValue) {
        block8: {
            try {
                this.onselecting = true;
                if (!this.isValueChange(newValue)) break block8;
                try {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(true);
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                    super.fireValueChange(changeEvent);
                    this.oldValue = newValue;
                }
                finally {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(false);
                    }
                }
            }
            finally {
                this.onselecting = false;
            }
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    protected void actionRefresh() {
        if (this.lookup != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                this.refreshLookup();
            } else {
                this.updateModel();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
                }
                return;
            }
            if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            } else if ("ASSISTANT".equals(evt.getContextEvent())) {
                final WChosenboxListAssistant wdc = new WChosenboxListAssistant();
                wdc.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        String newValue = wdc.getNewValue();
                        WChosenboxListEditor.this.updateValue(newValue);
                        WChosenboxListEditor.this.setValue(newValue.toString());
                    }
                });
                AEnv.showWindow(wdc);
            }
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        if (this.lookup != null && (!this.lookup.isValidated() || !this.lookup.isLoaded() || this.isReadWrite() && this.lookup.getSize() != this.getComponent().getChosenbox().getModel().getSize())) {
            this.actionRefresh();
        }
        super.dynamicDisplay(ctx);
    }

    private void createCacheListener() {
        String columnName;
        int dotIndex;
        if (this.lookup != null && (dotIndex = (columnName = this.lookup.getColumnName()).indexOf(".")) > 0) {
            String tableName = columnName.substring(0, dotIndex);
            this.tableCacheListener = new CCacheListener(tableName, this);
        }
    }

    private static class CCacheListener
    extends CCache<String, Object> {
        private static final long serialVersionUID = 3543247404379028327L;
        private WChosenboxListEditor editor;

        protected CCacheListener(String tableName, WChosenboxListEditor editor) {
            super(tableName, tableName + "|CCacheListener", 0, false);
            this.editor = editor;
        }

        public int reset() {
            if (this.editor.getComponent().getDesktop() != null && this.editor.isReadWrite()) {
                this.refreshLookupList();
            }
            return 0;
        }

        private void refreshLookupList() {
            Executions.schedule((Desktop)this.editor.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) {
                    try {
                        if (editor.isReadWrite()) {
                            editor.actionRefresh();
                        }
                    }
                    catch (Exception exception) {}
                }
            }, (Event)new Event("onResetLookupList"));
        }

        public void newRecord(int record_ID) {
            if (this.editor.getComponent().getDesktop() != null && this.editor.isReadWrite()) {
                this.refreshLookupList();
            }
        }
    }

    private static final class ChosenboxEditor
    extends Chosenbox<ValueNamePair> {
        private static final long serialVersionUID = 7777300782255405327L;
        private DesktopCleanup listener = null;
        private WChosenboxListEditor editor = null;

        protected ChosenboxEditor() {
        }

        public void setPage(Page page) {
            super.setPage(page);
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (this.editor != null && this.editor.tableCacheListener == null) {
                this.editor.createCacheListener();
                if (this.listener == null) {
                    this.listener = new DesktopCleanup(){

                        public void cleanup(Desktop desktop) throws Exception {
                            this.cleanup();
                        }
                    };
                    newpage.getDesktop().addListener((Object)this.listener);
                }
            }
        }

        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            if (this.listener != null && page.getDesktop() != null) {
                page.getDesktop().removeListener((Object)this.listener);
            }
            this.cleanup();
        }

        protected void cleanup() {
            if (this.editor != null && this.editor.tableCacheListener != null) {
                CacheMgt.get().unregister((CacheInterface)this.editor.tableCacheListener);
                this.editor.tableCacheListener = null;
            }
        }
    }

    private class WChosenboxListAssistant
    extends Window
    implements EventListener<Event> {
        private static final long serialVersionUID = 1043859495570181469L;
        private Button bAdd;
        private Button bRemove;
        private Button bUp;
        private Button bDown;
        private SimpleListModel availableModel = new SimpleListModel();
        private SimpleListModel selectedModel = new SimpleListModel();
        private Listbox availableList = new Listbox();
        private Listbox selectedList = new Listbox();
        private Hlayout hlayout;
        private Button bOk;
        private Button bCancel;
        private Button bRemoveAll;
        private int refID = 0;
        private String m_newValue = "";

        public WChosenboxListAssistant() {
            this.refID = WChosenboxListEditor.this.gridField.getAD_Reference_Value_ID();
            this.setTitle(WChosenboxListEditor.this.gridField.getHeader() + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Assistant"));
            this.init();
            this.load();
            this.setClosable(true);
            this.setBorder("normal");
            this.setShadow(true);
            this.setMaximizable(true);
            this.setSizable(true);
            if (!ThemeManager.isUseCSSForWindowSize()) {
                ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
                ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 700);
            } else {
                this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                    ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                    ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                });
            }
            this.setSclass("chosenbox-assistant-dialog");
            this.addCallback("afterPageDetached", (Callback & Serializable)t -> WChosenboxListEditor.this.getComponent().getChosenbox().focus());
        }

        private void init() {
            this.m_newValue = WChosenboxListEditor.this.getValue() != null ? WChosenboxListEditor.this.getValue().toString() : "";
            Borderlayout mainLayout = new Borderlayout();
            this.appendChild((Component)mainLayout);
            Center center = new Center();
            mainLayout.appendChild((Component)center);
            center.setAutoscroll(true);
            EventListener<Event> actionListenerAddRemove = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WChosenboxListAssistant.this.migrateValueAcrossLists(event);
                }
            };
            EventListener<Event> actionListenerUpDown = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WChosenboxListAssistant.this.migrateValueWithinSelectedList(event);
                }
            };
            EventListener<Event> actionListenerRemoveAll = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WChosenboxListAssistant.this.deleteAllValuesList(event);
                }
            };
            EventListener<Event> mouseListener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if ("onDoubleClick".equals(event.getName())) {
                        if (((WChosenboxListAssistant)WChosenboxListAssistant.this).WChosenboxListEditor.this.gridField.getDisplayType() != 200161) {
                            WChosenboxListAssistant.this.deleteValueList(event);
                        } else {
                            WChosenboxListAssistant.this.migrateValueAcrossLists(event);
                        }
                    }
                }
            };
            DragListener crossListMouseListener = new DragListener();
            this.bUp = this.createButton("MoveUp16", actionListenerUpDown);
            this.bDown = this.createButton("MoveDown16", actionListenerUpDown);
            this.bAdd = this.createButton("MoveRight16", actionListenerAddRemove);
            this.bRemove = this.createButton("MoveLeft16", actionListenerAddRemove);
            Hlayout yesButtonLayout = this.createHlayoutBtn(new Button[]{this.bUp, this.bDown});
            Hlayout noButtonLayout = this.createHlayoutBtn(new Button[]{this.bRemove, this.bAdd});
            boolean isEditable = WChosenboxListEditor.this.gridField.isEditable(true);
            this.initListboxAndModel(this.selectedList, this.selectedModel, mouseListener, crossListMouseListener, isEditable, Msg.getMsg((Properties)Env.getCtx(), (String)"SelectedItems"), yesButtonLayout);
            if (WChosenboxListEditor.this.gridField.getDisplayType() == 200161 && isEditable) {
                this.initListboxAndModel(this.availableList, this.availableModel, mouseListener, crossListMouseListener, isEditable, Msg.getMsg((Properties)Env.getCtx(), (String)"Available"), noButtonLayout);
                this.hlayout = this.createHlayoutLine(new Component[]{this.availableList, this.selectedList});
            } else {
                this.hlayout = this.createHlayoutLine(new Component[]{this.selectedList});
            }
            center.appendChild((Component)this.hlayout);
            ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);
            this.bOk = confirmPanel.getOKButton();
            this.bOk.addEventListener("onClick", this);
            this.bCancel = confirmPanel.getButton("Cancel");
            this.bCancel.addEventListener("onClick", this);
            this.bRemoveAll = confirmPanel.getButton("Reset");
            this.bRemoveAll.addEventListener("onClick", (EventListener)actionListenerRemoveAll);
            South south = new South();
            south.setSclass("dialog-footer");
            mainLayout.appendChild((Component)south);
            south.appendChild((Component)confirmPanel);
            if (!isEditable) {
                this.bUp.setVisible(false);
                this.bDown.setVisible(false);
                this.bAdd.setVisible(false);
                this.bRemove.setVisible(false);
                this.bRemoveAll.setVisible(false);
            }
        }

        private void load() {
            int n;
            this.selectedModel.removeAllElements();
            if (WChosenboxListEditor.this.gridField.getDisplayType() != 200161) {
                this.availableModel.removeAllElements();
            }
            Object values = WChosenboxListEditor.this.getValue();
            ArrayList<String> listSelected = new ArrayList<String>();
            if (values != null && !Util.isEmpty((String)((String)values))) {
                String[] stringArray = ((String)values).split(",");
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (WChosenboxListEditor.this.gridField.getDisplayType() == 200161) {
                        this.selectedModel.addElement(new ValueNamePair(value, MRefList.getListName((Properties)Env.getCtx(), (int)this.refID, (String)value)));
                    } else {
                        String name = WChosenboxListEditor.this.lookup.getDisplay((Object)value);
                        this.selectedModel.addElement(new ValueNamePair(value, name));
                    }
                    listSelected.add(value);
                    ++n2;
                }
            }
            if (WChosenboxListEditor.this.gridField.getDisplayType() == 200161) {
                String validationCode = WChosenboxListEditor.this.gridField.getVO().ValidationCode;
                if (!Util.isEmpty((String)validationCode) && Util.isEmpty((String)(validationCode = Env.parseContext((Properties)Env.getCtx(), (int)WChosenboxListEditor.this.gridField.getWindowNo(), (int)WChosenboxListEditor.this.gridField.getVO().TabNo, (String)validationCode, (boolean)false)), (boolean)true)) {
                    validationCode = "1=2";
                }
                ValueNamePair[] valueNamePairArray = MRefList.getList((Properties)Env.getCtx(), (int)this.refID, (boolean)false, (String)validationCode, (String)"");
                int n3 = valueNamePairArray.length;
                n = 0;
                while (n < n3) {
                    ValueNamePair vnp = valueNamePairArray[n];
                    if (!listSelected.contains(vnp.getValue())) {
                        this.availableModel.addElement(new ValueNamePair(vnp.getValue(), MRefList.getListName((Properties)Env.getCtx(), (int)this.refID, (String)vnp.getValue())));
                        listSelected.add(vnp.getValue());
                    }
                    ++n;
                }
            }
        }

        public void onEvent(Event event) throws Exception {
            if (event.getTarget() == this.bOk) {
                StringBuilder value = new StringBuilder("");
                for (Listitem le : this.selectedList.getItems()) {
                    int index = this.selectedList.getIndexOfItem(le);
                    ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                    value.append(selObject.getID()).append(",");
                }
                if (value.length() > 0) {
                    value = value.deleteCharAt(value.length() - 1);
                }
                this.m_newValue = value.toString();
                this.detach();
            } else if (event.getTarget() == this.bCancel) {
                this.detach();
            }
        }

        private void deleteAllValuesList(Event event) {
            if (WChosenboxListEditor.this.gridField.getDisplayType() == 200161) {
                this.selectedModel.removeAllElements();
                this.availableModel.removeAllElements();
                String validationCode = WChosenboxListEditor.this.gridField.getVO().ValidationCode;
                if (!Util.isEmpty((String)validationCode) && Util.isEmpty((String)(validationCode = Env.parseContext((Properties)Env.getCtx(), (int)WChosenboxListEditor.this.gridField.getWindowNo(), (int)WChosenboxListEditor.this.gridField.getVO().TabNo, (String)validationCode, (boolean)false)), (boolean)true)) {
                    validationCode = "1=2";
                }
                ValueNamePair[] valueNamePairArray = MRefList.getList((Properties)Env.getCtx(), (int)this.refID, (boolean)false, (String)validationCode, (String)"");
                int n = valueNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueNamePair vnp = valueNamePairArray[n2];
                    this.availableModel.addElement(new ValueNamePair(vnp.getValue(), MRefList.getListName((Properties)Env.getCtx(), (int)this.refID, (String)vnp.getValue())));
                    ++n2;
                }
            } else {
                this.selectedModel.removeAllElements();
            }
        }

        private void deleteValueList(Event event) {
            Component source = event.getTarget();
            if (source instanceof ListItem) {
                ListItem listItem = (ListItem)source;
                int index = listItem.getIndex();
                this.selectedModel.removeElement(this.selectedModel.getElementAt(index));
            }
        }

        private Button createButton(String image, EventListener<Event> actionListener) {
            Button btn = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/" + image + ".png"), null);
            LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)btn);
            LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)btn);
            btn.addEventListener("onClick", actionListener);
            return btn;
        }

        private void initListboxAndModel(Listbox lb, SimpleListModel model, EventListener<Event> mouseListener, EventListener<Event> crossListMouseListener, boolean isItemDraggable, String headerLabel, Hlayout buttonsLayout) {
            lb.addEventListener("onRightClick", this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)lb, "1");
            ZKUpdateUtil.setVflex(lb, true);
            if (mouseListener != null && isItemDraggable) {
                lb.addDoubleClickListener(mouseListener);
            }
            if (crossListMouseListener != null && isItemDraggable) {
                lb.addOnDropListener(crossListMouseListener);
            }
            lb.setItemDraggable(isItemDraggable);
            lb.setItemRenderer(model);
            lb.setModel((ListModel)model);
            model.setMultiple(true);
            ListHead listHead = new ListHead();
            listHead.setParent((Component)lb);
            ListHeader listHeader = new ListHeader();
            listHeader.appendChild((Component)new Label(headerLabel));
            listHeader.setParent((Component)listHead);
            listHeader.appendChild((Component)buttonsLayout);
        }

        private Hlayout createHlayoutBtn(Button[] btns) {
            Hlayout hl = new Hlayout();
            Button[] buttonArray = btns;
            int n = btns.length;
            int n2 = 0;
            while (n2 < n) {
                Button btn = buttonArray[n2];
                hl.appendChild((Component)btn);
                ++n2;
            }
            hl.setStyle("display: inline-block; float: right;");
            return hl;
        }

        private Hlayout createHlayoutLine(Component[] comps) {
            Hlayout hl = new Hlayout();
            hl.setValign("middle");
            Component[] componentArray = comps;
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                hl.appendChild(comp);
                ++n2;
            }
            hl.setVflex("1");
            hl.setStyle("margin-bottom: 5px;");
            return hl;
        }

        private Listbox getListboxFrom(Object source) {
            Listbox retValue = null;
            if (source == this.bAdd || source == this.availableList) {
                retValue = this.availableList;
            } else if (source == this.bRemove || source == this.selectedList) {
                retValue = this.selectedList;
            }
            return retValue;
        }

        private Listbox getListboxTo(Object source) {
            Listbox retValue = null;
            if (source == this.bAdd || source == this.availableList) {
                retValue = this.selectedList;
            } else if (source == this.bRemove || source == this.selectedList) {
                retValue = this.availableList;
            }
            return retValue;
        }

        private SimpleListModel getModel(Listbox listbox) {
            SimpleListModel retValue = null;
            if (listbox == this.selectedList) {
                retValue = this.selectedModel;
            } else if (listbox == this.availableList) {
                retValue = this.availableModel;
            }
            return retValue;
        }

        private SimpleListModel getModel(SimpleListModel model) {
            SimpleListModel retValue = null;
            if (model == this.availableModel) {
                retValue = this.selectedModel;
            } else if (model == this.selectedModel) {
                retValue = this.availableModel;
            }
            return retValue;
        }

        private void migrateValueAcrossLists(Event event) {
            Component source = event.getTarget();
            if (source instanceof ListItem) {
                source = ((ListItem)source).getListbox();
            }
            Listbox listFrom = this.getListboxFrom(source);
            Listbox listTo = this.getListboxTo(source);
            int endIndex = this.selectedList.getIndexOfItem(listTo.getSelectedItem());
            if (endIndex < 0) {
                endIndex = 0;
            }
            this.migrateLists(listFrom, listTo, endIndex);
        }

        private void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
            int index = 0;
            SimpleListModel lmFrom = this.getModel(listFrom);
            SimpleListModel lmTo = this.getModel(lmFrom);
            Set selectedItems = listFrom.getSelectedItems();
            ArrayList<ValueNamePair> selObjects = new ArrayList<ValueNamePair>();
            for (Object obj : selectedItems) {
                ListItem listItem = (ListItem)((Object)obj);
                index = listFrom.getIndexOfItem(listItem);
                ValueNamePair selObject = (ValueNamePair)lmFrom.getElementAt(index);
                selObjects.add(selObject);
            }
            this.doTransfer(selObjects, lmFrom, lmTo, listTo, endIndex);
        }

        private void doTransfer(List<ValueNamePair> selObjects, SimpleListModel lmFrom, SimpleListModel lmTo, Listbox listTo, int endIndex) {
            Arrays.sort(selObjects.toArray());
            for (ValueNamePair selObject : selObjects) {
                lmFrom.removeElement(selObject);
                lmTo.add(endIndex, selObject);
            }
            if (listTo.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)listTo.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }

        private void migrateValueWithinSelectedList(SimpleListModel selModel, Listbox selListbox, int endIndex, List<ValueNamePair> selObjects) {
            int iniIndex = 0;
            Arrays.sort(selObjects.toArray());
            ValueNamePair selObject = null;
            ValueNamePair endObject = (ValueNamePair)selModel.getElementAt(endIndex);
            for (ValueNamePair selected : selObjects) {
                iniIndex = selModel.indexOf(selected);
                selObject = (ValueNamePair)selModel.getElementAt(iniIndex);
                selModel.removeElement(selObject);
                endIndex = selModel.indexOf(endObject);
                selModel.add(endIndex, selObject);
            }
            selListbox.removeAllItems();
            int i = 0;
            while (i < selModel.getSize()) {
                ValueNamePair pp = (ValueNamePair)selModel.getElementAt(i);
                selListbox.addItem(new ValueNamePair(pp.getID(), pp.getName()));
                ++i;
            }
        }

        private void migrateValueWithinSelectedList(Event event) {
            Object[] selObjects = this.selectedList.getSelectedItems().toArray();
            if (selObjects == null) {
                return;
            }
            int length = selObjects.length;
            if (length == 0) {
                return;
            }
            int[] indices = this.selectedList.getSelectedIndices();
            boolean change = false;
            Component source = event.getTarget();
            if (source == this.bUp) {
                i = 0;
                while (i < length) {
                    int index = indices[i];
                    if (index != 0) {
                        ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                        ValueNamePair newObject = (ValueNamePair)this.selectedModel.getElementAt(index - 1);
                        this.selectedModel.setElementAt(newObject, index);
                        this.selectedModel.setElementAt(selObject, index - 1);
                        indices[i] = index - 1;
                        change = true;
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (source == this.bDown) {
                i = length - 1;
                while (i >= 0) {
                    int index = indices[i];
                    if (index < this.selectedModel.getSize() - 1) {
                        ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                        ValueNamePair newObject = (ValueNamePair)this.selectedModel.getElementAt(index + 1);
                        this.selectedModel.setElementAt(newObject, index);
                        this.selectedModel.setElementAt(selObject, index + 1);
                        this.selectedList.setSelectedIndex(index + 1);
                        indices[i] = index + 1;
                        change = true;
                        --i;
                        continue;
                    }
                    break;
                }
            }
            if (change) {
                this.selectedList.setSelectedIndices(indices);
                if (this.selectedList.getSelectedItem() != null) {
                    AuFocus focus = new AuFocus((Component)this.selectedList.getSelectedItem());
                    Clients.response((AuResponse)focus);
                }
            }
        }

        private String getNewValue() {
            return this.m_newValue;
        }

        private class DragListener
        implements EventListener<Event> {
            public void onEvent(Event event) throws Exception {
                if (event instanceof DropEvent) {
                    int endIndex = 0;
                    DropEvent me = (DropEvent)event;
                    ListItem endItem = (ListItem)me.getTarget();
                    ListItem startItem = (ListItem)me.getDragged();
                    if (!startItem.isSelected()) {
                        startItem.setSelected(true);
                    }
                    Listbox selListbox = WChosenboxListAssistant.this.selectedList;
                    SimpleListModel selModel = WChosenboxListAssistant.this.getModel(selListbox);
                    if (startItem.getListbox() != endItem.getListbox()) {
                        Listbox listFrom = (Listbox)startItem.getListbox();
                        Listbox listTo = (Listbox)endItem.getListbox();
                        endIndex = selListbox.getIndexOfItem(endItem);
                        WChosenboxListAssistant.this.migrateLists(listFrom, listTo, endIndex);
                    } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == selListbox) {
                        ArrayList<ValueNamePair> selObjects = new ArrayList<ValueNamePair>();
                        endIndex = selListbox.getIndexOfItem(endItem);
                        for (Object obj : selListbox.getSelectedItems()) {
                            ListItem listItem = (ListItem)((Object)obj);
                            int index = selListbox.getIndexOfItem(listItem);
                            ValueNamePair selObject = (ValueNamePair)selModel.getElementAt(index);
                            selObjects.add(selObject);
                        }
                        WChosenboxListAssistant.this.migrateValueWithinSelectedList(selModel, selListbox, endIndex, selObjects);
                    }
                }
            }
        }
    }
}

