/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WMediaDialog;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WBinaryEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private static final CLogger log = CLogger.getCLogger(WBinaryEditor.class);
    private boolean m_mandatory;
    private Object m_data;
    private ADWindow adwindow;

    public WBinaryEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WBinaryEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Button(), gridField, tableEditor, editorConfiguration);
        this.init();
    }

    private void init() {
        this.label.setValue(" ");
        this.getComponent().setLabel("-");
        this.getComponent().setTooltiptext(this.gridField.getDescription());
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getLabel();
    }

    @Override
    public Object getValue() {
        return this.m_data;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    public Button getComponent() {
        return (Button)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public void setValue(Object value) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("=" + String.valueOf(value));
        }
        this.m_data = value;
        if (this.m_data == null) {
            this.getComponent().setLabel("-");
        } else {
            Object text = "?";
            if (this.m_data instanceof byte[]) {
                byte[] bb = (byte[])this.m_data;
                text = "#" + bb.length;
            } else {
                text = this.m_data.getClass().getName();
                int index = ((String)text).lastIndexOf(46);
                if (index != -1) {
                    text = ((String)text).substring(index + 1);
                }
            }
            this.getComponent().setLabel((String)text);
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            final WMediaDialog dialog = new WMediaDialog(this.gridField.getHeader(), this.m_data);
            dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (WBinaryEditor.this.adwindow != null) {
                        WBinaryEditor.this.adwindow.getADWindowContent().hideBusyMask();
                        WBinaryEditor.this.adwindow = null;
                    }
                    if (!dialog.isCancel() && dialog.isChange()) {
                        Object oldValue = WBinaryEditor.this.m_data;
                        Object newValue = dialog.getData();
                        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                            return;
                        }
                        if (oldValue == null && newValue == null) {
                            return;
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(WBinaryEditor.this, WBinaryEditor.this.getColumnName(), oldValue, newValue);
                        WBinaryEditor.this.fireValueChange(changeEvent);
                        WBinaryEditor.this.setValue(newValue);
                    }
                }
            });
            this.adwindow = ADWindow.findADWindow((Component)this.getComponent());
            if (this.adwindow != null) {
                ADWindowContent content = this.adwindow.getADWindowContent();
                content.getComponent().getParent().appendChild((Component)dialog);
                content.showBusyMask(dialog);
                LayoutUtils.openOverlappedWindow(content.getComponent().getParent(), dialog, "middle_center");
                dialog.focus();
            } else {
                AEnv.showWindow(dialog);
            }
        }
    }
}

