/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamResult;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.XMLReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class XMLReportRenderer
implements IReportRenderer<XMLReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(XMLReportRenderer.class);

    @Override
    public String getId() {
        return "XML";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileXML");
    }

    @Override
    public String getContentType() {
        return MediaType.XML_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, XMLReportRendererConfiguration configuration) {
        try {
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createXML(reportEngine, fw);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public void createXML(ReportEngine reportEngine, Writer writer) {
        try {
            reportEngine.getPrintData().createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
    }

    @Override
    public Class<XMLReportRendererConfiguration> getConfigurationType() {
        return XMLReportRendererConfiguration.class;
    }
}

