/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.print.export;

import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.print.attribute.standard.MediaSizeName;
import org.adempiere.impexp.AbstractXLSXExporter;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintPaper;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class PrintDataXLSXExporter
extends AbstractXLSXExporter {
    private static final int COLUMN_WIDTH_DIVISOR = 64;
    private static final int ROW_HEIGHT_DIVISOR = 20;
    private PrintData m_printData;
    private MPrintFormat m_printFormat;
    private Map<MPrintFormatItem, PrintData> childPrintFormatDetails;
    private ArrayList<Object> columns;
    private MQuery m_query;
    private int m_previousFormRow = -1;
    private int m_lastHeaderRow = -1;
    private int m_firstHeaderRow = -1;
    private int m_firstFooterRow = -1;
    private int m_previousFormCol = -1;
    private String m_previousAreaType = null;

    public PrintDataXLSXExporter(PrintData printData, MPrintFormat printFormat) {
        this(printData, printFormat, null);
    }

    public PrintDataXLSXExporter(PrintData printData, MPrintFormat printFormat, Boolean[] colSuppressRepeats) {
        this(printData, printFormat, null, colSuppressRepeats, null);
    }

    public PrintDataXLSXExporter(PrintData printData, MPrintFormat printFormat, Map<MPrintFormatItem, PrintData> childPrintFormatDetails, Boolean[] colSuppressRepeats, MQuery query) {
        this.m_printData = printData;
        this.m_printFormat = printFormat;
        this.colSuppressRepeats = colSuppressRepeats;
        this.childPrintFormatDetails = childPrintFormatDetails;
        this.m_query = query;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    private PrintDataElement getPDE(int row, int col) {
        Object colObj;
        if (this.m_printData.getRowIndex() != row) {
            this.m_printData.setRowIndex(row);
        }
        if ((colObj = this.columns.get(col)) instanceof InstanceAttributeColumn) {
            InstanceAttributeColumn ia = (InstanceAttributeColumn)colObj;
            return ia.getPrintDataElement(row);
        }
        if (colObj instanceof MPrintFormatItem) {
            MPrintFormatItem item = (MPrintFormatItem)colObj;
            Object obj = null;
            if (item.isTypeField() || item.isTypePrintFormat() && item.isImageField()) {
                obj = this.m_printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
            }
            if (item.isTypeScript()) {
                obj = this.m_printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
            }
            if (obj != null && obj instanceof PrintDataElement) {
                return (PrintDataElement)obj;
            }
        }
        return null;
    }

    @Override
    public int getDisplayType(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        if (pde != null) {
            return pde.getDisplayType();
        }
        return -1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        Object value = null;
        if (pde != null) {
            if (pde.isDate()) {
                o = pde.getValue();
                value = o instanceof Date ? new Timestamp(((Date)o).getTime()) : (Timestamp)pde.getValue();
            } else if (pde.isNumeric()) {
                o = pde.getValue();
                if (o instanceof Number) {
                    value = ((Number)o).doubleValue();
                }
            } else {
                value = pde.isYesNo() ? pde.getValue() : (pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(this.getLanguage()));
            }
        }
        MPrintFormatItem item = null;
        Object colObj = this.columns.get(col);
        if (colObj instanceof MPrintFormatItem) {
            item = (MPrintFormatItem)colObj;
        }
        if (item != null && item.getAD_PrintFormatChild_ID() != 0) {
            MPrintFormat mPrintFormat = null;
            if (this.childPrintFormatDetails != null) {
                Iterator<Map.Entry<MPrintFormatItem, PrintData>> iter = this.childPrintFormatDetails.entrySet().iterator();
                while (iter.hasNext()) {
                    try {
                        Map.Entry<MPrintFormatItem, PrintData> entry = iter.next();
                        MPrintFormatItem mPrintFormatItem = entry.getKey();
                        if (!mPrintFormatItem.equals(item)) continue;
                        mPrintFormat = new MPrintFormat(this.getCtx(), mPrintFormatItem.getAD_PrintFormatChild_ID(), null);
                        PrintData printData = entry.getValue();
                        PrintDataXLSXExporter exp = new PrintDataXLSXExporter(printData, mPrintFormat);
                        exp.exportToWorkbook(this.m_workbook, this.m_lang);
                        this.m_previousFormRow = this.m_workbook.getSheetAt(this.m_workbook.getNumberOfSheets() - 1).getLastRowNum();
                    }
                    catch (Exception ex) {
                        this.log.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    break;
                }
            }
        }
        return value;
    }

    @Override
    public String getHeaderName(int col) {
        Object colObj = this.columns.get(col);
        if (colObj instanceof MPrintFormatItem) {
            MPrintFormatItem item = (MPrintFormatItem)colObj;
            return item.getPrintName(this.getLanguage());
        }
        if (colObj instanceof InstanceAttributeColumn) {
            InstanceAttributeColumn ia = (InstanceAttributeColumn)colObj;
            return ia.getName();
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    @Override
    public boolean isColumnPrinted(int col) {
        return this.columns != null && col < this.columns.size();
    }

    @Override
    public boolean isPageBreak(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        return pde != null ? pde.isPageBreak() : false;
    }

    @Override
    protected void setCurrentRow(int row) {
        this.m_printData.setRowIndex(row);
    }

    @Override
    protected int getCurrentRow() {
        return this.m_printData.getRowIndex();
    }

    @Override
    public boolean isFunctionRow() {
        return this.m_printData.isFunctionRow();
    }

    @Override
    protected void formatPage(XSSFSheet sheet) {
        super.formatPage(sheet);
        MPrintPaper paper = MPrintPaper.get(this.m_printFormat.getAD_PrintPaper_ID());
        int paperSize = -1;
        MediaSizeName mediaSizeName = paper.getMediaSize().getMediaSizeName();
        if (MediaSizeName.NA_LETTER.equals(mediaSizeName)) {
            paperSize = 1;
        } else if (MediaSizeName.NA_LEGAL.equals(mediaSizeName)) {
            paperSize = 5;
        } else if (MediaSizeName.EXECUTIVE.equals(mediaSizeName)) {
            paperSize = 7;
        } else if (MediaSizeName.ISO_A4.equals(mediaSizeName)) {
            paperSize = 9;
        } else if (MediaSizeName.ISO_A5.equals(mediaSizeName)) {
            paperSize = 11;
        } else if (MediaSizeName.NA_NUMBER_10_ENVELOPE.equals(mediaSizeName)) {
            paperSize = 20;
        } else if (MediaSizeName.MONARCH_ENVELOPE.equals(mediaSizeName)) {
            paperSize = 37;
        }
        if (paperSize != -1) {
            sheet.getPrintSetup().setPaperSize((short)paperSize);
        }
        sheet.getPrintSetup().setLandscape(paper.isLandscape());
        sheet.setMargin((short)2, (double)paper.getMarginTop() / 72.0);
        sheet.setMargin((short)1, (double)paper.getMarginRight() / 72.0);
        sheet.setMargin((short)0, (double)paper.getMarginLeft() / 72.0);
        sheet.setMargin((short)3, (double)paper.getMarginBottom() / 72.0);
    }

    @Override
    public boolean isDisplayed(int row, int col) {
        Object colobj;
        MPrintFormatItem item;
        if (this.m_printData.getRowIndex() != row) {
            this.m_printData.setRowIndex(row);
        }
        MPrintFormatItem mPrintFormatItem = item = (colobj = this.columns.get(col)) instanceof InstanceAttributeColumn ? ((InstanceAttributeColumn)colobj).getPrintFormatItem() : (MPrintFormatItem)colobj;
        if (Util.isEmpty(item.getDisplayLogic())) {
            return true;
        }
        return Evaluator.evaluateLogic(new PrintDataEvaluatee(null, this.m_printData), item.getDisplayLogic());
    }

    @Override
    protected String getCellFormat(int row, int col) {
        String cellFormat = null;
        PrintDataElement pde = this.getPDE(row, col);
        if (pde != null && !Util.isEmpty(pde.getM_formatPattern())) {
            String formatPattern = pde.getM_formatPattern();
            int displayType = pde.getDisplayType();
            if (DisplayType.isDate(displayType)) {
                cellFormat = DisplayType.getDateFormat(displayType, this.getLanguage(), formatPattern).toPattern();
            } else if (DisplayType.isNumeric(displayType)) {
                cellFormat = DisplayType.getNumberFormat(displayType, this.getLanguage(), formatPattern).toPattern();
            }
        } else {
            return super.getCellFormat(row, col);
        }
        return cellFormat;
    }

    @Override
    protected void export(OutputStream out) throws Exception {
        this.columns = new ArrayList();
        ArrayList<InstanceAttributeData> asiElements = new ArrayList<InstanceAttributeData>();
        int columnCount = 0;
        int col = 0;
        while (col < this.m_printFormat.getItemCount()) {
            MPrintFormatItem item = this.m_printFormat.getItem(col);
            if (item.isPrinted()) {
                if (item.isTypeField() && item.isPrintInstanceAttributes()) {
                    InstanceAttributeData asiElement = new InstanceAttributeData(item, columnCount);
                    asiElement.readAttributesData(this.m_printData);
                    asiElements.add(asiElement);
                } else {
                    this.columns.add(item);
                    ++columnCount;
                }
            }
            ++col;
        }
        if (asiElements.size() > 0) {
            int columnCreated = 0;
            for (InstanceAttributeData data : asiElements) {
                List<InstanceAttributeColumn> instanceColumns = data.getColumns();
                int index = data.getColumnIndex() + columnCreated;
                for (InstanceAttributeColumn c : instanceColumns) {
                    this.columns.add(index, c);
                    ++index;
                    ++columnCreated;
                }
            }
        }
        super.export(out);
    }

    @Override
    protected void createParameter(XSSFSheet sheet) {
        if (!this.m_printFormat.isForm() && this.m_query != null && this.m_query.isActive()) {
            int rows;
            int n = rows = this.m_query.getReportProcessQuery() != null ? this.m_query.getReportProcessQuery().getRestrictionCount() : this.m_query.getRestrictionCount();
            if (rows > 0) {
                this.setNoOfParameter(rows);
                this.setFreezePane(1, rows + 1);
                XSSFCellStyle parameterStyle = this.m_workbook.createCellStyle();
                XSSFFont parameterFont = this.m_workbook.createFont();
                parameterFont.setItalic(true);
                parameterStyle.setFont((Font)parameterFont);
                MQuery query = this.m_query;
                if (this.m_query.getReportProcessQuery() != null) {
                    query = this.m_query.getReportProcessQuery();
                }
                int r = 0;
                while (r < query.getRestrictionCount()) {
                    XSSFCell cell;
                    XSSFRow row = sheet.createRow(r);
                    if (r == 0) {
                        cell = row.createCell(0);
                        XSSFCellStyle style2 = this.m_workbook.createCellStyle();
                        XSSFFont font = this.m_workbook.createFont();
                        font.setBold(true);
                        style2.setFont((Font)font);
                        cell.setCellStyle((CellStyle)style2);
                        String value = Msg.getMsg(this.getCtx(), "Parameter") + ":";
                        cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    }
                    cell = row.createCell(1);
                    cell.setCellStyle((CellStyle)parameterStyle);
                    String value = query.getInfoName(r);
                    cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    cell = row.createCell(2);
                    cell.setCellStyle((CellStyle)parameterStyle);
                    value = query.getInfoOperator(r);
                    cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    cell = row.createCell(3);
                    cell.setCellStyle((CellStyle)parameterStyle);
                    value = query.getInfoDisplayAll(r);
                    cell.setCellValue((RichTextString)new XSSFRichTextString(value));
                    ++r;
                }
            }
        }
    }

    @Override
    protected boolean isForm() {
        return this.m_printFormat.isForm();
    }

    @Override
    protected XSSFCell getFormCell(XSSFRow row, int colnum) {
        XSSFCell cell = null;
        if (colnum >= 0 && colnum < this.columns.size()) {
            int previousCol;
            MPrintFormatItem item = (MPrintFormatItem)this.columns.get(colnum);
            int n = previousCol = this.m_previousFormCol >= 0 ? this.m_previousFormCol : 0;
            if (this.m_previousAreaType != null && !this.m_previousAreaType.equals(item.getPrintAreaType())) {
                previousCol = 0;
            }
            if (item.isRelativePosition()) {
                int col;
                int offset;
                int n2 = offset = item.getXSpace() > 0 ? item.getXSpace() / 64 : 0;
                if (offset == 0 && item.getXSpace() > 0) {
                    offset = 1;
                }
                if ((cell = row.getCell(col = previousCol + offset)) == null) {
                    cell = row.createCell(col);
                }
            } else {
                int offset = item.getXPosition() > 0 ? item.getXPosition() / 64 : 0;
                cell = row.getCell(offset);
                if (cell == null) {
                    cell = row.createCell(offset);
                }
            }
            if (cell != null) {
                this.m_previousFormCol = cell.getColumnIndex();
                this.m_previousAreaType = item.getPrintAreaType();
            }
        }
        return cell;
    }

    @Override
    protected XSSFRow getFormRow(XSSFSheet sheet, int colnum) {
        XSSFRow row = null;
        if (this.m_firstHeaderRow == -1) {
            this.m_firstHeaderRow = sheet.getLastRowNum();
        }
        if (colnum >= 0 && colnum < this.columns.size()) {
            MPrintFormatItem item = (MPrintFormatItem)this.columns.get(colnum);
            if (item.isRelativePosition()) {
                int relativeFrom;
                int firstContentRow = this.m_lastHeaderRow >= 0 ? this.m_lastHeaderRow + 1 : this.m_firstHeaderRow;
                int n = relativeFrom = this.m_previousFormRow >= 0 ? this.m_previousFormRow : 0;
                if (item.getPrintAreaType().equals("C")) {
                    if (relativeFrom < firstContentRow) {
                        relativeFrom = firstContentRow;
                    }
                } else if (item.getPrintAreaType().equals("F")) {
                    if (relativeFrom < this.m_firstFooterRow) {
                        relativeFrom = this.m_firstFooterRow;
                    } else if (this.m_firstFooterRow == -1 && relativeFrom <= firstContentRow) {
                        relativeFrom = firstContentRow + 1;
                    }
                }
                if (item.isNextLine()) {
                    int offset = 1;
                    row = sheet.getRow(relativeFrom + offset);
                    if (row == null) {
                        row = sheet.createRow(relativeFrom + offset);
                    }
                } else if (item.getYSpace() == 0) {
                    row = sheet.getRow(relativeFrom);
                    if (row == null) {
                        row = sheet.createRow(relativeFrom);
                    }
                } else {
                    int offset = item.getYSpace() / 20 + 1;
                    row = sheet.getRow(relativeFrom + offset);
                    if (row == null) {
                        row = sheet.createRow(relativeFrom + offset);
                    }
                }
                this.m_previousFormRow = row.getRowNum();
                if (item.getPrintAreaType().equals("H") && row.getRowNum() > this.m_lastHeaderRow) {
                    this.m_lastHeaderRow = row.getRowNum();
                }
            } else if (item.getYPosition() == 0) {
                if (item.getPrintAreaType().equals("H")) {
                    row = sheet.getRow(this.m_firstHeaderRow);
                    if (row.getRowNum() > this.m_lastHeaderRow) {
                        this.m_lastHeaderRow = row.getRowNum();
                    }
                } else if (item.getPrintAreaType().equals("C")) {
                    if (this.m_lastHeaderRow >= 0) {
                        row = sheet.getRow(this.m_lastHeaderRow + 1);
                        if (row == null) {
                            row = sheet.createRow(this.m_lastHeaderRow + 1);
                        }
                    } else {
                        row = sheet.getRow(this.m_firstHeaderRow);
                    }
                } else if (item.getPrintAreaType().equals("F")) {
                    if (this.m_firstFooterRow >= 0) {
                        row = sheet.getRow(this.m_firstFooterRow);
                    } else {
                        row = sheet.getRow(sheet.getLastRowNum() + 1);
                        if (row == null) {
                            row = sheet.createRow(sheet.getLastRowNum() + 1);
                        }
                        this.m_firstFooterRow = row.getRowNum();
                    }
                }
                this.m_previousFormRow = row.getRowNum();
            } else {
                int offset = item.getYPosition() / 20;
                if (item.getPrintAreaType().equals("H")) {
                    row = sheet.getRow(this.m_firstHeaderRow + offset);
                    if (row == null) {
                        row = sheet.createRow(this.m_firstHeaderRow + offset);
                    }
                    if (row.getRowNum() > this.m_lastHeaderRow) {
                        this.m_lastHeaderRow = row.getRowNum();
                    }
                } else if (item.getPrintAreaType().equals("C")) {
                    int firstContentRow = this.m_lastHeaderRow >= 0 ? this.m_lastHeaderRow + 1 : this.m_firstHeaderRow;
                    row = sheet.getRow(firstContentRow + offset);
                    if (row == null) {
                        row = sheet.createRow(firstContentRow + offset);
                    }
                } else if (item.getPrintAreaType().equals("F")) {
                    if (this.m_firstFooterRow == -1) {
                        this.m_firstFooterRow = sheet.getLastRowNum() + 1;
                    }
                    if ((row = sheet.getRow(this.m_firstFooterRow + offset)) == null) {
                        row = sheet.createRow(this.m_firstFooterRow + offset);
                    }
                }
                this.m_previousFormRow = row.getRowNum();
            }
        }
        return row;
    }

    @Override
    protected boolean isSetFormRowPosition(int col) {
        Object value;
        Object object = value = col >= 0 && col < this.columns.size() ? this.columns.get(col) : null;
        if (value instanceof MPrintFormatItem) {
            MPrintFormatItem item = (MPrintFormatItem)value;
            return item.isSetNLPosition();
        }
        return super.isSetFormRowPosition(col);
    }

    @Override
    protected boolean isSuppressNull(int col) {
        Object value;
        Object object = value = col >= 0 && col < this.columns.size() ? this.columns.get(col) : null;
        if (value instanceof MPrintFormatItem) {
            MPrintFormatItem item = (MPrintFormatItem)value;
            return item.isSuppressNull();
        }
        return super.isSuppressNull(col);
    }

    @Override
    protected boolean isVisible(int row, int col) {
        MPrintFormatItem item;
        String displayLogic;
        Object value;
        Object object = value = col >= 0 && col < this.columns.size() ? this.columns.get(col) : null;
        if (value instanceof MPrintFormatItem && !Util.isEmpty(displayLogic = (item = (MPrintFormatItem)value).getDisplayLogic(), true)) {
            if (this.m_printData.getRowIndex() != row) {
                this.m_printData.setRowIndex(row);
            }
            PrintDataEvaluatee evaluatee = new PrintDataEvaluatee(null, this.m_printData);
            return Evaluator.evaluateLogic(evaluatee, displayLogic);
        }
        return super.isVisible(row, col);
    }
}

