/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.ComponentBlackListService;
import org.adempiere.base.equinox.StackTraceCommand;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.extractor.ExtractorProvider;
import org.apache.poi.extractor.MainExtractorFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbookFactory;
import org.apache.poi.ooxml.extractor.POIXMLExtractorFactory;
import org.apache.poi.sl.usermodel.SlideShowFactory;
import org.apache.poi.sl.usermodel.SlideShowProvider;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.usermodel.WorkbookProvider;
import org.apache.poi.xslf.usermodel.XSLFSlideShowFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.compiere.Adempiere;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;

public class BaseActivator
implements BundleActivator {
    private static BundleContext bundleContext = null;
    private ComponentBlackListService blacklistService;
    private static Map<String, Map<String, ServiceTracker<?, ?>>> trackerCache = new HashMap();

    public void start(BundleContext context) throws Exception {
        this.loadInitProperties(Adempiere.getAdempiereHome());
        bundleContext = context;
        context.registerService(CommandProvider.class.getName(), (Object)new StackTraceCommand(), null);
        this.blacklistService = new ComponentBlackListService(context);
        WorkbookFactory.addProvider((WorkbookProvider)new HSSFWorkbookFactory());
        WorkbookFactory.addProvider((WorkbookProvider)new XSSFWorkbookFactory());
        SlideShowFactory.addProvider((SlideShowProvider)new XSLFSlideShowFactory());
        ExtractorFactory.addProvider((ExtractorProvider)new POIXMLExtractorFactory());
        ExtractorFactory.addProvider((ExtractorProvider)new MainExtractorFactory());
    }

    private void loadInitProperties(String filePath) {
        Properties props = new Properties();
        String fileName = filePath + File.separator + "idempiereInit.properties";
        File env = new File(fileName);
        boolean loadOk = true;
        if (env.exists() && env.isFile() && env.canRead()) {
            block14: {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(env);
                        props.load(fis);
                    }
                    catch (Exception e) {
                        loadOk = false;
                        System.err.println("Exception while loading idempiereInit.properties: " + e.toString());
                        try {
                            fis.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (loadOk) {
                String key = null;
                String value = null;
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    key = (String)enumeration.nextElement();
                    value = props.getProperty(key);
                    System.setProperty(key, value);
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
        for (Map<String, ServiceTracker<?, ?>> cacheMap : trackerCache.values()) {
            for (ServiceTracker<?, ?> cacheTracker : cacheMap.values()) {
                if (cacheTracker.getTrackingCount() == -1) continue;
                cacheTracker.close();
            }
        }
        trackerCache.clear();
        if (this.blacklistService != null) {
            this.blacklistService.stop(context);
            this.blacklistService = null;
        }
        WorkbookFactory.removeProvider(HSSFWorkbookFactory.class);
        WorkbookFactory.removeProvider(XSSFWorkbookFactory.class);
        SlideShowFactory.removeProvider(XSLFSlideShowFactory.class);
        ExtractorFactory.removeProvider(POIXMLExtractorFactory.class);
        ExtractorFactory.removeProvider(MainExtractorFactory.class);
        Adempiere.stop();
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ServiceTracker<T, T> getServiceTracker(Class<T> type, Filter filter) {
        ServiceTracker tracker = null;
        String className = type.getName();
        Map<String, ServiceTracker<?, ?>> cacheMap = null;
        Map<String, Map<String, ServiceTracker<?, ?>>> map = trackerCache;
        synchronized (map) {
            cacheMap = trackerCache.get(className);
            if (cacheMap == null) {
                cacheMap = new HashMap();
                trackerCache.put(className, cacheMap);
            }
        }
        String filterKey = filter.toString();
        Map<String, ServiceTracker<?, ?>> map2 = cacheMap;
        synchronized (map2) {
            ServiceTracker cacheTracker = cacheMap.get(filterKey);
            if (cacheTracker == null) {
                tracker = new ServiceTracker(bundleContext, filter, null);
                cacheMap.put(filterKey, tracker);
            } else {
                tracker = cacheTracker;
            }
        }
        return tracker;
    }
}

