/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.credit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.logging.Level;
import org.adempiere.base.CreditStatus;
import org.adempiere.base.ICreditManager;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CreditManagerInvoice
implements ICreditManager {
    protected transient CLogger log = CLogger.getCLogger(CreditManagerInvoice.class);
    private MInvoice mInvoice;

    public CreditManagerInvoice(MInvoice po) {
        this.mInvoice = po;
    }

    @Override
    public CreditStatus checkCreditStatus(String docAction) {
        Object errorMsg = null;
        if ("PR".equals(docAction) && this.mInvoice.isSOTrx()) {
            MBPartner bp;
            MDocType doc = (MDocType)this.mInvoice.getC_DocTypeTarget();
            if ((doc.getDocBaseType().equals("ARC") && this.mInvoice.getGrandTotal().signum() < 0 || doc.getDocBaseType().equals("ARI") && this.mInvoice.getGrandTotal().signum() > 0) && "S".equals((bp = new MBPartner(this.mInvoice.getCtx(), this.mInvoice.getC_BPartner_ID(), this.mInvoice.get_TrxName())).getSOCreditStatus())) {
                errorMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
            }
        } else if ("CO".equals(docAction)) {
            BigDecimal newBalance;
            boolean fromPOS = false;
            if (this.mInvoice.getC_Order_ID() > 0) {
                fromPOS = this.mInvoice.getC_Order().getC_POS_ID() > 0;
            }
            MBPartner bp = new MBPartner(this.mInvoice.getCtx(), this.mInvoice.getC_BPartner_ID(), this.mInvoice.get_TrxName());
            DB.getDatabase().forUpdate(bp, 0);
            BigDecimal invAmt = null;
            int baseCurrencyId = Env.getContextAsInt(this.mInvoice.getCtx(), "$C_Currency_ID");
            if (this.mInvoice.getC_Currency_ID() != baseCurrencyId && this.mInvoice.isOverrideCurrencyRate()) {
                invAmt = this.mInvoice.getGrandTotal(true).multiply(this.mInvoice.getCurrencyRate());
                int stdPrecision = MCurrency.getStdPrecision(this.mInvoice.getCtx(), baseCurrencyId);
                if (invAmt.scale() > stdPrecision) {
                    invAmt = invAmt.setScale(stdPrecision, RoundingMode.HALF_UP);
                }
            } else {
                invAmt = MConversionRate.convertBase(this.mInvoice.getCtx(), this.mInvoice.getGrandTotal(true), this.mInvoice.getC_Currency_ID(), this.mInvoice.getDateAcct(), this.mInvoice.getC_ConversionType_ID(), this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
            }
            if (invAmt == null) {
                errorMsg = MConversionRateUtil.getErrorMessage(this.mInvoice.getCtx(), "ErrorConvertingCurrencyToBaseCurrency", this.mInvoice.getC_Currency_ID(), MClient.get(this.mInvoice.getCtx()).getC_Currency_ID(), this.mInvoice.getC_ConversionType_ID(), this.mInvoice.getDateAcct(), this.mInvoice.get_TrxName());
            }
            if ((newBalance = bp.getTotalOpenBalance()) == null) {
                newBalance = Env.ZERO;
            }
            if (this.mInvoice.isSOTrx()) {
                BigDecimal newLifeAmt;
                newBalance = newBalance.add(invAmt);
                if (bp.getFirstSale() == null) {
                    bp.setFirstSale(this.mInvoice.getDateInvoiced());
                }
                newLifeAmt = (newLifeAmt = bp.getActualLifeTimeValue()) == null ? invAmt : newLifeAmt.add(invAmt);
                BigDecimal newCreditAmt = bp.getSO_CreditUsed();
                newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.add(invAmt);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("GrandTotal=" + String.valueOf(this.mInvoice.getGrandTotal(true)) + "(" + String.valueOf(invAmt) + ") BP Life=" + String.valueOf(bp.getActualLifeTimeValue()) + "->" + String.valueOf(newLifeAmt) + ", Credit=" + String.valueOf(bp.getSO_CreditUsed()) + "->" + String.valueOf(newCreditAmt) + ", Balance=" + String.valueOf(bp.getTotalOpenBalance()) + " -> " + String.valueOf(newBalance));
                }
                bp.setActualLifeTimeValue(newLifeAmt);
                bp.setSO_CreditUsed(newCreditAmt);
            } else {
                newBalance = newBalance.subtract(invAmt);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("GrandTotal=" + String.valueOf(this.mInvoice.getGrandTotal(true)) + "(" + String.valueOf(invAmt) + ") Balance=" + String.valueOf(bp.getTotalOpenBalance()) + " -> " + String.valueOf(newBalance));
                }
            }
            if (!"B".equals(this.mInvoice.getPaymentRule()) || fromPOS) {
                bp.setTotalOpenBalance(newBalance);
            }
            bp.setSOCreditStatus();
            if (!bp.save(this.mInvoice.get_TrxName())) {
                errorMsg = "Could not update Business Partner";
            }
        }
        return new CreditStatus((String)errorMsg, !Util.isEmpty(errorMsg));
    }
}

