/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_ProductionPlan;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MProductionPlan;
import org.compiere.model.MQualityTest;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MProductionLine
extends X_M_ProductionLine {
    private static final long serialVersionUID = 3720901152312853611L;
    protected MProduction productionParent;

    public MProductionLine(Properties ctx, String M_ProductionLine_UU, String trxName) {
        super(ctx, M_ProductionLine_UU, trxName);
        if (Util.isEmpty(M_ProductionLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MProductionLine(Properties ctx, int M_ProductionLine_ID, String trxName) {
        this(ctx, M_ProductionLine_ID, trxName, null);
    }

    public MProductionLine(Properties ctx, int M_ProductionLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_ProductionLine_ID, trxName, virtualColumns);
        if (M_ProductionLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setLine(0);
        this.setM_AttributeSetInstance_ID(0);
        this.setM_ProductionLine_ID(0);
        this.setM_Production_ID(0);
        this.setMovementQty(Env.ZERO);
        this.setProcessed(false);
    }

    public MProductionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLine(MProduction header) {
        super(header.getCtx(), 0, header.get_TrxName());
        this.setM_Production_ID(header.get_ID());
        this.setAD_Client_ID(header.getAD_Client_ID());
        this.setAD_Org_ID(header.getAD_Org_ID());
        this.productionParent = header;
    }

    public MProductionLine(MProductionPlan header) {
        super(header.getCtx(), 0, header.get_TrxName());
        this.setM_ProductionPlan_ID(header.get_ID());
        this.setAD_Client_ID(header.getAD_Client_ID());
        this.setAD_Org_ID(header.getAD_Org_ID());
    }

    public String createTransactions(Timestamp date, boolean mustBeStocked) {
        String slASIString;
        MAttributeSetInstance slASI;
        BigDecimal lineQty;
        String asiString;
        int reversalId = this.getProductionReversalId();
        if (reversalId <= 0) {
            int deleted = this.deleteMA();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Deleted " + deleted + " attribute records ");
            }
        }
        MProduct prod = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Loaded Product " + prod.toString());
        }
        if (!prod.isStocked() || prod.getProductType().compareTo("I") != 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Production Line " + this.getLine() + " does not require stock movement");
            }
            return "";
        }
        StringBuilder errorString = new StringBuilder();
        MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        MAttributeSet attributeset = prod.getM_AttributeSet_ID() > 0 ? MAttributeSet.get(prod.getM_AttributeSet_ID()) : null;
        boolean isAutoGenerateLot = false;
        if (attributeset != null) {
            isAutoGenerateLot = attributeset.isAutoGenerateLot();
        }
        String string = asiString = asi.get_ID() > 0 ? asi.getDescription() : "";
        if (asiString == null) {
            asiString = "";
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "asi Description is: " + asiString);
        }
        if (this.getM_Product_ID() == this.getEndProduct_ID()) {
            MProductionLineMA lineMA;
            Timestamp t;
            if (reversalId <= 0 && isAutoGenerateLot && this.getM_AttributeSetInstance_ID() == 0) {
                asi = MAttributeSetInstance.generateLot(this.getCtx(), (MProduct)this.getM_Product(), this.get_TrxName());
                this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            }
            Timestamp dateMPolicy = date;
            if (this.getM_AttributeSetInstance_ID() > 0 && (t = MStorageOnHand.getDateMaterialPolicy(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_Locator_ID(), this.get_TrxName())) != null) {
                dateMPolicy = t;
            }
            dateMPolicy = Util.removeTime(dateMPolicy);
            if (reversalId <= 0 && !(lineMA = new MProductionLineMA(this, asi.get_ID(), this.getMovementQty(), dateMPolicy)).save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                errorString.append("Could not save MA for " + this.toString() + "\n");
            }
            MTransaction matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P+", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), this.getMovementQty(), date, this.get_TrxName());
            matTrx.setM_ProductionLine_ID(this.get_ID());
            if (!matTrx.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                errorString.append("Could not save transaction for " + this.toString() + "\n");
            }
            MStorageOnHand storage = MStorageOnHand.getCreate(this.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), dateMPolicy, this.get_TrxName());
            storage.addQtyOnHand(this.getMovementQty());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Created finished goods line " + this.getLine());
            }
            return errorString.toString();
        }
        MStorageOnHand[] storages = MStorageOnHand.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName(), false, 0);
        MProductionLineMA lineMA = null;
        MTransaction matTrx = null;
        BigDecimal qtyToMove = this.getMovementQty().negate();
        if (qtyToMove.signum() > 0) {
            int sl = 0;
            while (sl < storages.length) {
                lineQty = storages[sl].getQtyOnHand();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "QtyAvailable " + String.valueOf(lineQty));
                }
                if (lineQty.signum() > 0) {
                    if (lineQty.compareTo(qtyToMove) > 0) {
                        lineQty = qtyToMove;
                    }
                    slASI = storages[sl].getM_AttributeSetInstance_ID() > 0 ? new MAttributeSetInstance(this.getCtx(), storages[sl].getM_AttributeSetInstance_ID(), this.get_TrxName()) : null;
                    String string2 = slASIString = slASI != null ? slASI.getDescription() : "";
                    if (slASIString == null) {
                        slASIString = "";
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                    }
                    if (asi.getM_AttributeSet_ID() == 0 || slASIString.equals(asiString)) {
                        lineMA = MProductionLineMA.get(this, storages[sl].getM_AttributeSetInstance_ID(), storages[sl].getDateMaterialPolicy());
                        lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                        if (!lineMA.save(this.get_TrxName())) {
                            this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                            errorString.append("Could not save MA for " + this.toString() + "\n");
                        } else if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Saved MA for " + this.toString());
                        }
                        matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), lineMA.getM_AttributeSetInstance_ID(), lineQty.negate(), date, this.get_TrxName());
                        matTrx.setM_ProductionLine_ID(this.get_ID());
                        if (!matTrx.save(this.get_TrxName())) {
                            this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                            errorString.append("Could not save transaction for " + this.toString() + "\n");
                        } else if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                        }
                        DB.getDatabase().forUpdate(storages[sl], 120);
                        storages[sl].addQtyOnHand(lineQty.negate());
                        qtyToMove = qtyToMove.subtract(lineQty);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, this.getLine() + " Qty moved = " + String.valueOf(lineQty) + ", Remaining = " + String.valueOf(qtyToMove));
                        }
                    }
                }
                if (qtyToMove.signum() != 0) {
                    ++sl;
                    continue;
                }
                break;
            }
        } else if (qtyToMove.signum() < 0) {
            MClientInfo m_clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
            MAcctSchema acctSchema = new MAcctSchema(this.getCtx(), m_clientInfo.getC_AcctSchema1_ID(), this.get_TrxName());
            if (asi.get_ID() == 0 && "B".equals(prod.getCostingLevel(acctSchema))) {
                String sqlWhere = "M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID > 0 ";
                MStorageOnHand storage = (MStorageOnHand)new Query(this.getCtx(), "M_StorageOnHand", sqlWhere, this.get_TrxName()).setParameters(this.getM_Product_ID(), this.getM_Locator_ID()).setOrderBy("DateMaterialPolicy DESC,M_AttributeSetInstance_ID DESC").first();
                if (storage != null) {
                    this.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                    asi = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    asiString = asi.get_ID() > 0 ? asi.getDescription() : "";
                } else {
                    String costingMethod = prod.getCostingMethod(acctSchema);
                    StringBuilder localWhereClause = new StringBuilder("M_Product_ID =?").append(" AND C_AcctSchema_ID=?").append(" AND ce.CostingMethod = ? ").append(" AND CurrentCostPrice <> 0 ");
                    MCost cost = (MCost)new Query(this.getCtx(), "M_Cost", localWhereClause.toString(), this.get_TrxName()).setParameters(this.getM_Product_ID(), acctSchema.get_ID(), costingMethod).addJoinClause(" INNER JOIN M_CostElement ce ON (M_Cost.M_CostElement_ID =ce.M_CostElement_ID ) ").setOrderBy("Updated DESC").first();
                    if (cost != null) {
                        this.setM_AttributeSetInstance_ID(cost.getM_AttributeSetInstance_ID());
                        asi = new MAttributeSetInstance(this.getCtx(), cost.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        asiString = asi.getDescription();
                    } else {
                        this.log.log(Level.SEVERE, "Cannot retrieve cost of Product r " + prod.toString());
                        errorString.append("Cannot retrieve cost of Product " + prod.toString());
                    }
                }
            }
        }
        if (qtyToMove.signum() != 0) {
            if (mustBeStocked && qtyToMove.signum() > 0) {
                MLocator loc = new MLocator(this.getCtx(), this.getM_Locator_ID(), this.get_TrxName());
                errorString.append("Insufficient qty on hand of " + prod.toString() + " at " + loc.toString() + "\n");
            } else {
                MStorageOnHand storage = MStorageOnHand.getCreate(Env.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), date, this.get_TrxName(), true);
                lineQty = qtyToMove;
                slASI = storage.getM_AttributeSetInstance_ID() > 0 ? new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName()) : null;
                String string3 = slASIString = slASI != null ? slASI.getDescription() : "";
                if (slASIString == null) {
                    slASIString = "";
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                }
                if (asi.getM_AttributeSet_ID() == 0 || slASIString.compareTo(asiString) == 0) {
                    lineMA = MProductionLineMA.get(this, storage.getM_AttributeSetInstance_ID(), storage.getDateMaterialPolicy());
                    lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                    if (!lineMA.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                        errorString.append("Could not save MA for " + this.toString() + "\n");
                    } else if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Saved MA for " + this.toString());
                    }
                    matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), lineQty.negate(), date, this.get_TrxName());
                    matTrx.setM_ProductionLine_ID(this.get_ID());
                    if (!matTrx.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                        errorString.append("Could not save transaction for " + this.toString() + "\n");
                    } else if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                    }
                    storage.addQtyOnHand(lineQty.negate());
                    qtyToMove = qtyToMove.subtract(lineQty);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, this.getLine() + " Qty moved = " + String.valueOf(lineQty) + ", Remaining = " + String.valueOf(qtyToMove));
                    }
                } else {
                    errorString.append("Storage doesn't match ASI " + prod.toString() + " / " + slASIString + " vs. " + asiString + "\n");
                }
            }
        }
        return errorString.toString();
    }

    protected int getEndProduct_ID() {
        if (this.productionParent != null) {
            return this.productionParent.getM_Product_ID();
        }
        if (this.getM_Production_ID() > 0) {
            return this.getM_Production().getM_Product_ID();
        }
        return this.getM_ProductionPlan().getM_Product_ID();
    }

    protected int deleteMA() {
        String sql = "DELETE FROM M_ProductionLineMA WHERE M_ProductionLine_ID = " + this.get_ID();
        int count = DB.executeUpdateEx(sql, this.get_TrxName());
        return count;
    }

    @Override
    public String toString() {
        if (this.getM_Product_ID() == 0) {
            return "No product defined for production line " + this.getLine();
        }
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        return "Production line:" + this.getLine() + " -- " + String.valueOf(this.getMovementQty()) + " of " + product.getValue();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.productionParent == null && this.getM_Production_ID() > 0) {
            this.productionParent = new MProduction(this.getCtx(), this.getM_Production_ID(), this.get_TrxName());
        }
        if (this.getM_Production_ID() > 0) {
            if (newRecord && this.productionParent.isProcessed()) {
                this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Production_ID"));
                return false;
            }
            if (this.productionParent.getM_Product_ID() == this.getM_Product_ID() && this.productionParent.getProductionQty().signum() == this.getMovementQty().signum()) {
                this.setIsEndProduct(true);
            } else {
                this.setIsEndProduct(false);
            }
        } else {
            I_M_ProductionPlan plan = this.getM_ProductionPlan();
            MProduction prod = new MProduction(this.getCtx(), plan.getM_Production_ID(), this.get_TrxName());
            if (newRecord && prod.isProcessed()) {
                this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Production_ID"));
                return false;
            }
            if (plan.getM_Product_ID() == this.getM_Product_ID() && plan.getProductionQty().signum() == this.getMovementQty().signum()) {
                this.setIsEndProduct(true);
            } else {
                this.setIsEndProduct(false);
            }
        }
        if (this.isEndProduct() && this.getM_AttributeSetInstance_ID() != 0) {
            String where = "M_QualityTest_ID IN (SELECT M_QualityTest_ID FROM M_Product_QualityTest WHERE M_Product_ID=?) AND M_QualityTest_ID NOT IN (SELECT M_QualityTest_ID FROM M_QualityTestResult WHERE M_AttributeSetInstance_ID=?)";
            List tests = new Query(this.getCtx(), "M_QualityTest", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID()).list();
            for (MQualityTest test : tests) {
                test.createResult(this.getM_AttributeSetInstance_ID());
            }
        }
        if (!this.isEndProduct()) {
            this.setMovementQty(this.getQtyUsed().negate());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        this.deleteMA();
        return true;
    }

    public int getProductionReversalId() {
        if (this.getM_Production_ID() > 0) {
            return DB.getSQLValueEx(this.get_TrxName(), "SELECT Reversal_ID FROM M_Production WHERE M_Production_ID=?", this.getM_Production_ID());
        }
        return DB.getSQLValueEx(this.get_TrxName(), "SELECT p.Reversal_ID FROM M_ProductionPlan pp INNER JOIN M_Production p ON (pp.M_Production_ID = p.M_Production_ID) WHERE pp.M_ProductionPlan_ID=?", this.getM_ProductionPlan_ID());
    }

    public MProductionLineMA[] getLineMAs() {
        ArrayList<MProductionLineMA> list = new ArrayList<MProductionLineMA>();
        String sql = "SELECT pl.M_ProductionLine_ID, pl,M_AttributeSetInstance_ID , pl.MovementQty, pl.DateMaterialPolicy FROM M_ProductionLineMA pl WHERE pl.M_ProductionLine_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MProductionLineMA(this, rs.getInt(2), rs.getBigDecimal(3), rs.getTimestamp(4)));
                }
            }
            catch (SQLException ex) {
                throw new AdempiereException("Unable to load production lines", ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MProductionLineMA[] retValue = new MProductionLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

