/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.WarehouseLocatorConflictException;
import org.adempiere.util.IReservationTracer;
import org.adempiere.util.IReservationTracerFactory;
import org.compiere.model.I_M_AttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorType;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLine;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class MInOutLine
extends X_M_InOutLine {
    private static final long serialVersionUID = 8630611882798722864L;
    private MProduct m_product = null;
    private int m_M_Warehouse_ID = 0;
    private MInOut m_parent = null;

    public static MInOutLine[] getOfProduct(Properties ctx, int M_Product_ID, String where, String trxName) {
        String whereClause = "M_Product_ID=?" + (String)(!Util.isEmpty(where, true) ? " AND " + where : "");
        List<MInOutLine> list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(M_Product_ID).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] getOfOrderLine(Properties ctx, int C_OrderLine_ID, String where, String trxName) {
        String whereClause = "C_OrderLine_ID=?" + (String)(!Util.isEmpty(where, true) ? " AND " + where : "");
        List<MInOutLine> list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(C_OrderLine_ID).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] getOfRMALine(Properties ctx, int M_RMALine_ID, String where, String trxName) {
        String whereClause = "M_RMALine_ID=? " + (String)(!Util.isEmpty(where, true) ? " AND " + where : "");
        List<MInOutLine> list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(M_RMALine_ID).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] get(Properties ctx, int C_OrderLine_ID, String trxName) {
        return MInOutLine.getOfOrderLine(ctx, C_OrderLine_ID, null, trxName);
    }

    public MInOutLine(Properties ctx, String M_InOutLine_UU, String trxName) {
        super(ctx, M_InOutLine_UU, trxName);
        if (Util.isEmpty(M_InOutLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MInOutLine(Properties ctx, int M_InOutLine_ID, String trxName) {
        this(ctx, M_InOutLine_ID, trxName, null);
    }

    public MInOutLine(Properties ctx, int M_InOutLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_InOutLine_ID, trxName, virtualColumns);
        if (M_InOutLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setM_AttributeSetInstance_ID(0);
        this.setConfirmedQty(Env.ZERO);
        this.setPickedQty(Env.ZERO);
        this.setScrappedQty(Env.ZERO);
        this.setTargetQty(Env.ZERO);
        this.setIsInvoiced(false);
        this.setIsDescription(false);
    }

    public MInOutLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLine(MInOut inout) {
        this(inout.getCtx(), 0, inout.get_TrxName());
        this.setClientOrg(inout);
        this.setM_InOut_ID(inout.getM_InOut_ID());
        this.setM_Warehouse_ID(inout.getM_Warehouse_ID());
        this.setC_Project_ID(inout.getC_Project_ID());
        this.m_parent = inout;
    }

    public MInOut getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        MProduct product = oLine.getProduct();
        if (product == null) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
        } else {
            this.setM_Product_ID(oLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            if (product.isItem()) {
                if (M_Locator_ID == 0) {
                    this.setM_Locator_ID(Qty);
                } else {
                    this.setM_Locator_ID(M_Locator_ID);
                }
            } else {
                this.set_ValueNoCheck("M_Locator_ID", null);
            }
        }
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setDescription(oLine.getDescription());
        this.setIsDescription(oLine.isDescription());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
    }

    public void setInvoiceLine(MInvoiceLine iLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        this.setLine(iLine.getLine());
        this.setC_UOM_ID(iLine.getC_UOM_ID());
        int M_Product_ID = iLine.getM_Product_ID();
        if (M_Product_ID == 0) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
        } else {
            this.setM_Product_ID(M_Product_ID);
            this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
            if (M_Locator_ID == 0) {
                this.setM_Locator_ID(Qty);
            } else {
                this.setM_Locator_ID(M_Locator_ID);
            }
        }
        this.setC_Charge_ID(iLine.getC_Charge_ID());
        this.setDescription(iLine.getDescription());
        this.setIsDescription(iLine.isDescription());
        this.setC_Project_ID(iLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(iLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(iLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(iLine.getC_Activity_ID());
        this.setC_Campaign_ID(iLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(iLine.getAD_OrgTrx_ID());
        this.setUser1_ID(iLine.getUser1_ID());
        this.setUser2_ID(iLine.getUser2_ID());
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            this.m_M_Warehouse_ID = this.getParent().getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public void setM_Warehouse_ID(int warehouse_ID) {
        this.m_M_Warehouse_ID = warehouse_ID;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
        if (M_Locator_ID < 0) {
            throw new IllegalArgumentException("M_Locator_ID is mandatory.");
        }
        this.set_Value("M_Locator_ID", (Object)M_Locator_ID);
    }

    public void setM_Locator_ID(BigDecimal Qty) {
        if (this.getM_Locator_ID() != 0) {
            return;
        }
        if (this.getM_Product_ID() == 0) {
            this.set_ValueNoCheck("M_Locator_ID", null);
            return;
        }
        int M_Locator_ID = MStorageOnHand.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), Qty, this.get_TrxName());
        if (M_Locator_ID == 0) {
            MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        }
        this.setM_Locator_ID(M_Locator_ID);
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setMovementQty(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product = this.getProduct();
        if (MovementQty != null && product != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setMovementQty(MovementQty);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        if (M_Product_ID != 0) {
            super.setM_Product_ID(M_Product_ID);
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
        this.m_product = null;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MOrderLine orderLine;
        int C_UOM_ID;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("");
        }
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_InOut_ID"));
            return false;
        }
        if (this.getParent().pendingConfirmations() && (newRecord || this.is_ValueChanged("MovementQty") && !this.is_ValueChanged("TargetQty")) && this.getMovementQty().signum() == 0) {
            String docAction = this.getParent().getDocAction();
            String docStatus = this.getParent().getDocStatus();
            if (!("VO".equals(docAction) && ("DR".equals(docStatus) || "IN".equals(docStatus) || "IP".equals(docStatus) || "AP".equals(docStatus) || "NA".equals(docStatus)) || "CO".equals(docAction) && "IP".equals(docStatus))) {
                this.log.saveError("SaveError", Msg.parseTranslation(this.getCtx(), "@Open@: @M_InOutConfirm_ID@"));
                return false;
            }
        }
        if (this.getProduct() != null && "I".equals(this.getProduct().getProductType()) && this.getM_Locator_ID() <= 0 && this.getC_Charge_ID() <= 0) {
            MWarehouse warehouse = MWarehouse.get(this.getM_Warehouse_ID());
            if (warehouse != null) {
                int m_Locator_ID = this.getProduct().getM_Locator_ID();
                if (m_Locator_ID > 0 && MLocator.get(m_Locator_ID).getM_Warehouse_ID() == warehouse.getM_Warehouse_ID()) {
                    this.setM_Locator_ID(m_Locator_ID);
                } else {
                    MLocator defaultLocator = warehouse.getDefaultLocator();
                    if (defaultLocator != null) {
                        this.setM_Locator_ID(defaultLocator.getM_Locator_ID());
                    }
                }
            }
            if (this.getM_Locator_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"M_Locator_ID"});
            }
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_InOutLine WHERE M_InOut_ID=?";
            int ii = DB.getSQLValueEx(this.get_TrxName(), sql, this.getM_InOut_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(Env.getContextAsInt(this.getCtx(), "#C_UOM_ID"));
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("MovementQty")) {
            this.setMovementQty(this.getMovementQty());
        }
        if (this.getC_OrderLine_ID() == 0 && this.getM_RMALine_ID() == 0 && this.getParent().isSOTrx()) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "C_OrderLine_ID"));
            return false;
        }
        if (this.getM_Locator_ID() > 0) {
            MLocatorType lt;
            MLocator locator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
            if (this.getM_Warehouse_ID() != locator.getM_Warehouse_ID()) {
                throw new WarehouseLocatorConflictException(MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID()), locator, this.getLine());
            }
            if ("C-".equals(this.getParent().getMovementType()) && locator.getM_LocatorType_ID() > 0 && !(lt = MLocatorType.get(this.getCtx(), locator.getM_LocatorType_ID())).isAvailableForShipping()) {
                this.log.saveError("Error", Msg.translate(this.getCtx(), "LocatorNotAvailableForShipping"));
                return false;
            }
        }
        I_M_AttributeSet attributeset = null;
        if (this.getM_Product_ID() > 0) {
            attributeset = MProduct.get(this.getCtx(), this.getM_Product_ID()).getM_AttributeSet();
        }
        boolean isAutoGenerateLot = false;
        if (attributeset != null) {
            isAutoGenerateLot = attributeset.isAutoGenerateLot();
        }
        if (this.getReversalLine_ID() == 0 && !this.getParent().isSOTrx() && !this.getParent().getMovementType().equals("V-") && isAutoGenerateLot && this.getM_AttributeSetInstance_ID() == 0) {
            MAttributeSetInstance asi = MAttributeSetInstance.generateLot(this.getCtx(), (MProduct)this.getM_Product(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        if (this.getParent().getC_DocType().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "ChargeOrProductMandatory"));
            return false;
        }
        if (MSysConfig.getBooleanValue("VALIDATE_MATCHING_PRODUCT_ON_SHIPMENT", true, Env.getAD_Client_ID(this.getCtx())) && this.getC_OrderLine_ID() > 0 && (orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName())).getM_Product_ID() != this.getM_Product_ID()) {
            this.log.saveError("MInOutLineAndOrderLineProductDifferent", (this.getM_Product_ID() > 0 ? MProduct.get(this.getM_Product_ID()).getValue() : "") + " <> " + (orderLine.getM_Product_ID() > 0 ? MProduct.get(orderLine.getM_Product_ID()).getValue() : ""));
            return false;
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (!this.getParent().getDocStatus().equals("DR")) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
            return false;
        }
        if (this.getParent().pendingConfirmations()) {
            this.log.saveError("DeleteError", Msg.parseTranslation(this.getCtx(), "@Open@: @M_InOutConfirm_ID@"));
            return false;
        }
        List<MInvoiceLine> ils = new Query(this.getCtx(), "C_InvoiceLine", "M_InOutLine_ID=?", this.get_TrxName()).setParameters(this.getM_InOutLine_ID()).list();
        ils.forEach(il -> {
            il.setM_InOutLine_ID(-1);
            il.saveEx();
        });
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInOutLine[").append(this.get_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",QtyEntered=").append(this.getQtyEntered()).append(",MovementQty=").append(this.getMovementQty()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    public BigDecimal getBase(String CostDistribution) {
        if ("C".equals(CostDistribution)) {
            MInvoiceLine m_il = MInvoiceLine.getOfInOutLine(this);
            if (m_il == null && (m_il = MInvoiceLine.getOfInOutLineFromMatchInv(this)) == null) {
                this.log.severe("No Invoice Line for: " + this.toString());
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(m_il.getPriceActual());
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return this.getMovementQty();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }

    public boolean sameOrderLineUOM() {
        if (this.getC_OrderLine_ID() <= 0) {
            return false;
        }
        MOrderLine oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        return oLine.getC_UOM_ID() == this.getC_UOM_ID();
    }

    public boolean matchToInvoiceLine(int C_InvoiceLine_ID, BigDecimal qty) {
        MMatchPO matchPO;
        BigDecimal matchedQty;
        boolean success = false;
        if (C_InvoiceLine_ID <= 0) {
            throw new IllegalArgumentException("Invalid C_InvoiceLine_ID argument: " + C_InvoiceLine_ID);
        }
        MInvoiceLine iLine = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, this.get_TrxName());
        if (iLine.get_ID() != C_InvoiceLine_ID) {
            throw new IllegalArgumentException("Invalid C_InvoiceLine_ID argument: " + C_InvoiceLine_ID);
        }
        iLine.setM_InOutLine_ID(this.get_ID());
        if (this.getC_OrderLine_ID() != 0) {
            iLine.setC_OrderLine_ID(this.getC_OrderLine_ID());
        }
        iLine.saveEx();
        if (iLine.getM_Product_ID() != 0) {
            String ignoreError;
            MMatchInv match = new MMatchInv(iLine, null, qty);
            match.setM_InOutLine_ID(this.get_ID());
            match.saveEx();
            success = true;
            if (MClient.isClientAccountingImmediate() && (ignoreError = DocumentEngine.postImmediate(match.getCtx(), match.getAD_Client_ID(), match.get_Table_ID(), match.get_ID(), true, match.get_TrxName())) != null) {
                this.log.warning(ignoreError);
            }
        } else {
            success = true;
        }
        if (iLine.getM_Product_ID() != 0 && (matchedQty = DB.getSQLValueBD(iLine.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID=?", iLine.getC_InvoiceLine_ID())).add(qty).compareTo(iLine.getQtyInvoiced()) <= 0 && (matchPO = MMatchPO.create(iLine, this, null, qty)) != null) {
            String ignoreError;
            matchPO.saveEx();
            if (MClient.isClientAccountingImmediate() && (ignoreError = DocumentEngine.postImmediate(matchPO.getCtx(), matchPO.getAD_Client_ID(), matchPO.get_Table_ID(), matchPO.get_ID(), true, matchPO.get_TrxName())) != null) {
                this.log.warning(ignoreError);
            }
        }
        return success;
    }

    public boolean matchToOrderLine(int C_OrderLine_ID, BigDecimal qty) {
        BigDecimal toDeliver;
        boolean success = false;
        MOrderLine oLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, this.get_TrxName());
        BigDecimal storageReservationToUpdate = null;
        if (oLine.get_ID() != 0) {
            storageReservationToUpdate = oLine.getQtyReserved();
            oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
            if (oLine.getQtyReserved().signum() == -1) {
                oLine.setQtyReserved(Env.ZERO);
            } else if (oLine.getQtyDelivered().compareTo(oLine.getQtyOrdered()) > 0) {
                oLine.setQtyReserved(Env.ZERO);
            }
            oLine.saveEx();
            storageReservationToUpdate = storageReservationToUpdate.subtract(oLine.getQtyReserved());
        }
        if ((toDeliver = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered())).signum() < 0) {
            toDeliver = Env.ZERO;
        }
        if (this.getMovementQty().compareTo(toDeliver) <= 0) {
            this.setC_OrderLine_ID(C_OrderLine_ID);
            this.saveEx();
        } else if (this.getC_OrderLine_ID() != 0) {
            this.setC_OrderLine_ID(0);
            this.saveEx();
        }
        if (this.getM_Product_ID() != 0) {
            MMatchPO match = MMatchPO.getOrCreate(C_OrderLine_ID, qty, this, this.get_TrxName());
            match.setC_OrderLine_ID(C_OrderLine_ID);
            if (!match.save()) {
                String msg = "PO Match not created: " + String.valueOf(match);
                ValueNamePair error = CLogger.retrieveError();
                if (error != null) {
                    msg = msg + ". " + error.getName();
                }
                throw new AdempiereException(msg);
            }
            success = true;
            if (oLine.get_ID() > 0 && oLine.getM_Product_ID() > 0 && oLine.getProduct().isStocked() && storageReservationToUpdate != null) {
                IReservationTracer tracer = null;
                IReservationTracerFactory factory = Core.getReservationTracerFactory();
                if (factory != null) {
                    tracer = factory.newTracer(this.getParent().getC_DocType_ID(), this.getParent().getDocumentNo(), this.getLine(), this.get_Table_ID(), this.get_ID(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getParent().isSOTrx(), this.get_TrxName());
                }
                success = MStorageReservation.add(Env.getCtx(), oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), storageReservationToUpdate.negate(), oLine.getParent().isSOTrx(), this.get_TrxName(), tracer);
            }
        } else {
            success = true;
        }
        return success;
    }
}

