/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_C_DepositBatch;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MDepositBatch
extends X_C_DepositBatch
implements DocAction {
    private static final long serialVersionUID = 7691820074981291939L;
    private String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public MDepositBatch(Properties ctx, String C_DepositBatch_UU, String trxName) {
        super(ctx, C_DepositBatch_UU, trxName);
        if (Util.isEmpty(C_DepositBatch_UU)) {
            this.setInitialDefaults();
        }
    }

    public MDepositBatch(Properties ctx, int C_DepositBatch_ID, String trxName) {
        super(ctx, C_DepositBatch_ID, trxName);
        if (C_DepositBatch_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocStatus("DR");
        this.setDocAction("CO");
        this.setProcessed(false);
        this.setDepositAmt(Env.ZERO);
    }

    public MDepositBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDepositBatch(MDepositBatch original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setC_DepositBatch_ID(original.getC_DepositBatch_ID());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setDateDoc(original.getDateDoc());
        this.setDateDeposit(original.getDateDeposit());
        this.setDepositAmt(original.getDepositAmt());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("C_Currency_ID")) {
            String sql = "SELECT COUNT(1) FROM C_DepositBatchLine WHERE C_DepositBatch_ID=?";
            int ii = DB.getSQLValueEx(this.get_TrxName(), sql, this.getC_DepositBatch_ID());
            if (ii > 0) {
                this.log.saveError("SaveError", Msg.translate(this.getCtx(), "ErrorCurrencyCouldNotModify"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setDateAcct(Timestamp DateAcct) {
        super.setDateDeposit(DateAcct);
        if (DateAcct == null) {
            return;
        }
    }

    @Override
    @Deprecated
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    @Deprecated
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM C_BankStatementLine WHERE C_DepositBatch_ID = ?", this.getC_DepositBatch_ID()) == 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "DepositBatchVoidFailedBankStatementLine");
            return false;
        }
        MDepositBatchLine[] lines = this.getLines();
        int i = 0;
        while (i < lines.length) {
            MDepositBatchLine line = lines[i];
            if (line.getPayAmt().compareTo(Env.ZERO) != 0) {
                if (line.getC_Payment_ID() != 0) {
                    MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                    if (payment.isReconciled()) {
                        this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentIsAlreadyReconciled") + String.valueOf(payment);
                        return false;
                    }
                    payment.setC_DepositBatch_ID(0);
                    payment.saveEx(this.get_TrxName());
                }
                line.setPayAmt(Env.ZERO);
                line.setProcessed(true);
                line.saveEx();
            }
            ++i;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setDepositAmt(Env.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDepositBatch[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",Amount=").append(this.getDepositAmt()).append("]");
        return sb.toString();
    }

    @Override
    @Deprecated
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    @Deprecated
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    @Deprecated
    public File createPDF(File file) {
        return null;
    }

    @Override
    @Deprecated
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    @Deprecated
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    @Deprecated
    public BigDecimal getApprovalAmt() {
        return this.getDepositAmt();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (this.getC_DepositBatch_ID() != 0) {
            String sql = "UPDATE C_Payment p SET C_DepositBatch_ID= 0  WHERE p.C_DepositBatch_ID=?";
            DB.executeUpdateEx(sql, new Object[]{this.getC_DepositBatch_ID()}, this.get_TrxName());
        }
        return success;
    }

    public MDepositBatchLine[] getLines() {
        ArrayList<MDepositBatchLine> list;
        block6: {
            list = new ArrayList<MDepositBatchLine>();
            String sql = "SELECT * FROM C_DepositBatchLine WHERE C_DepositBatch_ID=? ORDER BY Line,C_DepositBatchLine_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_DepositBatch_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MDepositBatchLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        MDepositBatchLine[] retValue = new MDepositBatchLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Deprecated
    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    @Override
    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDepositBatchLine[] lines = this.getLines();
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MDepositBatchLine line = lines[i];
            if (line.isActive()) {
                total = total.add(line.getPayAmt());
            }
            ++i;
        }
        this.setDepositAmt(total);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        String sql = "SELECT COUNT(DISTINCT C_Currency_ID) FROM C_Payment p INNER JOIN C_DepositBatchLine dbl ON dbl.C_Payment_ID = p.C_Payment_ID WHERE dbl.C_DepositBatch_ID = ? ";
        int currencyCount = DB.getSQLValueEx(this.get_TrxName(), sql, this.getC_DepositBatch_ID());
        if (currencyCount > 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "ErrorMultipleCurrencyPaymentsRestricted", new Object[]{this.getC_Currency().getISO_Code()});
            return "IN";
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("completeIt - " + this.toString());
        }
        MDepositBatchLine[] depositbatchLines = this.getLines();
        int line = 0;
        while (line < depositbatchLines.length) {
            depositbatchLines[line].setProcessed(true);
            depositbatchLines[line].saveEx();
            ++line;
        }
        this.updateHeaderAmt();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("ReactivateIt - " + this.toString());
        }
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM C_BankStatementLine WHERE C_DepositBatch_ID = ?", this.getC_DepositBatch_ID()) == 1) {
            this.m_processMsg = Msg.getMsg(this.getCtx(), "DepositBatchReactivationFailedBankStatementLine");
            return false;
        }
        MDepositBatchLine[] depositbatchLines = this.getLines();
        int line = 0;
        while (line < depositbatchLines.length) {
            if (depositbatchLines[line].getC_Payment().isReconciled()) {
                this.m_processMsg = Msg.getMsg(this.getCtx(), "NotAllowReActivationOfReconciledPaymentsIntoBatch") + String.valueOf(depositbatchLines[line].getC_Payment());
                return false;
            }
            depositbatchLines[line].setProcessed(false);
            depositbatchLines[line].saveEx();
            ++line;
        }
        this.setProcessed(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "DepositBatchAmt")).append("=").append(this.getDepositAmt());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    private void updateHeaderAmt() {
        BigDecimal depositAmt = DB.getSQLValueBDEx(this.get_TrxName(), "SELECT COALESCE(SUM(PayAmt),0) FROM C_DepositBatchLine WHERE C_DepositBatch_ID=? AND IsActive='Y'", this.getC_DepositBatch_ID());
        MDepositBatch batch = new MDepositBatch(this.getCtx(), this.getC_DepositBatch_ID(), this.get_TrxName());
        batch.setDepositAmt(depositAmt);
        batch.saveEx(this.get_TrxName());
    }
}

