/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListItem;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Listitem;

public class Listbox
extends org.zkoss.zul.Listbox
implements EventListener<Event> {
    private static final long serialVersionUID = -3713350125429939476L;
    private List<EventListener<Event>> doubleClickListeners = new ArrayList<EventListener<Event>>();
    private List<EventListener<Event>> onDropListeners = new ArrayList<EventListener<Event>>();
    private boolean draggable;
    private String oddRowSclass;

    public Listbox() {
        this.oddRowSclass = super.getOddRowSclass();
        super.setOddRowSclass(this.oddRowSclass);
    }

    public Listbox(KeyNamePair[] pairs) {
        if (pairs != null && pairs.length > 0) {
            KeyNamePair[] keyNamePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair pair = keyNamePairArray[n2];
                this.appendItem(pair.getName(), pair.getKey());
                ++n2;
            }
        }
        this.oddRowSclass = super.getOddRowSclass();
        super.setOddRowSclass(this.oddRowSclass);
    }

    public void setEnabled(boolean enabled) {
        this.setDisabled(!enabled);
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public ListItem appendItem(String label, Object value) {
        ListItem item = new ListItem(label, value);
        super.appendChild((Component)item);
        return item;
    }

    public ListItem appendItem(String label, String value) {
        ListItem item = new ListItem(label, value);
        super.appendChild((Component)item);
        return item;
    }

    public ListItem getItemAtIndex(int index) {
        return (ListItem)super.getItemAtIndex(index);
    }

    public ListItem getSelectedItem() {
        return (ListItem)super.getSelectedItem();
    }

    public void setValue(Object value) {
        this.setSelectedItem(null);
        if (value == null) {
            return;
        }
        List items = this.getItems();
        for (Listitem item : items) {
            if (value.getClass() != item.getValue().getClass()) {
                String stringItem;
                String stringValue = value.toString();
                if (!stringValue.equals(stringItem = item.getValue().toString())) continue;
                this.setSelectedItem(item);
                break;
            }
            if (!value.equals(item.getValue())) continue;
            this.setSelectedItem(item);
            break;
        }
    }

    public ListHead getListHead() {
        return (ListHead)super.getListhead();
    }

    public int[] getSelectedIndices() {
        Set selectedItems = this.getSelectedItems();
        int[] selecteds = new int[this.getSelectedCount()];
        int i = 0;
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            selecteds[i] = this.getIndexOfItem(listItem);
            ++i;
        }
        return selecteds;
    }

    public void setSelectedIndices(int[] selected) {
        if (selected != null && selected.length > 0) {
            this.setSelectedIndex(selected[0]);
            int i = 1;
            while (i < selected.length) {
                this.addItemToSelection(this.getItemAtIndex(selected[i]));
                ++i;
            }
        } else {
            this.clearSelection();
        }
    }

    public void addOnDropListener(EventListener<Event> listener) {
        this.onDropListeners.add(listener);
    }

    public void addDoubleClickListener(EventListener<Event> listener) {
        this.doubleClickListeners.add(listener);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof ListItem) {
            newChild.addEventListener("onDoubleClick", (EventListener)this);
            if (this.onDropListeners.size() > 0) {
                ((ListItem)newChild).setDroppable("true");
                newChild.addEventListener("onDrop", (EventListener)this);
            }
            if (this.isItemDraggable()) {
                ((ListItem)newChild).setDraggable("true");
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    public boolean isItemDraggable() {
        return this.draggable;
    }

    public void setItemDraggable(boolean b) {
        this.draggable = b;
    }

    public void onEvent(Event event) throws Exception {
        block3: {
            block2: {
                if (!"onDoubleClick".equals(event.getName()) || this.doubleClickListeners.isEmpty()) break block2;
                for (EventListener<Event> listener : this.doubleClickListeners) {
                    listener.onEvent(event);
                }
                break block3;
            }
            if (!"onDrop".equals(event.getName()) || this.onDropListeners.isEmpty()) break block3;
            for (EventListener<Event> listener : this.onDropListeners) {
                listener.onEvent(event);
            }
        }
    }

    public void addItem(KeyNamePair pp) {
        this.appendItem(pp.getName(), pp.getKey());
    }

    public void removeAllItems() {
        int cnt = this.getItemCount();
        int i = cnt - 1;
        while (i >= 0) {
            this.removeItemAt(i);
            --i;
        }
    }

    public void removeActionListener(EventListener<Event> listener) {
        this.removeEventListener("onSelect", listener);
    }

    public void addActionListener(EventListener<Event> listener) {
        this.addEventListener("onSelect", listener);
    }

    public void addItem(ValueNamePair pp) {
        this.appendItem(pp.getName(), pp.getValue());
    }

    public void setSelectedValueNamePair(ValueNamePair vp) {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            ListItem item = this.getItemAtIndex(i);
            if (vp.getValue().equals(item.getValue())) {
                this.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public void setSelectedKeyNamePair(KeyNamePair kp) {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            ListItem item = this.getItemAtIndex(i);
            if (item.getValue() instanceof Integer && kp.getKey() == ((Integer)item.getValue()).intValue()) {
                this.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void afterInsert(Component comp) {
        super.afterInsert(comp);
        if ("select".equals(this.getMold()) && comp instanceof Listitem && this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public boolean removeChild(Component child) {
        boolean b = super.removeChild(child);
        if (b && "select".equals(this.getMold()) && child instanceof Listitem && this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        return b;
    }

    public String getOddRowSclass() {
        if (this.oddRowSclass == null) {
            return null;
        }
        return super.getOddRowSclass();
    }

    public void setOddRowSclass(String scls) {
        this.oddRowSclass = scls != null && scls.length() == 0 ? null : scls;
        super.setOddRowSclass(scls);
    }

    public String toString() {
        StringBuilder items = new StringBuilder("[");
        for (Listitem item : this.getItems()) {
            if (items.length() > 1) {
                items.append(", ");
            }
            items.append(item.toString());
        }
        items.append("]");
        return items.toString();
    }

    public Object getValue() {
        ListItem item = this.getSelectedItem();
        return item.getValue();
    }
}

