/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.model.MUserDefField;
import org.compiere.model.MUserDefProcParameter;
import org.compiere.model.MValRule;
import org.compiere.model.X_AD_FieldGroup;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class GridFieldVO
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4069340866487289281L;
    public Properties ctx = null;
    public int WindowNo;
    public int TabNo;
    public int AD_Window_ID;
    public int AD_Process_ID_Of_Panel;
    public int AD_Window_ID_Of_Panel;
    public int AD_InfoWindow_ID_Of_Panel;
    public int AD_Tab_ID;
    public boolean tabReadOnly = false;
    public boolean isProcess = false;
    public String ColumnName = "";
    public String ColumnSQL;
    public String Header = "";
    public int displayType = 0;
    public int AD_Table_ID = 0;
    public int AD_Column_ID = 0;
    public int DisplayLength = 0;
    public boolean IsSameLine = false;
    public boolean IsDisplayed = false;
    public boolean IsDisplayedGrid = false;
    public int SeqNo = 0;
    public int SeqNoGrid = 0;
    public String DisplayLogic = "";
    public String DefaultValue = "";
    public boolean IsMandatory = false;
    public boolean IsReadOnly = false;
    public boolean IsUpdateable = false;
    public boolean IsAlwaysUpdateable = false;
    public boolean IsHeading = false;
    public boolean IsFieldOnly = false;
    public boolean IsEncryptedField = false;
    public boolean IsEncryptedColumn = false;
    public boolean IsSelectionColumn = false;
    public int SeqNoSelection = 0;
    public int SortNo = 0;
    public int FieldLength = 0;
    public String VFormat = "";
    public String FormatPattern;
    public String ValueMin = "";
    public String ValueMax = "";
    public String FieldGroup = "";
    public String FieldGroupType = "";
    public boolean IsKey = false;
    public boolean IsParent = false;
    public String Callout = "";
    public int AD_Process_ID = 0;
    public int AD_InfoWindow_ID = 0;
    public String Description = "";
    public String Help = "";
    public String MandatoryLogic = "";
    public String ReadOnlyLogic = "";
    public String AlwaysUpdatableLogic = "";
    public String ObscureType = null;
    public boolean IsDefaultFocus = false;
    public String ValidationCode = "";
    public String ValidationCodeLookup = "";
    public int AD_Reference_Value_ID = 0;
    public boolean isRange = false;
    public String DefaultValue2 = "";
    public String dateRangeOption = "";
    public MLookupInfo lookupInfo = null;
    public String EntityType = null;
    public int AD_Field_ID = 0;
    public int XPosition = 0;
    public int ColumnSpan = 0;
    public int NumLines = 0;
    public int Included_Tab_ID = 0;
    public boolean IsCollapsedByDefault = false;
    public boolean IsAutocomplete = false;
    public boolean IsAllowCopy = false;
    public String IsToolbarButton = "N";
    public int AD_Chart_ID = 0;
    public int AD_LabelStyle_ID = 0;
    public int AD_FieldStyle_ID = 0;
    public int PA_DashboardContent_ID = 0;
    public String Placeholder = "";
    public String Placeholder2 = "";
    public boolean IsHtml = false;
    public boolean IsQuickForm = false;
    public boolean IsShowNegateButton = false;

    public static String getSQL(Properties ctx) {
        StringBuilder sql;
        MRole role = MRole.getDefault(ctx, false);
        String advancedFilter = " AND IsAdvancedField='N' ";
        if (!Env.isBaseLanguage(ctx, "AD_Tab")) {
            sql = new StringBuilder("SELECT * FROM AD_Field_vt WHERE AD_Tab_ID=?").append(" AND AD_Language='" + Env.getAD_Language(ctx) + "'");
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY IsDisplayed DESC, SeqNo");
        } else {
            sql = new StringBuilder("SELECT * FROM AD_Field_v WHERE AD_Tab_ID=?");
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY IsDisplayed DESC, SeqNo");
        }
        return sql.toString();
    }

    public static GridFieldVO create(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean readOnly, ResultSet rs) {
        GridFieldVO vo = GridFieldVO.createFromResultSet(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly, rs);
        return vo.afterCreate();
    }

    public GridFieldVO afterCreate() {
        MUserDefField userDef;
        MClient client;
        GridFieldVO vo = this;
        if (vo.IsDisplayed && !(client = MClient.get(this.ctx)).isDisplayField(vo.AD_Field_ID)) {
            vo.IsDisplayed = false;
        }
        if ((userDef = MUserDefField.get(vo.ctx, vo.AD_Field_ID, vo.AD_Tab_ID, vo.AD_Window_ID)) != null) {
            vo.EntityType = vo.EntityType + "**U**";
            if (userDef.getName() != null) {
                vo.Header = userDef.getName();
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
            if (userDef.getDisplayLength() > 0) {
                vo.DisplayLength = userDef.getDisplayLength();
            }
            if (userDef.getDisplayLogic() != null) {
                vo.DisplayLogic = userDef.getDisplayLogic();
            }
            if (userDef.getDefaultValue() != null) {
                vo.DefaultValue = userDef.getDefaultValue();
            }
            if (userDef.getSortNo() > 0) {
                vo.SortNo = userDef.getSortNo();
            }
            if (userDef.getIsDisplayed() != null) {
                vo.IsDisplayed = "Y".equals(userDef.getIsDisplayed());
            }
            if (userDef.getIsReadOnly() != null) {
                vo.IsReadOnly = "Y".equals(userDef.getIsReadOnly());
            }
            if (userDef.getIsSameLine() != null) {
                vo.IsSameLine = "Y".equals(userDef.getIsSameLine());
            }
            if (userDef.getIsUpdateable() != null) {
                vo.IsUpdateable = "Y".equals(userDef.getIsUpdateable());
            }
            if (userDef.getIsAlwaysUpdateable() != null) {
                vo.IsAlwaysUpdateable = "Y".equals(userDef.getIsAlwaysUpdateable());
            }
            if (userDef.getAlwaysUpdatableLogic() != null) {
                vo.AlwaysUpdatableLogic = userDef.getAlwaysUpdatableLogic();
            }
            if (userDef.getReadOnlyLogic() != null) {
                vo.ReadOnlyLogic = userDef.getReadOnlyLogic();
            }
            if (userDef.getMandatoryLogic() != null) {
                vo.MandatoryLogic = userDef.getMandatoryLogic();
            }
            if (userDef.getAD_Reference_ID() > 0) {
                vo.displayType = userDef.getAD_Reference_ID();
            }
            if (userDef.getAD_Reference_Value_ID() > 0) {
                vo.AD_Reference_Value_ID = userDef.getAD_Reference_Value_ID();
            }
            if (userDef.getIsMandatory() != null) {
                vo.IsMandatory = "Y".equals(userDef.getIsMandatory());
            }
            if (userDef.getXPosition() > 0) {
                vo.XPosition = userDef.getXPosition();
            }
            if (userDef.getColumnSpan() > 0) {
                vo.ColumnSpan = userDef.getColumnSpan();
            }
            if (userDef.getNumLines() > 0) {
                vo.NumLines = userDef.getNumLines();
            }
            if (userDef.getIsToolbarButton() != null) {
                vo.IsToolbarButton = userDef.getIsToolbarButton();
            }
            if (userDef.getVFormat() != null) {
                vo.VFormat = userDef.getVFormat();
            }
            if (userDef.getSeqNo() > 0) {
                vo.SeqNo = userDef.getSeqNo();
            }
            if (userDef.getIsDisplayedGrid() != null) {
                vo.IsDisplayedGrid = "Y".equals(userDef.getIsDisplayedGrid());
            }
            if (userDef.getSeqNoGrid() > 0) {
                vo.SeqNoGrid = userDef.getSeqNoGrid();
            }
            if (userDef.getAD_Val_Rule_ID() > 0) {
                vo.ValidationCode = MValRule.get(vo.ctx, userDef.getAD_Val_Rule_ID()).getCode();
            }
            if (userDef.getAD_Val_Rule_Lookup_ID() > 0) {
                vo.ValidationCodeLookup = MValRule.get(this.ctx, userDef.getAD_Val_Rule_Lookup_ID()).getCode();
            }
            if (userDef.getAD_LabelStyle_ID() > 0) {
                vo.AD_LabelStyle_ID = userDef.getAD_LabelStyle_ID();
            }
            if (userDef.getAD_FieldStyle_ID() > 0) {
                vo.AD_FieldStyle_ID = userDef.getAD_FieldStyle_ID();
            }
            if (userDef.getPA_DashboardContent_ID() > 0) {
                vo.PA_DashboardContent_ID = userDef.getPA_DashboardContent_ID();
            }
            if (userDef.getPlaceholder() != null) {
                vo.Placeholder = userDef.getPlaceholder();
            }
            if (userDef.getAD_FieldGroup_ID() > 0) {
                vo.FieldGroup = ((X_AD_FieldGroup)userDef.getAD_FieldGroup()).get_Translation("Name");
                vo.FieldGroupType = userDef.getAD_FieldGroup().getFieldGroupType();
            }
            if (userDef.getIsAutocomplete() != null) {
                vo.IsAutocomplete = "Y".equals(userDef.getIsAutocomplete());
            }
            if (userDef.getAD_Chart_ID() > 0) {
                vo.AD_Chart_ID = userDef.getAD_Chart_ID();
            }
            if (userDef.getIsHtml() != null) {
                vo.IsHtml = "Y".equals(userDef.getIsHtml());
            }
        }
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createFromResultSet(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean readOnly, ResultSet rs) {
        GridFieldVO vo;
        block5: {
            vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, readOnly);
            try {
                vo.ColumnName = rs.getString("ColumnName");
                if (vo.ColumnName != null) break block5;
                return null;
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        vo.Header = rs.getString("Name");
        vo.displayType = rs.getInt("AD_Reference_ID");
        vo.AD_Column_ID = rs.getInt("AD_Column_ID");
        vo.AD_Table_ID = rs.getInt("AD_Table_ID");
        vo.DisplayLength = rs.getInt("DisplayLength");
        vo.IsSameLine = "Y".equals(rs.getString("IsSameLine"));
        vo.IsDisplayed = "Y".equals(rs.getString("IsDisplayed"));
        vo.IsDisplayedGrid = "Y".equals(rs.getString("IsDisplayedGrid"));
        vo.SeqNo = rs.getInt("SeqNo");
        vo.SeqNoGrid = rs.getInt("SeqNoGrid");
        vo.DisplayLogic = rs.getString("DisplayLogic");
        vo.DefaultValue = rs.getString("DefaultValue");
        vo.IsMandatory = "Y".equals(rs.getString("IsMandatory"));
        vo.IsReadOnly = "Y".equals(rs.getString("IsReadOnly"));
        vo.IsUpdateable = "Y".equals(rs.getString("IsUpdateable"));
        vo.IsAlwaysUpdateable = "Y".equals(rs.getString("IsAlwaysUpdateable"));
        vo.IsHeading = "Y".equals(rs.getString("IsHeading"));
        vo.IsFieldOnly = "Y".equals(rs.getString("IsFieldOnly"));
        vo.IsEncryptedField = "Y".equals(rs.getString("IsEncryptedField"));
        vo.IsEncryptedColumn = "Y".equals(rs.getString("IsEncryptedColumn"));
        vo.IsSelectionColumn = "Y".equals(rs.getString("IsSelectionColumn"));
        vo.SeqNoSelection = rs.getInt("SeqNoSelection");
        vo.SortNo = rs.getInt("SortNo");
        vo.FieldLength = rs.getInt("FieldLength");
        vo.VFormat = rs.getString("VFormat");
        vo.FormatPattern = rs.getString("FormatPattern");
        vo.ValueMin = rs.getString("ValueMin");
        vo.ValueMax = rs.getString("ValueMax");
        vo.FieldGroup = rs.getString("FieldGroup");
        vo.FieldGroupType = rs.getString("FieldGroupType");
        vo.IsKey = "Y".equals(rs.getString("IsKey"));
        vo.IsParent = "Y".equals(rs.getString("IsParent"));
        String s = rs.getString("Description");
        vo.Description = s != null ? s.intern() : s;
        s = rs.getString("Help");
        vo.Help = s != null ? s.intern() : s;
        vo.Callout = rs.getString("Callout");
        vo.AD_Process_ID = rs.getInt("AD_Process_ID");
        vo.AD_InfoWindow_ID = rs.getInt("AD_InfoWindow_ID");
        vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
        vo.AlwaysUpdatableLogic = rs.getString("AlwaysUpdatableLogic");
        vo.MandatoryLogic = rs.getString("MandatoryLogic");
        vo.ObscureType = rs.getString("ObscureType");
        vo.IsDefaultFocus = "Y".equals(rs.getString("IsDefaultFocus"));
        vo.AD_Reference_Value_ID = rs.getInt("AD_Reference_Value_ID");
        vo.ValidationCode = rs.getString("ValidationCode");
        vo.ValidationCodeLookup = rs.getString("ValidationCodeLookup");
        vo.IsQuickForm = "Y".equals(rs.getString("IsQuickForm"));
        vo.ColumnSQL = rs.getString("ColumnSQL");
        if (vo.ColumnSQL != null && !vo.ColumnSQL.startsWith("@SQL=") && !vo.ColumnSQL.startsWith("@SQLFIND=") && vo.ColumnSQL.contains("@")) {
            vo.ColumnSQL = Env.parseContext(ctx, -1, vo.ColumnSQL, false, true);
        }
        vo.Included_Tab_ID = rs.getInt("Included_Tab_ID");
        vo.IsCollapsedByDefault = "Y".equals(rs.getString("IsCollapsedByDefault"));
        vo.IsAutocomplete = "Y".equals(rs.getString("IsAutocomplete"));
        vo.IsAllowCopy = "Y".equals(rs.getString("IsAllowCopy"));
        vo.AD_Field_ID = rs.getInt("AD_Field_ID");
        vo.XPosition = rs.getInt("XPosition");
        vo.ColumnSpan = rs.getInt("ColumnSpan");
        vo.NumLines = rs.getInt("NumLines");
        vo.IsToolbarButton = rs.getString("IsToolbarButton");
        vo.AD_Chart_ID = rs.getInt("AD_Chart_ID");
        vo.AD_LabelStyle_ID = rs.getInt("AD_LabelStyle_ID");
        vo.AD_FieldStyle_ID = rs.getInt("AD_FieldStyle_ID");
        vo.PA_DashboardContent_ID = rs.getInt("PA_DashboardContent_ID");
        vo.Placeholder = rs.getString("Placeholder");
        vo.IsHtml = "Y".equals(rs.getString("IsHtml"));
        vo.EntityType = rs.getString("EntityType");
        if (vo.Header == null) {
            vo.Header = vo.ColumnName;
        }
        return vo;
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int ProcessIDOfPanel, int WindowIDOfPanel, int InfoWindowIDOfPanel, ResultSet rs) {
        return GridFieldVO.createParameter(ctx, WindowNo, 0, ProcessIDOfPanel, WindowIDOfPanel, InfoWindowIDOfPanel, rs);
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int TabNo, int ProcessIDOfPanel, int WindowIDOfPanel, int InfoWindowIDOfPanel, ResultSet rs) {
        MUserDefProcParameter userDef;
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.AD_Process_ID_Of_Panel = ProcessIDOfPanel;
        vo.AD_Window_ID_Of_Panel = WindowIDOfPanel;
        vo.AD_InfoWindow_ID_Of_Panel = InfoWindowIDOfPanel;
        try {
            vo.AD_Table_ID = 0;
            vo.AD_Column_ID = rs.getInt("AD_Process_Para_ID");
            vo.ColumnName = rs.getString("ColumnName");
            vo.Header = rs.getString("Name");
            vo.Description = rs.getString("Description");
            vo.Help = rs.getString("Help");
            vo.SeqNo = rs.getInt("SeqNo");
            vo.displayType = rs.getInt("AD_Reference_ID");
            vo.IsMandatory = rs.getString("IsMandatory").equals("Y");
            vo.DisplayLength = vo.FieldLength = rs.getInt("FieldLength");
            vo.DefaultValue = rs.getString("DefaultValue");
            vo.DefaultValue2 = rs.getString("DefaultValue2");
            vo.VFormat = rs.getString("VFormat");
            vo.FormatPattern = rs.getString("FormatPattern");
            vo.ValueMin = rs.getString("ValueMin");
            vo.ValueMax = rs.getString("ValueMax");
            vo.isRange = rs.getString("IsRange").equals("Y");
            vo.dateRangeOption = rs.getString("DateRangeOption");
            vo.AD_Reference_Value_ID = rs.getInt("AD_Reference_Value_ID");
            vo.ValidationCode = rs.getString("ValidationCode");
            vo.ValidationCodeLookup = rs.getString("ValidationCodeLookup");
            vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
            vo.DisplayLogic = rs.getString("DisplayLogic");
            vo.IsEncryptedField = rs.getString("IsEncrypted").equals("Y");
            vo.MandatoryLogic = rs.getString("MandatoryLogic");
            vo.Placeholder = rs.getString("Placeholder");
            vo.Placeholder2 = rs.getString("Placeholder2");
            vo.IsAutocomplete = "Y".equals(rs.getString("IsAutoComplete"));
            vo.FieldGroup = rs.getString("FieldGroup");
            vo.FieldGroupType = rs.getString("FieldGroupType");
            vo.IsCollapsedByDefault = "Y".equals(rs.getString("IsCollapsedByDefault"));
            vo.IsShowNegateButton = "Y".equals(rs.getString("IsShowNegateButton"));
            vo.EntityType = rs.getString("EntityType");
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "createParameter", e);
        }
        if (vo.IsDisplayed && (userDef = MUserDefProcParameter.get(ctx, vo.AD_Column_ID, vo.AD_Process_ID_Of_Panel)) != null) {
            if (userDef.getName() != null) {
                vo.Header = userDef.getName();
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
            if (userDef.getReadOnlyLogic() != null) {
                vo.ReadOnlyLogic = userDef.getReadOnlyLogic();
            }
            if (userDef.getDefaultValue() != null) {
                vo.DefaultValue = userDef.getDefaultValue();
            }
            if (userDef.getDisplayLogic() != null) {
                vo.DisplayLogic = userDef.getDisplayLogic();
            }
            if (userDef.getMandatoryLogic() != null) {
                vo.MandatoryLogic = userDef.getMandatoryLogic();
            }
            if (userDef.getIsDisplayed() != null) {
                vo.IsDisplayed = "Y".equals(userDef.getIsDisplayed());
            }
            if (userDef.getPlaceholder() != null) {
                vo.Placeholder = userDef.getPlaceholder();
            }
            if (userDef.getPlaceholder2() != null) {
                vo.Placeholder2 = userDef.getPlaceholder2();
            }
            if (userDef.getSeqNo() > 0) {
                vo.SeqNo = userDef.getSeqNo();
            }
            if (userDef.getAD_Reference_ID() > 0) {
                vo.displayType = userDef.getAD_Reference_ID();
            }
            if (userDef.getAD_Reference_Value_ID() > 0) {
                vo.AD_Reference_Value_ID = userDef.getAD_Reference_Value_ID();
            }
            if (userDef.getVFormat() != null) {
                vo.VFormat = userDef.getVFormat();
            }
            if (userDef.getAD_Val_Rule_ID() > 0) {
                vo.ValidationCode = MValRule.get(ctx, userDef.getAD_Val_Rule_ID()).getCode();
            }
            if (userDef.getDefaultValue2() != null) {
                vo.DefaultValue2 = userDef.getDefaultValue2();
            }
            if (userDef.getValueMin() != null) {
                vo.ValueMin = userDef.getValueMin();
            }
            if (userDef.getValueMax() != null) {
                vo.ValueMax = userDef.getValueMax();
            }
            if (userDef.getIsMandatory() != null) {
                vo.IsMandatory = "Y".equals(userDef.getIsMandatory());
            }
            if (userDef.getAD_FieldGroup_ID() > 0) {
                X_AD_FieldGroup fg = new X_AD_FieldGroup(Env.getCtx(), userDef.getAD_FieldGroup_ID(), null);
                vo.FieldGroup = fg.get_Translation("Name");
                vo.FieldGroupType = fg.getFieldGroupType();
            }
        }
        vo.initFinish();
        if (vo.DefaultValue2 == null) {
            vo.DefaultValue2 = "";
        }
        if (vo.Placeholder2 == null) {
            vo.Placeholder2 = "";
        }
        return vo;
    }

    public static GridFieldVO createParameter(GridFieldVO voF) {
        GridFieldVO voT = new GridFieldVO(voF.ctx, voF.WindowNo, voF.TabNo, voF.AD_Window_ID, voF.AD_Tab_ID, voF.tabReadOnly);
        voT.isProcess = true;
        voT.IsDisplayed = true;
        voT.IsReadOnly = false;
        voT.IsUpdateable = true;
        voT.AD_Table_ID = voF.AD_Table_ID;
        voT.AD_Column_ID = voF.AD_Column_ID;
        voT.ColumnName = voF.ColumnName;
        voT.Header = voF.Header;
        voT.Description = voF.Description;
        voT.Help = voF.Help;
        voT.displayType = voF.displayType;
        voT.IsMandatory = voF.IsMandatory;
        voT.FieldLength = voF.FieldLength;
        voT.DisplayLength = voF.FieldLength;
        voT.DefaultValue = voF.DefaultValue2;
        voT.Placeholder = voF.Placeholder2;
        voT.Placeholder2 = voF.Placeholder2;
        voT.VFormat = voF.VFormat;
        voT.FormatPattern = voF.FormatPattern;
        voT.ValueMin = voF.ValueMin;
        voT.ValueMax = voF.ValueMax;
        voT.isRange = voF.isRange;
        voT.dateRangeOption = voF.dateRangeOption;
        voT.EntityType = voF.EntityType;
        voT.AD_Reference_Value_ID = voF.AD_Reference_Value_ID;
        voT.ValidationCode = voF.ValidationCode;
        voT.ValidationCodeLookup = voF.ValidationCodeLookup;
        voT.IsEncryptedField = voF.IsEncryptedField;
        voT.ReadOnlyLogic = voF.ReadOnlyLogic;
        voT.DisplayLogic = voF.DisplayLogic;
        voT.AD_Process_ID_Of_Panel = voF.AD_Process_ID_Of_Panel;
        voT.initFinish();
        return voT;
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int WindowIDOfPanel, int infoWindowID, int AD_Column_ID, String ColumnName, String Name, int AD_Reference_ID, int AD_Reference_Value_ID, boolean IsMandatory, boolean IsEncrypted, String Placeholder) {
        return GridFieldVO.createParameter(ctx, WindowNo, WindowIDOfPanel, infoWindowID, AD_Column_ID, ColumnName, Name, AD_Reference_ID, AD_Reference_Value_ID, IsMandatory, IsEncrypted, Placeholder, null);
    }

    public static GridFieldVO createParameter(Properties ctx, int WindowNo, int WindowIDOfPanel, int infoWindowID, int AD_Column_ID, String ColumnName, String Name, int AD_Reference_ID, int AD_Reference_Value_ID, boolean IsMandatory, boolean IsEncrypted, String Placeholder, String EntityType) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, 0, 0, 0, false);
        vo.isProcess = true;
        vo.IsDisplayed = true;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.AD_Table_ID = 0;
        vo.AD_Column_ID = AD_Column_ID;
        vo.ColumnName = ColumnName;
        vo.Header = Name;
        vo.displayType = AD_Reference_ID;
        vo.AD_Reference_Value_ID = AD_Reference_Value_ID;
        vo.IsMandatory = IsMandatory;
        vo.IsEncryptedField = IsEncrypted;
        vo.AD_InfoWindow_ID_Of_Panel = infoWindowID;
        vo.AD_Window_ID_Of_Panel = WindowIDOfPanel;
        vo.Placeholder = Placeholder;
        vo.EntityType = EntityType;
        vo.initFinish();
        return vo;
    }

    public static GridFieldVO createStdField(Properties ctx, int WindowNo, int TabNo, int AD_Window_ID, int AD_Tab_ID, boolean tabReadOnly, boolean isCreated, boolean isTimestamp) {
        GridFieldVO vo = new GridFieldVO(ctx, WindowNo, TabNo, AD_Window_ID, AD_Tab_ID, tabReadOnly);
        String string = vo.ColumnName = isCreated ? "Created" : "Updated";
        if (!isTimestamp) {
            vo.ColumnName = String.valueOf(vo.ColumnName) + "By";
        }
        int n = vo.displayType = isTimestamp ? 16 : 18;
        if (!isTimestamp) {
            vo.AD_Reference_Value_ID = 110;
        }
        vo.IsDisplayed = false;
        vo.IsMandatory = false;
        vo.IsReadOnly = false;
        vo.IsUpdateable = true;
        vo.initFinish();
        return vo;
    }

    private GridFieldVO(Properties Ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
        this.TabNo = tabNo;
        this.AD_Window_ID = ad_Window_ID;
        this.AD_Tab_ID = ad_Tab_ID;
        this.tabReadOnly = TabReadOnly;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.lookupInfo != null) {
            this.lookupInfo.ctx = newCtx;
        }
    }

    protected void initFinish() {
        if (this.DisplayLogic == null) {
            this.DisplayLogic = "";
        }
        if (this.DefaultValue == null) {
            this.DefaultValue = "";
        }
        if (this.FieldGroup == null) {
            this.FieldGroup = "";
        }
        if (this.FieldGroupType == null) {
            this.FieldGroupType = "";
        }
        if (this.Description == null) {
            this.Description = "";
        }
        if (this.Help == null) {
            this.Help = "";
        }
        if (this.Callout == null) {
            this.Callout = "";
        }
        if (this.ReadOnlyLogic == null) {
            this.ReadOnlyLogic = "";
        }
        if (this.AlwaysUpdatableLogic == null) {
            this.AlwaysUpdatableLogic = "";
        }
        if (this.MandatoryLogic == null) {
            this.MandatoryLogic = "";
        }
        if (this.Placeholder == null) {
            this.Placeholder = "";
        }
        if (this.EntityType == null) {
            this.EntityType = "";
        }
        if (DisplayType.isLookup(this.displayType) && this.IsDisplayed) {
            this.loadLookupInfo();
        }
    }

    public void loadLookupInfo() {
        try {
            this.lookupInfo = MLookupFactory.getLookupInfo(this.ctx, this.WindowNo, this.TabNo, this.AD_Column_ID, this.displayType, Env.getLanguage(this.ctx), this.ColumnName, this.AD_Reference_Value_ID, this.IsParent, this.ValidationCode);
            if (this.lookupInfo == null) {
                this.displayType = 13;
            }
        }
        catch (Exception e) {
            CLogger.get().log(Level.SEVERE, "No LookupInfo for " + this.ColumnName, e);
            this.displayType = 13;
        }
    }

    public GridFieldVO clone(Properties ctx, int windowNo, int tabNo, int ad_Window_ID, int ad_Tab_ID, boolean TabReadOnly) {
        GridFieldVO clone = this.clone();
        clone.ctx = ctx;
        clone.WindowNo = windowNo;
        clone.TabNo = tabNo;
        clone.AD_Window_ID = ad_Window_ID;
        clone.AD_Tab_ID = ad_Tab_ID;
        clone.tabReadOnly = TabReadOnly;
        if (clone.lookupInfo != null) {
            clone.lookupInfo.ctx = ctx;
        }
        return clone;
    }

    public GridFieldVO clone() {
        try {
            GridFieldVO clone = (GridFieldVO)super.clone();
            clone.ctx = Env.getCtx();
            if (this.lookupInfo != null) {
                clone.ValidationCodeLookup = this.ValidationCodeLookup;
                clone.lookupInfo = this.lookupInfo.clone();
                clone.lookupInfo.ctx = clone.ctx;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GridFieldVO[");
        sb.append(this.AD_Column_ID).append("-").append(this.ColumnName).append("]");
        return sb.toString();
    }

    public static class SeqNoComparator
    implements Comparator<GridFieldVO> {
        @Override
        public int compare(GridFieldVO gf1, GridFieldVO gf2) {
            return Integer.valueOf(gf1.SeqNo).compareTo(gf2.SeqNo);
        }
    }
}

