/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pdf.Document;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.PDFReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class PDFReportRenderer
implements IReportRenderer<PDFReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(PDFReportRenderer.class);

    @Override
    public String getId() {
        return "PDF";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FilePDF");
    }

    @Override
    public String getContentType() {
        return MediaType.PDF.toString();
    }

    @Override
    public String getFileExtension() {
        return "pdf";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, PDFReportRendererConfiguration configuration) {
        try {
            OutputStream os = null;
            os = configuration.getOutputFile() != null ? new FileOutputStream(configuration.getOutputFile()) : configuration.getOutputStream();
            Document.writePDF(reportEngine.getLayout().getPageable(false), os);
            if (configuration.getOutputFile() != null) {
                ArchiveEngine.get().archive(configuration.getOutputFile(), reportEngine.getPrintInfo());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public Class<PDFReportRendererConfiguration> getConfigurationType() {
        return PDFReportRendererConfiguration.class;
    }
}

