/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.mfa;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MClient;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class EMailMechanism
implements IMFAMechanism {
    @Override
    public Object[] register(Properties ctx, MMFAMethod method, String prm, String trxName) {
        if (Util.isEmpty(prm)) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAEMailRequired"));
        }
        if (!EMail.validate(prm)) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAInvalidEMail"));
        }
        if (method.getR_MailText_ID() <= 0) {
            throw new AdempiereException("EMail method wrongly configured - requires mail template");
        }
        if (MMFARegistration.alreadyExistsValid(method, prm)) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAMethodAlreadyRegistered"));
        }
        String otp = EMailMechanism.generateRandomString(6);
        int expireMinutes = method.getExpireInMinutes();
        if (expireMinutes <= 0) {
            expireMinutes = 15;
        }
        MUser user = MUser.get(ctx);
        MMFARegistration reg = new MMFARegistration(ctx, 0, trxName);
        reg.set_ValueOfColumn("AD_Client_ID", (Object)user.getAD_Client_ID());
        reg.setAD_Org_ID(0);
        reg.setName(this.obfuscateEMail(prm));
        reg.setParameterValue(prm);
        reg.setMFA_Method_ID(method.getMFA_Method_ID());
        reg.setAD_User_ID(user.getAD_User_ID());
        reg.setMFASecret(otp);
        reg.setIsValid(false);
        reg.setIsUserMFAPreferred(false);
        reg.setExpiration(new Timestamp(System.currentTimeMillis() + (long)(expireMinutes * 60000)));
        this.saveRegistration(reg);
        MClient client = MClient.get(ctx);
        MMailText mt = new MMailText(ctx, method.getR_MailText_ID(), trxName);
        mt.setLanguage(Env.getContext(ctx, "#AD_Language"));
        mt.setUser(user.getAD_User_ID());
        mt.setPO(reg);
        String message = mt.getMailText(true);
        EMail email = client.createEMail(prm, mt.getMailHeader(), message, mt.isHtml());
        if (mt.isHtml()) {
            email.setMessageHTML(mt.getMailHeader(), message);
        } else {
            email.setSubject(mt.getMailHeader());
            email.setMessageText(message);
        }
        if (!email.isValid() && !email.isValid(true)) {
            throw new AdempiereException("The EMail is not valid, check configuration");
        }
        if (!"OK".equals(email.send())) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAProblemSendingEMail"));
        }
        MMFARegistration.invalidatePreviousPending(method, prm, reg);
        Object[] ret = new Object[]{Msg.getMsg(Env.getCtx(), "MFAEMailCodeSent"), reg};
        return ret;
    }

    public static String generateRandomString(int len) {
        String chars = "0123456789";
        Random rnd = new Random();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            sb.append(chars.charAt(rnd.nextInt(chars.length())));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String complete(Properties ctx, MMFARegistration reg, String code, String name, boolean preferred, String trxName) {
        boolean valid = code.equals(reg.getMFASecret());
        if (!valid) {
            reg.setLastFailure(new Timestamp(System.currentTimeMillis()));
            reg.setFailedLoginCount(reg.getFailedLoginCount() + 1);
            this.saveRegistration(reg);
            throw new AdempiereException(Msg.getMsg(ctx, "MFACodeInvalid"));
        }
        reg.setMFALastSecret(code);
        reg.setLastSuccess(new Timestamp(System.currentTimeMillis()));
        reg.setFailedLoginCount(0);
        reg.setIsValid(true);
        reg.setMFAValidatedAt(new Timestamp(System.currentTimeMillis()));
        reg.setExpiration(null);
        if (!Util.isEmpty(name)) {
            reg.setName(name);
        }
        if (preferred) {
            reg.setIsUserMFAPreferred(true);
        }
        this.saveRegistration(reg);
        return Msg.getMsg(ctx, "MFARegistrationCompleted");
    }

    @Override
    public String generateValidationCode(MMFARegistration reg) {
        Properties ctx = reg.getCtx();
        MMFAMethod method = new MMFAMethod(ctx, reg.getMFA_Method_ID(), reg.get_TrxName());
        String otp = EMailMechanism.generateRandomString(6);
        int expireMinutes = method.getExpireInMinutes();
        if (expireMinutes <= 0) {
            expireMinutes = 15;
        }
        MUser user = MUser.get(reg.getCtx());
        reg.setMFASecret(otp);
        reg.setExpiration(new Timestamp(System.currentTimeMillis() + (long)(expireMinutes * 60000)));
        this.saveRegistration(reg);
        String mail_to = reg.getParameterValue();
        MClient client = MClient.get(ctx);
        MMailText mt = new MMailText(ctx, method.getR_MailText_ID(), reg.get_TrxName());
        mt.setLanguage(Env.getContext(ctx, "#AD_Language"));
        mt.setUser(user.getAD_User_ID());
        mt.setPO(reg);
        String message = mt.getMailText(true);
        EMail email = client.createEMail(mail_to, mt.getMailHeader(), message, mt.isHtml());
        if (mt.isHtml()) {
            email.setMessageHTML(mt.getMailHeader(), message);
        } else {
            email.setSubject(mt.getMailHeader());
            email.setMessageText(message);
        }
        if (!email.isValid() && !email.isValid(true)) {
            throw new AdempiereException("The EMail is not valid, check configuration");
        }
        if (!"OK".equals(email.send())) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAProblemSendingEMail"));
        }
        return Msg.getMsg(Env.getCtx(), "MFAEMailValidationCodeSent", new Object[]{this.obfuscateEMail(mail_to)});
    }

    private String obfuscateEMail(String mail) {
        StringBuilder mailObfuscated = new StringBuilder();
        boolean atFound = false;
        int idx = 0;
        while (idx < mail.length()) {
            int chr = mail.charAt(idx);
            if (chr == 64) {
                atFound = true;
            } else if (!atFound && idx > 1 || atFound && idx < mail.length() - 4) {
                chr = 42;
            }
            mailObfuscated.append((char)chr);
            ++idx;
        }
        return mailObfuscated.toString();
    }

    @Override
    public String validateCode(MMFARegistration reg, String code, boolean setPreferred) {
        Properties ctx = reg.getCtx();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (reg.getExpiration() != null && now.after(reg.getExpiration())) {
            return Msg.getMsg(ctx, "MFARegistrationExpired");
        }
        if (code.equals(reg.getMFALastSecret())) {
            return Msg.getMsg(ctx, "MFACodeAlreadyConsumed");
        }
        boolean valid = code.equals(reg.getMFASecret());
        if (!valid) {
            reg.setLastFailure(new Timestamp(System.currentTimeMillis()));
            reg.setFailedLoginCount(reg.getFailedLoginCount() + 1);
            this.saveRegistration(reg);
            return Msg.getMsg(ctx, "MFACodeInvalid");
        }
        reg.setMFALastSecret(code);
        reg.setLastSuccess(new Timestamp(System.currentTimeMillis()));
        reg.setFailedLoginCount(0);
        if (setPreferred) {
            reg.setIsUserMFAPreferred(true);
        }
        this.saveRegistration(reg);
        return null;
    }

    private void saveRegistration(MMFARegistration reg) {
        reg.saveCrossTenantSafeEx();
    }
}

