/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MTablePartition;
import org.compiere.model.MViewComponent;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.model.X_AD_TablePartition;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MTable
extends X_AD_Table
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6774131577483620665L;
    public static final int MAX_OFFICIAL_ID = 999999;
    private static ImmutableIntPOCache<Integer, MTable> s_cache = new ImmutableIntPOCache("AD_Table", "AD_Table", 20, 0, false, 0);
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private static final CCache<String, IServiceReferenceHolder<IModelFactory>> s_modelFactoryCache = new CCache(null, "IModelFactory", 100, 120, false, 2000);
    private MColumn[] m_columns = null;
    private String[] m_KeyColumns = null;
    private ConcurrentMap<String, Integer> m_columnNameMap;
    private ConcurrentMap<Integer, Integer> m_columnIdMap;
    private MViewComponent[] m_viewComponents = null;
    private static final ThreadLocal<Map<Integer, String[]>> partialPOResultSetColumns = new ThreadLocal();
    private List<MColumn> partitionKeyColumns;
    private List<String> partitionKeyColumnNames;
    private List<X_AD_TablePartition> tablePartitions;
    private List<String> tablePartitionNames;
    private Boolean hasCustomTree = null;

    public static MTable get(int AD_Table_ID) {
        return MTable.get(Env.getCtx(), AD_Table_ID);
    }

    public static MTable get(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID, null);
    }

    public static synchronized MTable get(Properties ctx, int AD_Table_ID, String trxName) {
        Integer key = AD_Table_ID;
        MTable retValue = s_cache.get(ctx, key, e -> new MTable(ctx, (MTable)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTable(ctx, AD_Table_ID, trxName);
        if (retValue.get_ID() == AD_Table_ID) {
            s_cache.put(key, retValue, e -> new MTable(Env.getCtx(), (MTable)e));
            return retValue;
        }
        return null;
    }

    public static MTable getCopy(Properties ctx, int AD_Table_ID, String trxName) {
        MTable table2 = MTable.get(ctx, AD_Table_ID, trxName);
        if (table2 != null) {
            table2 = new MTable(ctx, table2, trxName);
        }
        return table2;
    }

    public static synchronized MTable get(Properties ctx, String tableName) {
        return MTable.get(ctx, tableName, null);
    }

    public static synchronized MTable get(Properties ctx, String tableName, String trxName) {
        MTable retValue;
        block10: {
            MTable[] tables;
            if (tableName == null) {
                return null;
            }
            MTable[] mTableArray = tables = s_cache.values().toArray(new MTable[0]);
            int n = tables.length;
            int n2 = 0;
            while (n2 < n) {
                retValue = mTableArray[n2];
                if (tableName.equalsIgnoreCase(retValue.getTableName())) {
                    return s_cache.get(ctx, retValue.get_ID(), e -> new MTable(ctx, (MTable)e));
                }
                ++n2;
            }
            retValue = null;
            String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setString(1, tableName.toUpperCase());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MTable(ctx, rs, trxName);
                    }
                }
                catch (Exception e2) {
                    s_log.log(Level.SEVERE, sql, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            Integer key = retValue.getAD_Table_ID();
            s_cache.put(key, retValue, e -> new MTable(Env.getCtx(), (MTable)e));
        }
        return retValue;
    }

    public static String getTableName(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    public static KeyNamePair[] getWithWindowAccessKeyNamePairs(boolean withEmptyElement, String trxName) {
        MRole role = MRole.getDefault();
        boolean trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Table");
        String lang = Env.getAD_Language(Env.getCtx());
        String sql = "SELECT DISTINCT t.AD_Table_ID," + (trl ? "trl.Name" : "t.Name") + " FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) " + (String)(trl ? "LEFT JOIN AD_Table_Trl trl on (trl.AD_Table_ID=t.AD_Table_ID and trl.AD_Language=" + DB.TO_STRING(lang) + ")" : "") + " WHERE " + role.getIncludedRolesWhereClause("wa.AD_Role_ID", null) + " AND t.IsActive='Y' AND tab.IsActive='Y' ORDER BY 2";
        return DB.getKeyNamePairsEx(trxName, sql, withEmptyElement, new Object[0]);
    }

    public static Class<?> getClass(String tableName) {
        List<IServiceReferenceHolder<IModelFactory>> factoryList;
        IServiceReferenceHolder<IModelFactory> cache = s_modelFactoryCache.get(tableName);
        if (cache != null) {
            Class<?> clazz;
            IModelFactory service = cache.getService();
            if (service != null && (clazz = service.getClass(tableName)) != null) {
                return clazz;
            }
            s_modelFactoryCache.remove(tableName);
        }
        if ((factoryList = Service.locator().list(IModelFactory.class).getServiceReferences()) == null) {
            return null;
        }
        for (IServiceReferenceHolder<IModelFactory> factory : factoryList) {
            Class<?> clazz;
            IModelFactory service = factory.getService();
            if (service == null || (clazz = service.getClass(tableName)) == null) continue;
            s_modelFactoryCache.put(tableName, factory);
            return clazz;
        }
        return null;
    }

    public MTable(Properties ctx, String AD_Table_UU, String trxName) {
        super(ctx, AD_Table_UU, trxName);
        if (Util.isEmpty(AD_Table_UU)) {
            this.setInitialDefaults();
        }
    }

    public MTable(Properties ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setAccessLevel("4");
        this.setEntityType("U");
        this.setIsChangeLog(false);
        this.setIsDeleteable(false);
        this.setIsHighVolume(false);
        this.setIsSecurityEnabled(false);
        this.setIsView(false);
        this.setReplicationType("L");
    }

    public MTable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTable(MTable copy) {
        this(Env.getCtx(), copy);
    }

    public MTable(Properties ctx, MTable copy) {
        this(ctx, copy, null);
    }

    public MTable(Properties ctx, MTable copy, String trxName) {
        this(ctx, -1, trxName);
        this.copyPO(copy);
        this.m_columns = copy.m_columns != null ? (MColumn[])Arrays.stream(copy.m_columns).map(e -> new MColumn(ctx, (MColumn)e, trxName)).toArray(MColumn[]::new) : null;
        this.m_columnNameMap = copy.m_columnNameMap != null ? new ConcurrentHashMap<String, Integer>(copy.m_columnNameMap) : null;
        this.m_columnIdMap = copy.m_columnIdMap != null ? new ConcurrentHashMap<Integer, Integer>(copy.m_columnIdMap) : null;
        this.m_viewComponents = copy.m_viewComponents != null ? (MViewComponent[])Arrays.stream(copy.m_viewComponents).map(e -> new MViewComponent(ctx, (MViewComponent)e, trxName)).toArray(MViewComponent[]::new) : null;
    }

    public synchronized MColumn[] getColumns(boolean requery) {
        ArrayList<MColumn> list;
        block9: {
            if (this.m_columns != null && !requery) {
                return this.m_columns;
            }
            this.m_columnNameMap = new ConcurrentHashMap<String, Integer>();
            this.m_columnIdMap = new ConcurrentHashMap<Integer, Integer>();
            String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID=? AND IsActive='Y' ORDER BY ColumnName";
            list = new ArrayList<MColumn>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Table_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MColumn column = new MColumn(this.getCtx(), rs, this.get_TrxName());
                        if (this.is_Immutable()) {
                            column.markImmutable();
                        }
                        list.add(column);
                        this.m_columnNameMap.put(column.getColumnName().toUpperCase(), list.size() - 1);
                        this.m_columnIdMap.put(column.getAD_Column_ID(), list.size() - 1);
                    }
                }
                catch (Exception e2) {
                    this.log.log(Level.SEVERE, sql, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MColumn mColumn = e.markImmutable();
            });
        }
        this.m_columns = new MColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        int idx = this.getColumnIndex(columnName);
        if (idx < 0) {
            return null;
        }
        return this.m_columns[idx];
    }

    public synchronized int getColumnIndex(String ColumnName) {
        Integer i2;
        if (this.m_columns == null) {
            this.getColumns(false);
        }
        if ((i2 = (Integer)this.m_columnNameMap.get(ColumnName.toUpperCase())) != null) {
            return i2;
        }
        return -1;
    }

    public synchronized boolean columnExistsInDB(String ColumnName) {
        MColumn column = this.getColumn(ColumnName);
        return column != null && !column.isVirtualColumn();
    }

    public synchronized boolean columnExistsInDictionary(String ColumnName) {
        return this.getColumnIndex(ColumnName) >= 0;
    }

    public synchronized int getColumnIndex(int AD_Column_ID) {
        Integer i2;
        if (this.m_columns == null) {
            this.getColumns(false);
        }
        if ((i2 = (Integer)this.m_columnIdMap.get(AD_Column_ID)) != null) {
            return i2;
        }
        return -1;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        MColumn uuColumn;
        if (this.m_KeyColumns != null) {
            return this.m_KeyColumns;
        }
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.m_columns.length) {
            MColumn column = this.m_columns[i2];
            if (column.isKey()) {
                this.m_KeyColumns = new String[]{column.getColumnName()};
                return this.m_KeyColumns;
            }
            if (column.isParent()) {
                list.add(column.getColumnName());
            }
            ++i2;
        }
        if (list.isEmpty() && (uuColumn = this.getColumn(PO.getUUIDColumnName(this.getTableName()))) != null) {
            this.m_KeyColumns = new String[]{uuColumn.getColumnName()};
            return this.m_KeyColumns;
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        this.m_KeyColumns = retValue;
        return this.m_KeyColumns;
    }

    public boolean isIDKeyTable() {
        String idColName = this.getTableName() + "_ID";
        return this.getKeyColumns() != null && this.getKeyColumns().length == 1 && this.getKeyColumns()[0].equals(idColName);
    }

    public boolean isUUIDKeyTable() {
        String uuColName = PO.getUUIDColumnName(this.getTableName());
        return this.getKeyColumns() != null && this.getKeyColumns().length == 1 && this.getKeyColumns()[0].equals(uuColName);
    }

    public boolean hasUUIDKey() {
        String uuColName = PO.getUUIDColumnName(this.getTableName());
        if (this.m_columns == null) {
            this.getColumns(false);
        }
        return this.m_columnNameMap.get(uuColName.toUpperCase()) != null;
    }

    public String[] getIdentifierColumns() {
        ArrayList<KeyNamePair> listkn = new ArrayList<KeyNamePair>();
        MColumn[] mColumnArray = this.getColumns(false);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (column.isIdentifier()) {
                listkn.add(new KeyNamePair(column.getSeqNo(), column.getColumnName()));
            }
            ++n2;
        }
        Collections.sort(listkn, new Comparator<KeyNamePair>(){

            @Override
            public int compare(KeyNamePair s1, KeyNamePair s2) {
                if (s1.getKey() < s2.getKey()) {
                    return -1;
                }
                if (s1.getKey() > s2.getKey()) {
                    return 1;
                }
                return 0;
            }
        });
        String[] retValue = new String[listkn.size()];
        int i2 = 0;
        while (i2 < listkn.size()) {
            retValue[i2] = ((KeyNamePair)listkn.get(i2)).getName();
            ++i2;
        }
        return retValue;
    }

    public PO getPO(int Record_ID, String trxName) {
        List<IServiceReferenceHolder<IModelFactory>> factoryList;
        String tableName = this.getTableName();
        if (Record_ID != 0 && !this.isSingleKey()) {
            this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
            return null;
        }
        PO po = null;
        IServiceReferenceHolder<IModelFactory> cache = s_modelFactoryCache.get(tableName);
        if (cache != null) {
            IModelFactory service = cache.getService();
            if (service != null && (po = service.getPO(tableName, Record_ID, trxName)) != null) {
                if (po.get_ID() != Record_ID && Record_ID > 0) {
                    po = null;
                }
                return po;
            }
            s_modelFactoryCache.remove(tableName);
        }
        if ((factoryList = Service.locator().list(IModelFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder<IModelFactory> factory : factoryList) {
                IModelFactory service = factory.getService();
                if (service == null || (po = service.getPO(tableName, Record_ID, trxName)) == null) continue;
                if (po.get_ID() != Record_ID && Record_ID > 0) {
                    po = null;
                }
                s_modelFactoryCache.put(tableName, factory);
                break;
            }
        }
        if (po == null && s_modelFactoryCache.get(tableName) == null && (po = new GenericPO(tableName, this.getCtx(), Record_ID, trxName)).get_ID() != Record_ID && Record_ID > 0) {
            po = null;
        }
        return po;
    }

    protected static final String[] getPartialPOResultSetColumns(ResultSet rs) {
        Map<Integer, String[]> map = partialPOResultSetColumns.get();
        return map != null ? map.get(rs.hashCode()) : null;
    }

    public final PO getPartialPO(ResultSet rs, String[] selectColumns, String trxName) {
        try {
            HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
            map.put(rs.hashCode(), selectColumns);
            partialPOResultSetColumns.set(map);
            PO po = this.getPO(rs, trxName);
            po.makeImmutable();
            PO pO = po;
            return pO;
        }
        finally {
            partialPOResultSetColumns.remove();
        }
    }

    public PO getPO(ResultSet rs, String trxName) {
        List<IServiceReferenceHolder<IModelFactory>> factoryList;
        String tableName = this.getTableName();
        PO po = null;
        IServiceReferenceHolder<IModelFactory> cache = s_modelFactoryCache.get(tableName);
        if (cache != null) {
            IModelFactory service = cache.getService();
            if (service != null && (po = service.getPO(tableName, rs, trxName)) != null) {
                return po;
            }
            s_modelFactoryCache.remove(tableName);
        }
        if ((factoryList = Service.locator().list(IModelFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder<IModelFactory> factory : factoryList) {
                IModelFactory service = factory.getService();
                if (service == null || (po = service.getPO(tableName, rs, trxName)) == null) continue;
                s_modelFactoryCache.put(tableName, factory);
                break;
            }
        }
        if (po == null) {
            po = new GenericPO(tableName, this.getCtx(), rs, trxName);
        }
        return po;
    }

    public PO getPOByUU(String uuID, String trxName) {
        PO po = this.getPO(0, trxName);
        po.loadByUU(uuID, trxName, new String[0]);
        return po;
    }

    public PO getPO(String whereClause, String trxName) {
        return this.getPO(whereClause, null, trxName);
    }

    public PO getPO(String whereClause, Object[] params, String trxName) {
        PO po;
        block10: {
            if (whereClause == null || whereClause.length() == 0) {
                return null;
            }
            po = null;
            POInfo info = POInfo.getPOInfo(this.getCtx(), this.getAD_Table_ID(), trxName);
            if (info == null) {
                return null;
            }
            StringBuilder sqlBuffer = info.buildSelect();
            sqlBuffer.append(" WHERE ").append(whereClause);
            String sql = sqlBuffer.toString();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    if (params != null && params.length > 0) {
                        int i2 = 0;
                        while (i2 < params.length) {
                            pstmt.setObject(i2 + 1, params[i2]);
                            ++i2;
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        po = this.getPO(rs, trxName);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.log.saveError("Error", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return po;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String error;
        if (this.isView() && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        if (!Util.isEmpty(error = Database.isValidIdentifier(this.getTableName()))) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), error) + " [TableName]");
            return false;
        }
        if (this.is_ValueChanged("IsPartition")) {
            ITablePartitionService service = DB.getDatabase().getTablePartitionService();
            if (service == null) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "DBAdapterNoTablePartitionSupport"));
                return false;
            }
            error = service.isValidConfiguration(this);
            if (!Util.isEmpty(error)) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), error));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!this.isView()) {
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            } else if (!seq.getName().equals(this.getTableName())) {
                seq.setName(this.getTableName());
                seq.saveEx();
            }
        }
        if (newRecord || this.is_ValueChanged("IsChangeLog")) {
            MChangeLog.resetLoggedList();
        }
        return success;
    }

    public String getSQLCreate() {
        AdempiereDatabase db = DB.getDatabase();
        if (db.isNativeMode()) {
            return db.getSQLCreate(this);
        }
        return Database.getDatabase(Database.DB_ORACLE).getSQLCreate(this);
    }

    public static int getTable_ID(String tableName) {
        return MTable.getTable_ID(tableName, null);
    }

    public static int getTable_ID(String tableName, String trxName) {
        MTable table2 = MTable.get(Env.getCtx(), tableName, trxName);
        return table2 != null ? table2.getAD_Table_ID() : 0;
    }

    public Query createQuery(String whereClause, String trxName) {
        return new Query(this.getCtx(), this, whereClause, trxName);
    }

    public MViewComponent[] getViewComponent(boolean reload) {
        if (!this.isView() || !this.isActive()) {
            return null;
        }
        if (this.m_viewComponents != null && !reload) {
            return this.m_viewComponents;
        }
        Query query = new Query(this.getCtx(), "AD_ViewComponent", "AD_Table_ID=?", this.get_TrxName());
        query.setParameters(this.getAD_Table_ID());
        query.setOrderBy("SeqNo");
        query.setOnlyActiveRecords(true);
        List<MViewComponent> list = query.list();
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MViewComponent mViewComponent = e.markImmutable();
            });
        }
        this.m_viewComponents = new MViewComponent[list.size()];
        list.toArray(this.m_viewComponents);
        return this.m_viewComponents;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }

    public static boolean isZeroIDTable(String tablename) {
        return tablename.equals("AD_Org") || tablename.equals("AD_OrgInfo") || tablename.equals("AD_Client") || tablename.equals("AD_ClientInfo") || tablename.equals("AD_AllClients_V") || tablename.equals("AD_ReportView") || tablename.equals("AD_Role") || tablename.equals("AD_AllRoles_V") || tablename.equals("AD_System") || tablename.equals("AD_AllUsers_V") || tablename.equals("C_DocType") || tablename.equals("GL_Category") || tablename.equals("M_AttributeSet") || tablename.equals("M_AttributeSetInstance");
    }

    @Override
    public MTable markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_columns != null && this.m_columns.length > 0) {
            Arrays.stream(this.m_columns).forEach(e -> {
                MColumn mColumn = e.markImmutable();
            });
        }
        if (this.m_viewComponents != null && this.m_viewComponents.length > 0) {
            Arrays.stream(this.m_viewComponents).forEach(e -> {
                MViewComponent mViewComponent = e.markImmutable();
            });
        }
        return this;
    }

    public int getWindowIDFromMenu() {
        return DB.getSQLValueEx(null, "SELECT a.AD_Window_ID FROM AD_Window a INNER JOIN AD_Tab b ON (a.AD_Window_ID=b.AD_Window_ID) INNER JOIN AD_Menu m ON (a.AD_Window_ID=m.AD_Window_ID AND m.IsActive='Y' AND m.Action='W') WHERE a.IsActive='Y' AND b.IsActive='Y' AND b.AD_Table_ID=? ORDER BY b.TabLevel, a.AD_Window_ID", this.getAD_Table_ID());
    }

    public String getUUIDFromZeroID() {
        if (!MTable.isZeroIDTable(this.getTableName())) {
            return null;
        }
        StringBuilder sqluu = new StringBuilder().append("SELECT ").append(PO.getUUIDColumnName(this.getTableName())).append(" FROM ").append(this.getTableName()).append(" WHERE ").append(this.getKeyColumns()[0]).append("=0");
        String uuidFromZeroID = DB.getSQLValueStringEx(this.get_TrxName(), sqluu.toString(), new Object[0]);
        return uuidFromZeroID;
    }

    public List<MColumn> getPartitionKeyColumns(boolean requery) {
        if (this.partitionKeyColumns != null && !requery) {
            return this.partitionKeyColumns;
        }
        this.partitionKeyColumnNames = null;
        String whereClause = "AD_Table_ID=? AND IsPartitionKey='Y'";
        this.partitionKeyColumns = new Query(this.getCtx(), "AD_Column", whereClause, null).setParameters(this.getAD_Table_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNoPartition").list();
        return this.partitionKeyColumns;
    }

    private void populatePartitionKeyColumnNames() {
        List<MColumn> keyColumns = this.getPartitionKeyColumns(false);
        this.partitionKeyColumnNames = new ArrayList<String>();
        StringBuilder keyColumnsString = new StringBuilder();
        int columnCount = 0;
        for (MColumn keyColumn : keyColumns) {
            if (columnCount > 0) {
                keyColumnsString.append(",");
            }
            keyColumnsString.append(keyColumn.getColumnName());
            this.partitionKeyColumnNames.add(keyColumn.getColumnName());
            ++columnCount;
        }
    }

    public List<String> getPartitionKeyColumnNames() {
        if (this.partitionKeyColumnNames != null) {
            return this.partitionKeyColumnNames;
        }
        this.populatePartitionKeyColumnNames();
        return this.partitionKeyColumnNames;
    }

    public X_AD_TablePartition createTablePartition(String name, String expression, String trxName, MColumn column) {
        return this.createTablePartition(name, expression, trxName, column, null);
    }

    public X_AD_TablePartition createTablePartition(String name, String expression, String trxName, MColumn column, X_AD_TablePartition parentPartition) {
        X_AD_TablePartition partition = new X_AD_TablePartition(Env.getCtx(), 0, trxName);
        partition.setAD_Table_ID(this.getAD_Table_ID());
        partition.setName(name);
        partition.setExpressionPartition(expression);
        partition.setAD_Column_ID(column.getAD_Column_ID());
        if (parentPartition != null) {
            partition.setParent_TablePartition_ID(parentPartition.getAD_TablePartition_ID());
        }
        partition.saveEx();
        return partition;
    }

    public List<X_AD_TablePartition> getTablePartitions(boolean requery, String trxName) {
        if (this.tablePartitions != null && !requery) {
            return this.tablePartitions;
        }
        this.tablePartitionNames = null;
        String whereClause = "AD_Table_ID=?";
        this.tablePartitions = new Query(this.getCtx(), "AD_TablePartition", whereClause, trxName).setParameters(this.getAD_Table_ID()).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return this.tablePartitions;
    }

    public List<String> getTablePartitionNames(String trxName) {
        if (this.tablePartitionNames != null) {
            return this.tablePartitionNames;
        }
        List<X_AD_TablePartition> partitions = this.getTablePartitions(false, trxName);
        this.tablePartitionNames = new ArrayList<String>();
        for (X_AD_TablePartition partition : partitions) {
            this.tablePartitionNames.add(partition.getName());
        }
        return this.tablePartitionNames;
    }

    public static String getUUIDIndexName(String tableName) {
        StringBuilder indexName = new StringBuilder().append(PO.getUUIDColumnName(tableName)).append("_idx");
        if (indexName.length() > 63) {
            indexName = new StringBuilder().append(PO.getUUIDColumnName(tableName).substring(0, 58)).append("uuidx");
        }
        return indexName.toString();
    }

    public boolean hasCustomTree() {
        if (this.hasCustomTree == null) {
            int exists = DB.getSQLValueEx(this.get_TrxName(), "SELECT 1 FROM AD_Tree WHERE TreeType=? AND AD_Table_ID=? AND IsActive='Y'", "TL", this.getAD_Table_ID());
            this.hasCustomTree = exists == 1;
        }
        return this.hasCustomTree;
    }

    public static String getPartitionName(Properties ctx, String tableName, boolean primaryLevelOnly, String trxName) {
        if (Util.isEmpty(tableName)) {
            return "";
        }
        String[] partitionColsAll = MTablePartition.getPartitionKeyColumns(ctx, tableName, trxName);
        if (partitionColsAll.length == 0) {
            return tableName;
        }
        int level = primaryLevelOnly ? 1 : partitionColsAll.length;
        StringBuilder partitionName = new StringBuilder();
        partitionName.append(tableName);
        int i2 = 0;
        while (i2 < level) {
            partitionName.append("_").append(partitionColsAll[i2]);
            ++i2;
        }
        return partitionName.toString();
    }
}

