/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.X_AD_Record_Access;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MRecordAccess
extends X_AD_Record_Access {
    private static final long serialVersionUID = -6463810251202651132L;
    private String m_keyColumnName = null;
    private String m_tableName;

    public MRecordAccess(Properties ctx, String AD_Record_Access_UU, String trxName) {
        super(ctx, AD_Record_Access_UU, trxName);
    }

    public MRecordAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MRecordAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRecordAccess(Properties ctx, int AD_Role_ID, int AD_Table_ID, int Record_ID, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Role_ID(AD_Role_ID);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
        this.setIsExclude(true);
        this.setIsReadOnly(false);
        this.setIsDependentEntities(false);
    }

    public String getKeyColumnName() {
        block9: {
            if (this.m_keyColumnName != null) {
                return this.m_keyColumnName;
            }
            String sql = "SELECT ColumnName FROM AD_Column WHERE AD_Table_ID=? AND IsKey='Y' AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_Table_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String s = rs.getString(1);
                        if (this.m_keyColumnName == null) {
                            this.m_keyColumnName = s;
                            continue;
                        }
                        this.log.log(Level.SEVERE, "More than one key = " + s);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.m_keyColumnName == null) {
            this.log.log(Level.SEVERE, "Record Access requires Table with one key column");
        }
        return this.m_keyColumnName;
    }

    public String getSynonym() {
        if ("AD_User_ID".equals(this.getKeyColumnName())) {
            return "SalesRep_ID";
        }
        if ("C_ElementValue_ID".equals(this.getKeyColumnName())) {
            return "Account_ID";
        }
        return null;
    }

    public boolean isSynonym() {
        return this.getSynonym() == null;
    }

    public boolean isReadWrite() {
        if (this.isExclude()) {
            return false;
        }
        return !super.isReadOnly();
    }

    public String getKeyColumnName(AccessSqlParser.TableInfo[] tableInfo) {
        String columnSyn = this.getSynonym();
        if (columnSyn == null) {
            return this.m_keyColumnName;
        }
        int i2 = 0;
        while (i2 < tableInfo.length) {
            if (this.m_keyColumnName.equals("AD_User_ID") ? tableInfo[i2].getTableName().equals("AD_User") : this.m_keyColumnName.equals("AD_ElementValue_ID") && tableInfo[i2].getTableName().equals("AD_ElementValue")) {
                return this.m_keyColumnName;
            }
            ++i2;
        }
        return columnSyn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecordAccess[AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(",Record_ID=").append(this.getRecord_ID()).append(",Active=").append(this.isActive()).append(",Exclude=").append(this.isExclude()).append(",ReadOnly=").append(super.isReadOnly()).append(",Dependent=").append(this.isDependentEntities()).append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        String in = Msg.getMsg(ctx, "Include");
        String ex = Msg.getMsg(ctx, "Exclude");
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Table_ID")).append("=").append(this.getTableName(ctx)).append(", ").append(Msg.translate(ctx, "Record_ID")).append("=").append(this.getRecord_ID()).append(" - ").append(Msg.translate(ctx, "IsDependentEntities")).append("=").append(this.isDependentEntities()).append(" (").append(Msg.translate(ctx, "IsReadOnly")).append("=").append(super.isReadOnly()).append(") - ").append(this.isExclude() ? ex : in);
        return sb.toString();
    }

    public String getTableName(Properties ctx) {
        if (this.m_tableName == null) {
            block8: {
                String sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, this.getAD_Table_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_tableName = rs.getString(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            String realName = Msg.translate(ctx, this.m_tableName + "_ID");
            if (!realName.equals(this.m_tableName + "_ID")) {
                this.m_tableName = realName;
            }
        }
        return this.m_tableName;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }
}

