/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_CostQueue;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MCostQueue
extends X_M_CostQueue {
    private static final long serialVersionUID = -1782836708418500130L;
    private static CLogger s_log = CLogger.getCLogger(MCostQueue.class);

    public static MCostQueue get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        MCostQueue costQ;
        block7: {
            costQ = null;
            String sql = "SELECT * FROM M_CostQueue WHERE AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, product.getAD_Client_ID());
                    pstmt.setInt(2, AD_Org_ID);
                    pstmt.setInt(3, product.getM_Product_ID());
                    pstmt.setInt(4, M_AttributeSetInstance_ID);
                    pstmt.setInt(5, as.getM_CostType_ID());
                    pstmt.setInt(6, as.getC_AcctSchema_ID());
                    pstmt.setInt(7, M_CostElement_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        costQ = new MCostQueue(product.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (costQ == null) {
            costQ = new MCostQueue(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID, trxName);
        }
        return costQ;
    }

    public static MCostQueue[] getQueue(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, MCostElement ce, String trxName) {
        ArrayList<MCostQueue> list;
        block9: {
            list = new ArrayList<MCostQueue>();
            StringBuilder sql = new StringBuilder("SELECT * FROM M_CostQueue ").append("WHERE AD_Client_ID=? AND AD_Org_ID=?").append(" AND M_Product_ID=?").append(" AND M_CostType_ID=? AND C_AcctSchema_ID=?").append(" AND M_CostElement_ID=?");
            if (M_ASI_ID != 0) {
                sql.append(" AND M_AttributeSetInstance_ID=?");
            }
            sql.append(" AND CurrentQty<>0 ").append("ORDER BY M_AttributeSetInstance_ID ");
            if (!ce.isFifo()) {
                sql.append("DESC");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, product.getAD_Client_ID());
                    pstmt.setInt(2, Org_ID);
                    pstmt.setInt(3, product.getM_Product_ID());
                    pstmt.setInt(4, as.getM_CostType_ID());
                    pstmt.setInt(5, as.getC_AcctSchema_ID());
                    pstmt.setInt(6, ce.getM_CostElement_ID());
                    if (M_ASI_ID != 0) {
                        pstmt.setInt(7, M_ASI_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MCostQueue(product.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MCostQueue[] costQ = new MCostQueue[list.size()];
        list.toArray(costQ);
        return costQ;
    }

    public static BigDecimal adjustQty(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, MCostElement ce, BigDecimal Qty, String trxName) {
        if (Qty.signum() == 0) {
            return Env.ZERO;
        }
        MCostQueue[] costQ = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, trxName);
        BigDecimal remainingQty = Qty;
        int i = 0;
        while (i < costQ.length) {
            MCostQueue queue = costQ[i];
            if (remainingQty.signum() < 0) {
                BigDecimal oldQty = queue.getCurrentQty();
                BigDecimal newQty = oldQty.subtract(remainingQty);
                queue.setCurrentQty(newQty);
                if (queue.save()) {
                    if (s_log.isLoggable(Level.FINE)) {
                        s_log.fine("Qty=" + String.valueOf(remainingQty) + "(!), ASI=" + queue.getM_AttributeSetInstance_ID() + " - " + String.valueOf(oldQty) + " -> " + String.valueOf(newQty));
                    }
                    return queue.getCurrentCostPrice();
                }
                return null;
            }
            if (queue.getCurrentQty().signum() > 0) {
                BigDecimal reduction = remainingQty;
                if (reduction.compareTo(queue.getCurrentQty()) > 0) {
                    reduction = queue.getCurrentQty();
                }
                BigDecimal oldQty = queue.getCurrentQty();
                BigDecimal newQty = oldQty.subtract(reduction);
                queue.setCurrentQty(newQty);
                if (queue.save()) {
                    if (s_log.isLoggable(Level.FINE)) {
                        s_log.fine("Qty=" + String.valueOf(reduction) + ", ASI=" + queue.getM_AttributeSetInstance_ID() + " - " + String.valueOf(oldQty) + " -> " + String.valueOf(newQty));
                    }
                } else {
                    return null;
                }
                remainingQty = remainingQty.subtract(reduction);
                if (remainingQty.signum() == 0) {
                    return queue.getCurrentCostPrice();
                }
            }
            ++i;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("RemainingQty=" + String.valueOf(remainingQty));
        }
        return null;
    }

    public static BigDecimal getCosts(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, MCostElement ce, BigDecimal Qty, String trxName) {
        if (Qty.signum() == 0) {
            return Env.ZERO;
        }
        MCostQueue[] costQ = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, trxName);
        BigDecimal cost = Env.ZERO;
        BigDecimal remainingQty = Qty;
        BigDecimal firstPrice = null;
        BigDecimal lastPrice = null;
        int i = 0;
        while (i < costQ.length) {
            MCostQueue queue = costQ[i];
            if (remainingQty.signum() <= 0) {
                queue.getCurrentQty();
                lastPrice = queue.getCurrentCostPrice();
                BigDecimal costBatch = lastPrice.multiply(remainingQty);
                cost = cost.add(costBatch);
                if (s_log.isLoggable(Level.CONFIG)) {
                    s_log.config("ASI=" + queue.getM_AttributeSetInstance_ID() + " - Cost=" + String.valueOf(lastPrice) + " * Qty=" + String.valueOf(remainingQty) + "(!) = " + String.valueOf(costBatch));
                }
                return cost;
            }
            if (queue.getCurrentQty().signum() > 0) {
                BigDecimal reduction = remainingQty;
                if (reduction.compareTo(queue.getCurrentQty()) > 0) {
                    reduction = queue.getCurrentQty();
                }
                queue.getCurrentQty();
                lastPrice = queue.getCurrentCostPrice();
                BigDecimal costBatch = lastPrice.multiply(reduction);
                cost = cost.add(costBatch);
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine("ASI=" + queue.getM_AttributeSetInstance_ID() + " - Cost=" + String.valueOf(lastPrice) + " * Qty=" + String.valueOf(reduction) + " = " + String.valueOf(costBatch));
                }
                if ((remainingQty = remainingQty.subtract(reduction)).signum() == 0) {
                    if (s_log.isLoggable(Level.CONFIG)) {
                        s_log.config("Cost=" + String.valueOf(cost));
                    }
                    return cost;
                }
                if (firstPrice == null) {
                    firstPrice = lastPrice;
                }
            }
            ++i;
        }
        if (lastPrice == null) {
            lastPrice = MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, ce.getCostingMethod(), 0);
            if (lastPrice == null) {
                s_log.info("No Price found");
                return null;
            }
            s_log.info("No Cost Queue");
        }
        BigDecimal costBatch = lastPrice.multiply(remainingQty);
        s_log.fine("RemainingQty=" + String.valueOf(remainingQty) + " * LastPrice=" + String.valueOf(lastPrice) + " = " + String.valueOf(costBatch));
        cost = cost.add(costBatch);
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("Cost=" + String.valueOf(cost));
        }
        return cost;
    }

    public MCostQueue(Properties ctx, String M_CostQueue_UU, String trxName) {
        super(ctx, M_CostQueue_UU, trxName);
        if (Util.isEmpty(M_CostQueue_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCostQueue(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setInitialDefaults();
    }

    private void setInitialDefaults() {
        this.setCurrentCostPrice(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
    }

    public MCostQueue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostQueue(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        this(product.getCtx(), 0, trxName);
        this.setClientOrg(product.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_CostType_ID(as.getM_CostType_ID());
        this.setM_Product_ID(product.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
    }

    public void setCosts(BigDecimal amt, BigDecimal qty, int precision) {
        BigDecimal oldSum = this.getCurrentCostPrice().multiply(this.getCurrentQty());
        BigDecimal newSum = amt;
        BigDecimal sumAmt = oldSum.add(newSum);
        BigDecimal sumQty = this.getCurrentQty().add(qty);
        if (sumQty.signum() != 0) {
            BigDecimal cost = sumAmt.divide(sumQty, precision, RoundingMode.HALF_UP);
            this.setCurrentCostPrice(cost);
        }
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }
}

