/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import org.adempiere.exceptions.AverageCostingNegativeQtyException;
import org.adempiere.exceptions.AverageCostingZeroQtyException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostQueue;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.model.X_M_Cost;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MCost
extends X_M_Cost {
    private static final long serialVersionUID = -9054858267574839079L;
    private static CLogger s_log = CLogger.getCLogger(MCost.class);
    protected boolean m_manual = true;

    public static BigDecimal getCurrentCost(MProduct product, int M_AttributeSetInstance_ID, String trxName) {
        int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        MAcctSchema as = MClient.get(Env.getAD_Client_ID(Env.getCtx())).getAcctSchema();
        String costingMethod = product.getCostingMethod(as);
        return MCost.getCurrentCost(product, M_AttributeSetInstance_ID, as, AD_Org_ID, costingMethod, new BigDecimal("1"), 0, true, trxName);
    }

    public static BigDecimal getCurrentCost(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, String costingMethod, BigDecimal qty, int C_OrderLine_ID, boolean zeroCostsOK, String trxName) {
        String CostingLevel = product.getCostingLevel(as);
        if ("C".equals(CostingLevel)) {
            AD_Org_ID = 0;
            M_AttributeSetInstance_ID = 0;
        } else if ("O".equals(CostingLevel)) {
            M_AttributeSetInstance_ID = 0;
        } else if ("B".equals(CostingLevel)) {
            AD_Org_ID = 0;
        }
        if (costingMethod == null && (costingMethod = product.getCostingMethod(as)) == null) {
            throw new IllegalArgumentException("No Costing Method");
        }
        MCostDetail.processProduct(product, trxName);
        return MCost.getCurrentCost(product, M_AttributeSetInstance_ID, as, AD_Org_ID, as.getM_CostType_ID(), costingMethod, qty, C_OrderLine_ID, zeroCostsOK, trxName);
    }

    protected static BigDecimal getCurrentCost(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, int M_CostType_ID, String costingMethod, BigDecimal qty, int C_OrderLine_ID, boolean zeroCostsOK, String trxName) {
        BigDecimal otherCost;
        BigDecimal costs;
        String costElementType = null;
        BigDecimal percent = null;
        BigDecimal materialCostEach = Env.ZERO;
        BigDecimal otherCostEach = Env.ZERO;
        BigDecimal percentage = Env.ZERO;
        int count = 0;
        String sql = "SELECT COALESCE(SUM(c.CurrentCostPrice),0), ce.CostElementType, ce.CostingMethod, c.Percent, c.M_CostElement_ID , COALESCE(SUM(c.CurrentCostPriceLL),0)  FROM M_Cost c LEFT OUTER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID) WHERE c.AD_Client_ID=? AND c.AD_Org_ID=? AND c.M_Product_ID=? AND (c.M_AttributeSetInstance_ID=? OR c.M_AttributeSetInstance_ID=0) AND c.M_CostType_ID=? AND c.C_AcctSchema_ID=? AND (ce.CostingMethod IS NULL OR ce.CostingMethod=?) GROUP BY ce.CostElementType, ce.CostingMethod, c.Percent, c.M_CostElement_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, product.getAD_Client_ID());
                pstmt.setInt(2, Org_ID);
                pstmt.setInt(3, product.getM_Product_ID());
                pstmt.setInt(4, M_ASI_ID);
                pstmt.setInt(5, M_CostType_ID);
                pstmt.setInt(6, as.getC_AcctSchema_ID());
                pstmt.setString(7, costingMethod);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal currentCostPrice = rs.getBigDecimal(1);
                    BigDecimal currentCostPriceLL = rs.getBigDecimal(6);
                    costElementType = rs.getString(2);
                    String cm = rs.getString(3);
                    percent = rs.getBigDecimal(4);
                    if (s_log.isLoggable(Level.FINEST)) {
                        s_log.finest("CurrentCostPrice=" + String.valueOf(currentCostPrice) + ", CurrentCostPriceLL=" + String.valueOf(currentCostPriceLL) + ", CostElementType=" + costElementType + ", CostingMethod=" + cm + ", Percent=" + String.valueOf(percent));
                    }
                    if (currentCostPrice != null && currentCostPrice.signum() != 0) {
                        if (cm != null) {
                            materialCostEach = materialCostEach.add(currentCostPrice);
                        } else {
                            otherCostEach = otherCostEach.add(currentCostPrice);
                        }
                    }
                    if (percent != null && percent.signum() != 0) {
                        percentage = percentage.add(percent);
                    }
                    ++count;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (count > 1 && s_log.isLoggable(Level.FINEST)) {
            s_log.finest("MaterialCost=" + String.valueOf(materialCostEach) + ", OtherCosts=" + String.valueOf(otherCostEach) + ", Percentage=" + String.valueOf(percentage));
        }
        if (materialCostEach.signum() == 0 && zeroCostsOK) {
            return Env.ZERO;
        }
        BigDecimal materialCost = materialCostEach.multiply(qty);
        if ("S".equals(costingMethod)) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer("MaterialCosts = " + String.valueOf(materialCost));
            }
            return materialCost;
        }
        if ("F".equals(costingMethod) || "L".equals(costingMethod)) {
            MCostElement ce = MCostElement.getMaterialCostElement(as, costingMethod);
            materialCost = MCostQueue.getCosts(product, M_ASI_ID, as, Org_ID, ce, qty, trxName);
        }
        if ((costs = (otherCost = otherCostEach.multiply(qty)).add(materialCost)).signum() == 0) {
            return null;
        }
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer("Sum Costs = " + String.valueOf(costs));
        }
        int precision = as.getCostingPrecision();
        if (percentage.signum() == 0) {
            if (costs.scale() > precision) {
                costs = costs.setScale(precision, RoundingMode.HALF_UP);
            }
            return costs;
        }
        BigDecimal percentCost = costs.multiply(percentage);
        if ((costs = costs.add(percentCost = percentCost.divide(Env.ONEHUNDRED, precision, RoundingMode.HALF_UP))).scale() > precision) {
            costs = costs.setScale(precision, RoundingMode.HALF_UP);
        }
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer("Sum Costs = " + String.valueOf(costs) + " (Add=" + String.valueOf(percentCost) + ")");
        }
        return costs;
    }

    public static BigDecimal getSeedCosts(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, String costingMethod, int C_OrderLine_ID) {
        MCostElement ce;
        MCost cost;
        BigDecimal retValue = null;
        if ("I".equals(costingMethod)) {
            return null;
        }
        if ("A".equals(costingMethod)) {
            return null;
        }
        if ("F".equals(costingMethod)) {
            return null;
        }
        if ("L".equals(costingMethod)) {
            return null;
        }
        if ("i".equals(costingMethod)) {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
        } else if ("p".equals(costingMethod)) {
            if (C_OrderLine_ID != 0) {
                retValue = MCost.getPOPrice(product, C_OrderLine_ID, as.getC_Currency_ID());
            }
            if (retValue == null || retValue.signum() == 0) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            }
        } else if (!"S".equals(costingMethod) && !"U".equals(costingMethod)) {
            throw new IllegalArgumentException("Unknown Costing Method = " + costingMethod);
        }
        if (retValue != null && retValue.signum() > 0) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine(product.getName() + ", CostingMethod=" + costingMethod + " - " + String.valueOf(retValue));
            }
            return retValue;
        }
        if (C_OrderLine_ID != 0 && (retValue = MCost.getPOPrice(product, C_OrderLine_ID, as.getC_Currency_ID())) != null && retValue.signum() > 0) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine(product.getName() + ", PO - " + String.valueOf(retValue));
            }
            return retValue;
        }
        if (!"S".equals(costingMethod) && (cost = MCost.get(product, M_ASI_ID, as, Org_ID, (ce = MCostElement.getMaterialCostElement(as, "S")).getM_CostElement_ID(), product.get_TrxName())) != null && cost.getCurrentCostPrice().signum() > 0) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine(product.getName() + ", Standard - " + String.valueOf(cost));
            }
            return cost.getCurrentCostPrice();
        }
        if ("p".equals(costingMethod) || "S".equals(costingMethod)) {
            retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() > 0) {
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine(product.getName() + ", LastPO = " + String.valueOf(retValue));
                }
                return retValue;
            }
        } else {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() != 0) {
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine(product.getName() + ", LastInv = " + String.valueOf(retValue));
                }
                return retValue;
            }
        }
        if ("p".equals(costingMethod) || "S".equals(costingMethod)) {
            retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastInvoicePrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() > 0) {
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine(product.getName() + ", LastInv = " + String.valueOf(retValue));
                }
                return retValue;
            }
        } else {
            retValue = MCost.getLastPOPrice(product, M_ASI_ID, Org_ID, as.getC_Currency_ID());
            if (Org_ID != 0 && (retValue == null || retValue.signum() == 0)) {
                retValue = MCost.getLastPOPrice(product, M_ASI_ID, 0, as.getC_Currency_ID());
            }
            if (retValue != null && retValue.signum() > 0) {
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine(product.getName() + ", LastPO = " + String.valueOf(retValue));
                }
                return retValue;
            }
        }
        MProductPO[] pos = MProductPO.getOfProduct(product.getCtx(), product.getM_Product_ID(), product.get_TrxName());
        int i = 0;
        while (i < pos.length) {
            BigDecimal price = pos[i].getPricePO();
            if (price == null || price.signum() == 0) {
                price = pos[i].getPriceList();
            }
            if (price != null && price.signum() != 0) {
                price = MConversionRate.convert(product.getCtx(), price, pos[i].getC_Currency_ID(), as.getC_Currency_ID(), as.getAD_Client_ID(), Org_ID);
                if (price != null && price.signum() != 0 && pos[i].getC_UOM_ID() != product.getC_UOM_ID()) {
                    price = MUOMConversion.convertProductTo(Env.getCtx(), product.getM_Product_ID(), pos[i].getC_UOM_ID(), price);
                }
                if (price != null && price.signum() != 0) {
                    retValue = price;
                    if (s_log.isLoggable(Level.FINE)) {
                        s_log.fine(product.getName() + ", Product_PO = " + String.valueOf(retValue));
                    }
                    return retValue;
                }
            }
            ++i;
        }
        BigDecimal price = MCost.getSeedCostFromPriceList(product, as, Org_ID);
        if (price != null && price.signum() > 0) {
            retValue = price;
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine(product.getName() + " = " + String.valueOf(retValue));
        }
        return retValue;
    }

    protected static BigDecimal getSeedCostFromPriceList(MProduct product, MAcctSchema as, int orgID) {
        ResultSet rs;
        CPreparedStatement st;
        block5: {
            BigDecimal bigDecimal;
            BigDecimal priceList;
            String sql;
            block6: {
                sql = "SELECT pp.PriceList, pp.PriceStd FROM M_ProductPrice pp INNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID AND plv.ValidFrom <= trunc(getDate())) INNER JOIN M_PriceList pl ON (plv.M_PriceList_ID = pl.M_PriceList_ID AND pl.IsSOPriceList = 'N') WHERE pp.AD_Client_ID = ? AND pp.AD_Org_ID IN (0, ?) AND pp.M_Product_ID = ? AND pp.PriceList > 0 AND pp.IsActive = 'Y'  ORDER BY pp.AD_Org_ID Desc, plv.ValidFrom Desc";
                st = null;
                rs = null;
                st = DB.prepareStatement(sql, product.get_TrxName());
                st.setInt(1, as.getAD_Client_ID());
                st.setInt(2, orgID);
                st.setInt(3, product.getM_Product_ID());
                rs = st.executeQuery();
                if (!rs.next()) break block5;
                priceList = rs.getBigDecimal(1);
                BigDecimal priceStd = rs.getBigDecimal(2);
                if (priceStd == null || priceStd.signum() <= 0) break block6;
                BigDecimal bigDecimal2 = priceStd;
                DB.close(rs, st);
                return bigDecimal2;
            }
            try {
                bigDecimal = priceList;
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, st);
                    throw throwable;
                }
            }
            DB.close(rs, st);
            return bigDecimal;
        }
        DB.close(rs, st);
        return BigDecimal.ZERO;
    }

    public static BigDecimal getLastInvoicePrice(MProduct product, int M_ASI_ID, int AD_Org_ID, int C_Currency_ID) {
        BigDecimal retValue;
        block14: {
            retValue = null;
            StringBuilder sql = new StringBuilder("SELECT currencyConvertInvoice(i.C_Invoice_ID, ?, il.PriceActual, i.DateAcct) ").append("FROM C_InvoiceLine il ").append(" INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) ").append("WHERE il.M_Product_ID=?").append(" AND i.IsSOTrx='N'");
            if (AD_Org_ID != 0) {
                sql.append(" AND il.AD_Org_ID=?");
            } else if (M_ASI_ID != 0) {
                sql.append(" AND il.M_AttributeSetInstance_ID=?");
            }
            sql.append(" ORDER BY i.DateInvoiced DESC, il.Line DESC");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), product.get_TrxName());
                    pstmt.setInt(1, C_Currency_ID);
                    pstmt.setInt(2, product.getM_Product_ID());
                    if (AD_Org_ID != 0) {
                        pstmt.setInt(3, AD_Org_ID);
                    } else if (M_ASI_ID != 0) {
                        pstmt.setInt(3, M_ASI_ID);
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer(product.getName() + " = " + String.valueOf(retValue));
            }
            return retValue;
        }
        return null;
    }

    public static BigDecimal getLastPOPrice(MProduct product, int M_ASI_ID, int AD_Org_ID, int C_Currency_ID) {
        BigDecimal retValue = null;
        StringBuilder sql = new StringBuilder("SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID),").append(" currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) ").append("FROM C_OrderLine ol").append(" INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) ").append("WHERE ol.M_Product_ID=?").append(" AND o.IsSOTrx='N'");
        if (AD_Org_ID != 0) {
            sql.append(" AND ol.AD_Org_ID=?");
        } else if (M_ASI_ID != 0) {
            sql.append(" AND ol.M_AttributeSetInstance_ID=?");
        }
        sql.append(" ORDER BY o.DateOrdered DESC, ol.Line DESC");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), product.get_TrxName());
                pstmt.setInt(1, C_Currency_ID);
                pstmt.setInt(2, C_Currency_ID);
                pstmt.setInt(3, product.getM_Product_ID());
                if (AD_Org_ID != 0) {
                    pstmt.setInt(4, AD_Org_ID);
                } else if (M_ASI_ID != 0) {
                    pstmt.setInt(4, M_ASI_ID);
                }
                rs = pstmt.executeQuery();
                if (rs.next() && ((retValue = rs.getBigDecimal(1)) == null || retValue.signum() == 0)) {
                    retValue = rs.getBigDecimal(2);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue != null) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer(product.getName() + " = " + String.valueOf(retValue));
            }
            return retValue;
        }
        return null;
    }

    public static BigDecimal getPOPrice(MProduct product, int C_OrderLine_ID, int C_Currency_ID) {
        BigDecimal retValue;
        block8: {
            retValue = null;
            String sql = "SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID), currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID=? AND o.IsSOTrx='N'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, product.get_TrxName());
                    pstmt.setInt(1, C_Currency_ID);
                    pstmt.setInt(2, C_Currency_ID);
                    pstmt.setInt(3, C_OrderLine_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((retValue = rs.getBigDecimal(1)) == null || retValue.signum() == 0)) {
                        retValue = rs.getBigDecimal(2);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer(product.getName() + " = " + String.valueOf(retValue));
            }
            return retValue;
        }
        return null;
    }

    public static void create(MClient client) {
        boolean success;
        Trx trx;
        block12: {
            String trxName;
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(client.getCtx(), client.getAD_Client_ID());
            String trxNameUsed = trxName = client.get_TrxName();
            trx = null;
            if (trxName == null) {
                trxNameUsed = Trx.createTrxName("Cost");
                trx = Trx.get(trxNameUsed, true);
                trx.setDisplayName(MCost.class.getName() + "_create");
            }
            success = true;
            String sql = "SELECT * FROM M_Product p WHERE AD_Client_ID=? AND EXISTS (SELECT * FROM M_CostDetail cd WHERE p.M_Product_ID=cd.M_Product_ID AND Processed='N')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxNameUsed);
                    pstmt.setInt(1, client.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MProduct product = new MProduct(client.getCtx(), rs, trxNameUsed);
                        int i = 0;
                        while (i < ass.length) {
                            BigDecimal cost = MCost.getCurrentCost(product, 0, ass[i], 0, null, Env.ONE, 0, false, trxNameUsed);
                            if (s_log.isLoggable(Level.INFO)) {
                                s_log.info(product.getName() + " = " + String.valueOf(cost));
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    success = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (trx != null) {
            if (success) {
                trx.commit();
            } else {
                trx.rollback();
            }
            trx.close();
        }
    }

    protected static void create(MProduct product) {
        s_log.config(product.getName());
        MCostElement[] ces = MCostElement.getCostingMethods(product);
        MCostElement ce = null;
        MCostElement[] mCostElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            MCostElement element = mCostElementArray[n2];
            if ("S".equals(element.getCostingMethod())) {
                ce = element;
                break;
            }
            ++n2;
        }
        if (ce == null) {
            s_log.fine("No Standard Costing in System");
            return;
        }
        MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(product.getCtx(), product.getAD_Client_ID(), product.get_TrxName());
        MOrg[] orgs = null;
        int M_ASI_ID = 0;
        MAcctSchema[] mAcctSchemaArray = mass;
        int n3 = mass.length;
        int n4 = 0;
        while (n4 < n3) {
            MAcctSchema as = mAcctSchemaArray[n4];
            String cl = product.getCostingLevel(as);
            if ("C".equals(cl)) {
                MCost.createCostingRecord(product, M_ASI_ID, as, 0, ce.getM_CostElement_ID());
            } else if ("O".equals(cl)) {
                if (as.getAD_OrgOnly_ID() > 0 && MOrg.get(product.getCtx(), as.getAD_OrgOnly_ID()).isSummary()) {
                    MClient client = MClient.get(product.getCtx(), product.getAD_Client_ID());
                    MClientInfo ci = client.getInfo();
                    MTree vTree = new MTree(product.getCtx(), ci.getAD_Tree_Org_ID(), false, true, true, product.get_TrxName());
                    MTreeNode root = vTree.getRoot();
                    MCost.createForChildOrg(root, product, as, M_ASI_ID, ce, false);
                } else {
                    if (orgs == null) {
                        orgs = MOrg.getOfClient(product);
                    }
                    MOrg[] mOrgArray = orgs;
                    int n5 = orgs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        MOrg o = mOrgArray[n6];
                        if (!(o.isSummary() || as.getAD_OrgOnly_ID() != o.getAD_Org_ID() && as.getAD_OrgOnly_ID() != 0)) {
                            MCost.createCostingRecord(product, M_ASI_ID, as, o.getAD_Org_ID(), ce.getM_CostElement_ID());
                        }
                        ++n6;
                    }
                }
            } else {
                s_log.warning("Not created: Std.Cost for " + product.getName() + " - Costing Level on Batch/Lot");
            }
            ++n4;
        }
    }

    private static void createForChildOrg(MTreeNode root, MProduct product, MAcctSchema as, int M_ASI_ID, MCostElement ce, boolean found) {
        int parentId = root.getNode_ID();
        if (!found) {
            found = parentId == as.getAD_OrgOnly_ID();
        }
        Enumeration<TreeNode> nodeEnum = root.children();
        MTreeNode child = null;
        while (nodeEnum.hasMoreElements()) {
            child = (MTreeNode)nodeEnum.nextElement();
            if (child != null && child.getChildCount() > 0) {
                MCost.createForChildOrg(child, product, as, M_ASI_ID, ce, found);
                continue;
            }
            if (!found) continue;
            int orgId = child.getNode_ID();
            MOrg org = MOrg.get(product.getCtx(), orgId);
            if (org.isSummary()) continue;
            MCost.createCostingRecord(product, M_ASI_ID, as, orgId, ce.getM_CostElement_ID());
        }
    }

    private static void createCostingRecord(MProduct product, int M_ASI_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID) {
        MCost cost = MCost.get(product, M_ASI_ID, as, AD_Org_ID, M_CostElement_ID, product.get_TrxName());
        if (cost.is_new()) {
            if (cost.save()) {
                if (s_log.isLoggable(Level.CONFIG)) {
                    s_log.config("Std.Cost for " + product.getName() + " - " + as.getName());
                }
            } else {
                s_log.warning("Not created: Std.Cost for " + product.getName() + " - " + as.getName());
            }
        }
    }

    protected static void delete(MProduct product) {
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config(product.getName());
        }
        List<MCostElement> ces = MCostElement.getCostElementsWithCostingMethods(product);
        MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(product.getCtx(), product.getAD_Client_ID(), product.get_TrxName());
        MOrg[] orgs = null;
        int M_ASI_ID = 0;
        MAcctSchema[] mAcctSchemaArray = mass;
        int n = mass.length;
        int n2 = 0;
        while (n2 < n) {
            MAcctSchema as = mAcctSchemaArray[n2];
            String cl = product.getCostingLevel(as);
            if ("C".equals(cl)) {
                for (MCostElement ce : ces) {
                    MCost cost = MCost.get(product, M_ASI_ID, as, 0, ce.getM_CostElement_ID(), product.get_TrxName());
                    if (cost == null) continue;
                    cost.deleteEx(true);
                }
            } else if ("O".equals(cl)) {
                if (orgs == null) {
                    orgs = MOrg.getOfClient(product);
                }
                MOrg[] mOrgArray = orgs;
                int n3 = orgs.length;
                int n4 = 0;
                while (n4 < n3) {
                    MOrg o = mOrgArray[n4];
                    for (MCostElement ce : ces) {
                        MCost cost = MCost.get(product, M_ASI_ID, as, o.getAD_Org_ID(), ce.getM_CostElement_ID(), product.get_TrxName());
                        if (cost == null) continue;
                        cost.deleteEx(true);
                    }
                    ++n4;
                }
            } else {
                s_log.warning("Not created: Cost for " + product.getName() + " - Costing Level on Batch/Lot");
            }
            ++n2;
        }
    }

    public static BigDecimal calculateAverageInv(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        StringBuilder sql = new StringBuilder("SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual,").append(" i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID ").append("FROM M_Transaction t").append(" INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID)").append(" INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID)").append(" INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) ").append("WHERE t.M_Product_ID=?");
        if (AD_Org_ID != 0) {
            sql.append(" AND t.AD_Org_ID=?");
        } else if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND t.M_AttributeSetInstance_ID=?");
        }
        sql.append(" ORDER BY t.M_Transaction_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal newStockQty = Env.ZERO;
        BigDecimal newAverageAmt = Env.ZERO;
        int oldTransaction_ID = 0;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, product.getM_Product_ID());
                if (AD_Org_ID != 0) {
                    pstmt.setInt(2, AD_Org_ID);
                } else if (M_AttributeSetInstance_ID != 0) {
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal oldStockQty = newStockQty;
                    BigDecimal movementQty = rs.getBigDecimal(1);
                    int M_Transaction_ID = rs.getInt(10);
                    if (M_Transaction_ID != oldTransaction_ID) {
                        newStockQty = oldStockQty.add(movementQty);
                    }
                    M_Transaction_ID = oldTransaction_ID;
                    BigDecimal matchQty = rs.getBigDecimal(2);
                    if (matchQty == null) {
                        if (!s_log.isLoggable(Level.FINER)) continue;
                        s_log.finer("Movement=" + String.valueOf(movementQty) + ", StockQty=" + String.valueOf(newStockQty));
                        continue;
                    }
                    BigDecimal price = rs.getBigDecimal(4);
                    int C_Currency_ID = rs.getInt(5);
                    Timestamp DateAcct = rs.getTimestamp(6);
                    int C_ConversionType_ID = rs.getInt(7);
                    int Client_ID = rs.getInt(8);
                    int Org_ID = rs.getInt(9);
                    BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                    BigDecimal oldAverageAmt = newAverageAmt;
                    BigDecimal averageCurrent = oldStockQty.multiply(oldAverageAmt);
                    BigDecimal averageIncrease = matchQty.multiply(cost);
                    BigDecimal newAmt = averageCurrent.add(averageIncrease);
                    newAmt = newAmt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
                    newAverageAmt = newAmt.divide(newStockQty, as.getCostingPrecision(), RoundingMode.HALF_UP);
                    if (!s_log.isLoggable(Level.FINER)) continue;
                    s_log.finer("Movement=" + String.valueOf(movementQty) + ", StockQty=" + String.valueOf(newStockQty) + ", Match=" + String.valueOf(matchQty) + ", Cost=" + String.valueOf(cost) + ", NewAvg=" + String.valueOf(newAverageAmt));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (newAverageAmt != null && newAverageAmt.signum() != 0) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer(product.getName() + " = " + String.valueOf(newAverageAmt));
            }
            return newAverageAmt;
        }
        return null;
    }

    public static BigDecimal calculateAveragePO(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        StringBuilder sql = new StringBuilder("SELECT t.MovementQty, mp.Qty, ol.QtyOrdered, ol.PriceCost, ol.PriceActual,").append(" o.C_Currency_ID, o.DateAcct, o.C_ConversionType_ID,").append(" o.AD_Client_ID, o.AD_Org_ID, t.M_Transaction_ID ").append("FROM M_Transaction t").append(" INNER JOIN M_MatchPO mp ON (t.M_InOutLine_ID=mp.M_InOutLine_ID)").append(" INNER JOIN C_OrderLine ol ON (mp.C_OrderLine_ID=ol.C_OrderLine_ID)").append(" INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) ").append("WHERE t.M_Product_ID=?");
        if (AD_Org_ID != 0) {
            sql.append(" AND t.AD_Org_ID=?");
        } else if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND t.M_AttributeSetInstance_ID=?");
        }
        sql.append(" ORDER BY t.M_Transaction_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal newStockQty = Env.ZERO;
        BigDecimal newAverageAmt = Env.ZERO;
        int oldTransaction_ID = 0;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, product.getM_Product_ID());
                if (AD_Org_ID != 0) {
                    pstmt.setInt(2, AD_Org_ID);
                } else if (M_AttributeSetInstance_ID != 0) {
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal oldStockQty = newStockQty;
                    BigDecimal movementQty = rs.getBigDecimal(1);
                    int M_Transaction_ID = rs.getInt(11);
                    if (M_Transaction_ID != oldTransaction_ID) {
                        newStockQty = oldStockQty.add(movementQty);
                    }
                    M_Transaction_ID = oldTransaction_ID;
                    BigDecimal matchQty = rs.getBigDecimal(2);
                    if (matchQty == null) {
                        if (!s_log.isLoggable(Level.FINER)) continue;
                        s_log.finer("Movement=" + String.valueOf(movementQty) + ", StockQty=" + String.valueOf(newStockQty));
                        continue;
                    }
                    BigDecimal price = rs.getBigDecimal(4);
                    if (price == null || price.signum() == 0) {
                        price = rs.getBigDecimal(5);
                    }
                    int C_Currency_ID = rs.getInt(6);
                    Timestamp DateAcct = rs.getTimestamp(7);
                    int C_ConversionType_ID = rs.getInt(8);
                    int Client_ID = rs.getInt(9);
                    int Org_ID = rs.getInt(10);
                    BigDecimal cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                    BigDecimal oldAverageAmt = newAverageAmt;
                    BigDecimal averageCurrent = oldStockQty.multiply(oldAverageAmt);
                    BigDecimal averageIncrease = matchQty.multiply(cost);
                    BigDecimal newAmt = averageCurrent.add(averageIncrease);
                    newAmt = newAmt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
                    newAverageAmt = newAmt.divide(newStockQty, as.getCostingPrecision(), RoundingMode.HALF_UP);
                    if (!s_log.isLoggable(Level.FINER)) continue;
                    s_log.finer("Movement=" + String.valueOf(movementQty) + ", StockQty=" + String.valueOf(newStockQty) + ", Match=" + String.valueOf(matchQty) + ", Cost=" + String.valueOf(cost) + ", NewAvg=" + String.valueOf(newAverageAmt));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (newAverageAmt != null && newAverageAmt.signum() != 0) {
            if (s_log.isLoggable(Level.FINER)) {
                s_log.finer(product.getName() + " = " + String.valueOf(newAverageAmt));
            }
            return newAverageAmt;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static BigDecimal calculateFiFo(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        sql = new StringBuilder("SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual,").append(" i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID ").append("FROM M_Transaction t").append(" INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID)").append(" INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID)").append(" INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) ").append("WHERE t.M_Product_ID=?");
        if (AD_Org_ID != 0) {
            sql.append(" AND t.AD_Org_ID=?");
        } else if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND t.M_AttributeSetInstance_ID=?");
        }
        sql.append(" ORDER BY t.M_Transaction_ID");
        pstmt = null;
        rs = null;
        oldTransaction_ID = 0;
        fifo = new ArrayList<QtyCost>();
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, product.getM_Product_ID());
                if (AD_Org_ID != 0) {
                    pstmt.setInt(2, AD_Org_ID);
                } else if (M_AttributeSetInstance_ID != 0) {
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    block21: {
                        block23: {
                            block22: {
                                movementQty = rs.getBigDecimal(1);
                                M_Transaction_ID = rs.getInt(10);
                                if (M_Transaction_ID == oldTransaction_ID) continue;
                                M_Transaction_ID = oldTransaction_ID;
                                matchQty = rs.getBigDecimal(2);
                                if (matchQty != null) break block21;
                                if (fifo.size() <= 0) break block22;
                                pp = (QtyCost)fifo.get(0);
                                pp.Qty = pp.Qty.add(movementQty);
                                remainder = pp.Qty;
                                if (remainder.signum() != 0) ** GOTO lbl48
                                fifo.remove(0);
                                break block23;
lbl-1000:
                                // 1 sources

                                {
                                    if (fifo.size() == 1) {
                                        pp.Cost = Env.ZERO;
                                        remainder = Env.ZERO;
                                        continue;
                                    }
                                    fifo.remove(0);
                                    pp = (QtyCost)fifo.get(0);
                                    remainder = pp.Qty = pp.Qty.add(movementQty);
lbl48:
                                    // 3 sources

                                    ** while (remainder.signum() != 0)
                                }
lbl49:
                                // 1 sources

                                break block23;
                            }
                            pp = new QtyCost(movementQty, Env.ZERO);
                            fifo.add(pp);
                        }
                        if (!MCost.s_log.isLoggable(Level.FINER)) continue;
                        MCost.s_log.finer("Movement=" + String.valueOf(movementQty) + ", Size=" + fifo.size());
                        continue;
                    }
                    price = rs.getBigDecimal(4);
                    C_Currency_ID = rs.getInt(5);
                    DateAcct = rs.getTimestamp(6);
                    C_ConversionType_ID = rs.getInt(7);
                    Client_ID = rs.getInt(8);
                    Org_ID = rs.getInt(9);
                    cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                    used = false;
                    if (fifo.size() == 1) {
                        pp = (QtyCost)fifo.get(0);
                        if (pp.Qty.signum() < 0) {
                            pp.Qty = pp.Qty.add(movementQty);
                            if (pp.Qty.signum() == 0) {
                                fifo.remove(0);
                            } else {
                                pp.Cost = cost;
                            }
                            used = true;
                        }
                    }
                    if (!used) {
                        pp = new QtyCost(movementQty, cost);
                        fifo.add(pp);
                    }
                    if (!MCost.s_log.isLoggable(Level.FINER)) continue;
                    MCost.s_log.finer("Movement=" + String.valueOf(movementQty) + ", Size=" + fifo.size());
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable var21_23) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw var21_23;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (fifo.size() == 0) {
            return null;
        }
        pp = (QtyCost)fifo.get(0);
        if (MCost.s_log.isLoggable(Level.FINER)) {
            MCost.s_log.finer(product.getName() + " = " + String.valueOf(pp.Cost));
        }
        return pp.Cost;
    }

    /*
     * Unable to fully structure code
     */
    public static BigDecimal calculateLiFo(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID) {
        sql = new StringBuilder("SELECT t.MovementQty, mi.Qty, il.QtyInvoiced, il.PriceActual,").append(" i.C_Currency_ID, i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID, t.M_Transaction_ID ").append("FROM M_Transaction t").append(" INNER JOIN M_MatchInv mi ON (t.M_InOutLine_ID=mi.M_InOutLine_ID)").append(" INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID)").append(" INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) ").append("WHERE t.M_Product_ID=?");
        if (AD_Org_ID != 0) {
            sql.append(" AND t.AD_Org_ID=?");
        } else if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND t.M_AttributeSetInstance_ID=?");
        }
        sql.append(" ORDER BY t.M_Transaction_ID DESC");
        pstmt = null;
        rs = null;
        oldTransaction_ID = 0;
        lifo = new ArrayList<QtyCost>();
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, product.getM_Product_ID());
                if (AD_Org_ID != 0) {
                    pstmt.setInt(2, AD_Org_ID);
                } else if (M_AttributeSetInstance_ID != 0) {
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    block16: {
                        block18: {
                            block17: {
                                movementQty = rs.getBigDecimal(1);
                                M_Transaction_ID = rs.getInt(10);
                                if (M_Transaction_ID == oldTransaction_ID) continue;
                                M_Transaction_ID = oldTransaction_ID;
                                matchQty = rs.getBigDecimal(2);
                                if (matchQty != null) break block16;
                                if (lifo.size() <= 0) break block17;
                                pp = (QtyCost)lifo.get(lifo.size() - 1);
                                pp.Qty = pp.Qty.add(movementQty);
                                remainder = pp.Qty;
                                if (remainder.signum() != 0) ** GOTO lbl48
                                lifo.remove(lifo.size() - 1);
                                break block18;
lbl-1000:
                                // 1 sources

                                {
                                    if (lifo.size() == 1) {
                                        pp.Cost = Env.ZERO;
                                        remainder = Env.ZERO;
                                        continue;
                                    }
                                    lifo.remove(lifo.size() - 1);
                                    pp = (QtyCost)lifo.get(lifo.size() - 1);
                                    remainder = pp.Qty = pp.Qty.add(movementQty);
lbl48:
                                    // 3 sources

                                    ** while (remainder.signum() != 0)
                                }
lbl49:
                                // 1 sources

                                break block18;
                            }
                            pp = new QtyCost(movementQty, Env.ZERO);
                            lifo.add(pp);
                        }
                        if (!MCost.s_log.isLoggable(Level.FINER)) continue;
                        MCost.s_log.finer("Movement=" + String.valueOf(movementQty) + ", Size=" + lifo.size());
                        continue;
                    }
                    price = rs.getBigDecimal(4);
                    C_Currency_ID = rs.getInt(5);
                    DateAcct = rs.getTimestamp(6);
                    C_ConversionType_ID = rs.getInt(7);
                    Client_ID = rs.getInt(8);
                    Org_ID = rs.getInt(9);
                    cost = MConversionRate.convert(product.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), DateAcct, C_ConversionType_ID, Client_ID, Org_ID);
                    pp = new QtyCost(movementQty, cost);
                    lifo.add(pp);
                    if (!MCost.s_log.isLoggable(Level.FINER)) continue;
                    MCost.s_log.finer("Movement=" + String.valueOf(movementQty) + ", Size=" + lifo.size());
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable var20_22) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw var20_22;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (lifo.size() == 0) {
            return null;
        }
        pp = (QtyCost)lifo.get(lifo.size() - 1);
        if (MCost.s_log.isLoggable(Level.FINER)) {
            MCost.s_log.finer(product.getName() + " = " + String.valueOf(pp.Cost));
        }
        return pp.Cost;
    }

    public static MCost get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        MCost cost = null;
        cost = (MCost)new Query(product.getCtx(), "M_Cost", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?", trxName).setParameters(product.getAD_Client_ID(), AD_Org_ID, product.getM_Product_ID(), M_AttributeSetInstance_ID, as.getM_CostType_ID(), as.getC_AcctSchema_ID(), M_CostElement_ID).firstOnly();
        if (cost == null) {
            cost = new MCost(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID);
            cost.set_TrxName(trxName);
        }
        return cost;
    }

    @Deprecated
    public static MCost get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID) {
        return MCost.get(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID, product.get_TrxName());
    }

    public static MCost get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, int M_CostElement_ID, int M_AttributeSetInstance_ID, String trxName) {
        Object[] params = new Object[]{AD_Client_ID, AD_Org_ID, M_Product_ID, M_CostType_ID, C_AcctSchema_ID, M_CostElement_ID, M_AttributeSetInstance_ID};
        return (MCost)new Query(ctx, "M_Cost", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=? AND M_AttributeSetInstance_ID=?", trxName).setOnlyActiveRecords(true).setParameters(params).firstOnly();
    }

    @Deprecated
    public static MCost get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, int M_CostElement_ID, int M_AttributeSetInstance_ID) {
        return MCost.get(ctx, AD_Client_ID, AD_Org_ID, M_Product_ID, M_CostType_ID, C_AcctSchema_ID, M_CostElement_ID, M_AttributeSetInstance_ID, null);
    }

    public MCost(Properties ctx, String M_Cost_UU, String trxName) {
        super(ctx, M_Cost_UU, trxName);
        if (Util.isEmpty(M_Cost_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCost(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setInitialDefaults();
    }

    private void setInitialDefaults() {
        this.setM_AttributeSetInstance_ID(0);
        this.setCurrentCostPrice(Env.ZERO);
        this.setFutureCostPrice(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
        this.setCumulatedAmt(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
    }

    public MCost(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_manual = false;
    }

    public MCost(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID) {
        this(product.getCtx(), 0, product.get_TrxName());
        this.setClientOrg(product.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_CostType_ID(as.getM_CostType_ID());
        this.setM_Product_ID(product.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.m_manual = false;
    }

    public void add(BigDecimal amt, BigDecimal qty) {
        MCostElement costElement = (MCostElement)this.getM_CostElement();
        if ((costElement.isAveragePO() || costElement.isAverageInvoice()) && this.getCurrentQty().add(qty).signum() < 0) {
            throw new AverageCostingNegativeQtyException("Product(ID)=" + this.getM_Product_ID() + ", Current Qty=" + String.valueOf(this.getCurrentQty()) + ", Trx Qty=" + String.valueOf(qty) + ", CostElement=" + costElement.getName() + ", Schema=" + this.getC_AcctSchema().getName());
        }
        this.setCumulatedAmt(this.getCumulatedAmt().add(amt));
        this.setCumulatedQty(this.getCumulatedQty().add(qty));
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }

    public void setWeightedAverage(BigDecimal amt, BigDecimal qty) {
        if (amt.signum() != 0 && qty.signum() != 0 && amt.signum() != qty.signum()) {
            amt = amt.negate();
        }
        if (qty.signum() == 0 && this.getCurrentQty().signum() <= 0) {
            throw new AverageCostingZeroQtyException("Product(ID)=" + this.getM_Product_ID() + ", Current Qty=" + String.valueOf(this.getCurrentQty()) + ", Trx Qty=" + String.valueOf(qty) + ", CostElement=" + this.getM_CostElement().getName() + ", Schema=" + this.getC_AcctSchema().getName());
        }
        if (this.getCurrentQty().add(qty).signum() < 0) {
            throw new AverageCostingNegativeQtyException("Product(ID)=" + this.getM_Product_ID() + ", Current Qty=" + String.valueOf(this.getCurrentQty()) + ", Trx Qty=" + String.valueOf(qty) + ", CostElement=" + this.getM_CostElement().getName() + ", Schema=" + this.getC_AcctSchema().getName());
        }
        BigDecimal sumQty = this.getCurrentQty().add(qty);
        if (sumQty.signum() != 0) {
            BigDecimal newCost;
            BigDecimal oldSum = this.getCurrentCostPrice().multiply(this.getCurrentQty());
            BigDecimal oldCost = oldSum.divide(sumQty, 12, RoundingMode.HALF_UP);
            BigDecimal cost = oldCost.add(newCost = amt.divide(sumQty, 12, RoundingMode.HALF_UP));
            if (cost.scale() > this.getPrecision() * 2) {
                cost = cost.setScale(this.getPrecision() * 2, RoundingMode.HALF_UP);
            }
            this.setCurrentCostPrice(cost);
        }
        this.setCumulatedAmt(this.getCumulatedAmt().add(amt));
        this.setCumulatedQty(this.getCumulatedQty().add(qty));
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }

    public void setWeightedAverageInitial(BigDecimal amtUnit) {
        BigDecimal cost = amtUnit;
        if (cost.scale() > this.getPrecision() * 2) {
            cost = cost.setScale(this.getPrecision() * 2, RoundingMode.HALF_UP);
        }
        this.setCurrentCostPrice(cost);
    }

    protected int getPrecision() {
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.getC_AcctSchema_ID());
        if (as != null) {
            return as.getCostingPrecision();
        }
        return 6;
    }

    @Override
    public void setCurrentCostPrice(BigDecimal currentCostPrice) {
        if (currentCostPrice != null) {
            super.setCurrentCostPrice(currentCostPrice);
        } else {
            super.setCurrentCostPrice(Env.ZERO);
        }
    }

    public BigDecimal getHistoryAverage() {
        BigDecimal retValue = null;
        if (this.getCumulatedQty().signum() != 0 && this.getCumulatedAmt().signum() != 0) {
            retValue = this.getCumulatedAmt().divide(this.getCumulatedQty(), this.getPrecision(), RoundingMode.HALF_UP);
        }
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MCost[");
        sb.append("AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.getAD_Org_ID() != 0) {
            sb.append(",AD_Org_ID=").append(this.getAD_Org_ID());
        }
        sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        if (this.getM_AttributeSetInstance_ID() != 0) {
            sb.append(",AD_ASI_ID=").append(this.getM_AttributeSetInstance_ID());
        }
        sb.append(",M_CostElement_ID=").append(this.getM_CostElement_ID());
        sb.append(", CurrentCost=").append(this.getCurrentCostPrice()).append(", C.Amt=").append(this.getCumulatedAmt()).append(",C.Qty=").append(this.getCumulatedQty()).append("]");
        return sb.toString();
    }

    public MCostElement getCostElement() {
        int M_CostElement_ID = this.getM_CostElement_ID();
        if (M_CostElement_ID == 0) {
            return null;
        }
        return MCostElement.getCopy(this.getCtx(), M_CostElement_ID, this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MCostElement ce = (MCostElement)this.getM_CostElement();
        if (this.m_manual) {
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            if ("C".equals(CostingLevel)) {
                if (this.getAD_Org_ID() != 0 || this.getM_AttributeSetInstance_ID() != 0) {
                    this.log.saveError("CostingLevelClient", "");
                    return false;
                }
            } else if ("B".equals(CostingLevel)) {
                if (this.getM_AttributeSetInstance_ID() == 0 && ce.isCostingMethod()) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_AttributeSetInstance_ID"));
                    return false;
                }
                if (this.getAD_Org_ID() != 0) {
                    this.setAD_Org_ID(0);
                }
            }
        }
        if (this.m_manual && ce != null && ce.isCalculated()) {
            this.log.saveError("Error", Msg.getElement(this.getCtx(), "IsCalculated"));
            return false;
        }
        if (ce != null && (ce.isCalculated() || "M".equals(ce.getCostElementType()) && this.getPercent() != 0)) {
            this.setPercent(0);
        }
        if (this.getPercent() != 0) {
            if (this.getCurrentCostPrice().signum() != 0) {
                this.setCurrentCostPrice(Env.ZERO);
            }
            if (this.getFutureCostPrice().signum() != 0) {
                this.setFutureCostPrice(Env.ZERO);
            }
            if (this.getCumulatedAmt().signum() != 0) {
                this.setCumulatedAmt(Env.ZERO);
            }
            if (this.getCumulatedQty().signum() != 0) {
                this.setCumulatedQty(Env.ZERO);
            }
        }
        if (ce != null && (ce.isAveragePO() || ce.isAverageInvoice()) && this.is_ValueChanged("CurrentQty") && this.getCurrentQty().signum() < 0) {
            throw new AverageCostingNegativeQtyException("Product(ID)=" + this.getM_Product_ID() + ", Current Qty=" + String.valueOf(this.getCurrentQty()) + ", CostElement=" + this.getM_CostElement().getName() + ", Schema=" + this.getC_AcctSchema().getName());
        }
        return true;
    }

    @Override
    public void setCurrentQty(BigDecimal CurrentQty) {
        MCostElement ce = (MCostElement)this.getM_CostElement();
        if ((ce.isAveragePO() || ce.isAverageInvoice()) && CurrentQty.signum() < 0) {
            throw new AverageCostingNegativeQtyException("Product=" + this.getM_Product().getName() + ", Current Qty=" + String.valueOf(this.getCurrentQty()) + ", New Current Qty=" + String.valueOf(CurrentQty) + ", CostElement=" + ce.getName() + ", Schema=" + this.getC_AcctSchema().getName());
        }
        super.setCurrentQty(CurrentQty);
    }

    public static class QtyCost {
        public BigDecimal Qty = null;
        public BigDecimal Cost = null;

        public QtyCost(BigDecimal qty, BigDecimal cost) {
            this.Qty = qty;
            this.Cost = cost;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Qty=").append(this.Qty).append(",Cost=").append(this.Cost);
            return sb.toString();
        }
    }
}

