/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import org.compiere.util.Util;

public class Join {
    private String m_joinClause;
    private String m_mainTable;
    private String m_mainAlias;
    private String m_joinTable;
    private String m_joinAlias;
    private boolean m_left;
    private String m_condition;

    public Join(String joinClause) {
        if (joinClause == null) {
            throw new IllegalArgumentException("Join - clause cannot be null");
        }
        this.evaluate(joinClause);
    }

    private void evaluate(String joinClause) {
        this.m_joinClause = joinClause;
        int indexEqual = joinClause.indexOf(61);
        boolean bl = this.m_left = indexEqual < joinClause.indexOf("(+)");
        if (this.m_left) {
            this.m_mainAlias = joinClause.substring(0, Util.findIndexOf(joinClause, '.', '=')).trim();
            int end = joinClause.indexOf(46, indexEqual);
            if (end == -1) {
                end = joinClause.indexOf(40, indexEqual);
            }
            this.m_joinAlias = joinClause.substring(indexEqual + 1, end).trim();
        } else {
            int end = joinClause.indexOf(46, indexEqual);
            if (end == -1) {
                end = joinClause.length();
            }
            this.m_mainAlias = joinClause.substring(indexEqual + 1, end).trim();
            this.m_joinAlias = joinClause.substring(0, Util.findIndexOf(joinClause, '.', '(')).trim();
        }
        this.m_condition = Util.replace(joinClause, "(+)", "").trim();
    }

    public String getJoinClause() {
        return this.m_joinClause;
    }

    public String getMainAlias() {
        return this.m_mainAlias;
    }

    public String getJoinAlias() {
        return this.m_joinAlias;
    }

    public boolean isLeft() {
        return this.m_left;
    }

    public String getCondition() {
        return this.m_condition;
    }

    public void setMainTable(String mainTable) {
        if (mainTable == null || mainTable.length() == 0) {
            return;
        }
        this.m_mainTable = mainTable;
        if (this.m_mainAlias.equals(mainTable)) {
            this.m_mainAlias = "";
        }
    }

    public String getMainTable() {
        return this.m_mainTable;
    }

    public void setJoinTable(String joinTable) {
        if (joinTable == null || joinTable.length() == 0) {
            return;
        }
        this.m_joinTable = joinTable;
        if (this.m_joinAlias.equals(joinTable)) {
            this.m_joinAlias = "";
        }
    }

    public String getJoinTable() {
        return this.m_joinTable;
    }

    public boolean isConditionOf(Join first) {
        return this.m_mainTable == null && (first.getJoinTable().equals(this.m_joinTable) || first.getMainAlias().equals(this.m_joinTable));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Join[");
        sb.append(this.m_joinClause).append(" - Main=").append(this.m_mainTable).append("/").append(this.m_mainAlias).append(", Join=").append(this.m_joinTable).append("/").append(this.m_joinAlias).append(", Left=").append(this.m_left).append(", Condition=").append(this.m_condition).append("]");
        return sb.toString();
    }
}

