/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PORelationException;
import org.adempiere.model.IZoomProvider;
import org.adempiere.model.ZoomInfoFactory;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRefTable;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_RelationType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MRelationType
extends X_AD_RelationType
implements IZoomProvider {
    private static final CLogger logger = CLogger.getCLogger(MRelationType.class);
    protected static final String SQL = "  SELECT     rt.AD_RelationType_ID,   rt.Name,   rt.IsDirected,   ref.AD_Reference_ID,   tab.WhereClause,   tab.OrderByClause  FROM    AD_RelationType rt, AD_Reference ref, AD_Ref_Table tab  WHERE     rt.IsActive='Y'    AND ref.IsActive='Y'    AND ref.ValidationType='T'    AND (      rt.AD_Reference_Source_ID=ref.AD_Reference_ID      OR (        rt.IsDirected='N'         AND rt.AD_Reference_Target_ID=ref.AD_Reference_ID      )    )    AND tab.IsActive='Y'    AND tab.AD_Reference_ID=ref.AD_Reference_ID    AND tab.AD_Table_ID=?    AND tab.AD_Key=?  ORDER BY rt.Name";
    protected static final String SQL_WINDOW_NAME = "SELECT Name FROM AD_Window WHERE AD_WINDOW_ID=?";
    protected static final String SQL_WINDOW_NAME_TRL = "SELECT Name FROM AD_Window_Trl WHERE AD_WINDOW_ID=? AND AD_LANGUAGE=?";
    private static final long serialVersionUID = 5486148151201672913L;
    public int destinationRefId;

    public MRelationType(Properties ctx, String AD_RelationType_UU, String trxName) {
        super(ctx, AD_RelationType_UU, trxName);
    }

    public MRelationType(Properties ctx, int AD_RelationType_ID, String trxName) {
        super(ctx, AD_RelationType_ID, trxName);
    }

    public MRelationType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRelationType(Properties ctx, int AD_RelationType_ID, String trxName, String ... virtualColumns) {
        super(ctx, AD_RelationType_ID, trxName, virtualColumns);
    }

    public static List<MRelationType> retrieveTypes(PO po, int windowId) {
        List<MRelationType> list;
        if (po.get_KeyColumns().length != 1) {
            logger.severe(String.valueOf(po) + " has " + po.get_KeyColumns().length + " key column(s). Should have one.");
            PORelationException.throwWrongKeyColumnCount(po);
        }
        String keyColumn = po.get_KeyColumns()[0];
        int colId = MColumn.getColumn_ID(po.get_TableName(), keyColumn);
        CPreparedStatement pstmt = DB.prepareStatement(SQL, po.get_TrxName());
        ResultSet rs = null;
        try {
            pstmt.setInt(1, po.get_Table_ID());
            pstmt.setInt(2, colId);
            rs = pstmt.executeQuery();
            List<MRelationType> result = MRelationType.evalResultSet(po, windowId, rs);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("There are " + result.size() + " matching types for " + String.valueOf(po));
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                logger.severe(e.getMessage());
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return list;
    }

    public static List<ZoomInfoFactory.ZoomInfo> retrieveZoomInfos(PO po, int windowID) {
        List<MRelationType> matchingTypes = MRelationType.retrieveTypes(po, windowID);
        ArrayList<ZoomInfoFactory.ZoomInfo> result = new ArrayList<ZoomInfoFactory.ZoomInfo>();
        for (MRelationType currentType : matchingTypes) {
            result.addAll(currentType.retrieveZoomInfos(po));
        }
        return result;
    }

    private String getDestinationRoleDisplay() {
        String keyValue;
        Integer colIdx;
        this.checkDestinationRefId();
        if (this.destinationRefId == this.getAD_Reference_Source_ID()) {
            colIdx = this.get_ColumnIndex("Role_Source");
            keyValue = this.getRole_Source();
        } else {
            colIdx = this.get_ColumnIndex("Role_Target");
            keyValue = this.getRole_Target();
        }
        if (Util.isEmpty(keyValue)) {
            return "";
        }
        Lookup lookup = this.p_info.getColumnLookup(colIdx);
        return lookup.getDisplay(keyValue);
    }

    private String retrieveWindowName(int windowId) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block5: {
            String string;
            boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
            String sql = baseLanguage ? SQL_WINDOW_NAME : SQL_WINDOW_NAME_TRL;
            pstmt = DB.prepareStatement(sql, null);
            rs = null;
            try {
                pstmt.setInt(1, windowId);
                if (!baseLanguage) {
                    pstmt.setString(2, Env.getAD_Language(Env.getCtx()));
                }
                if (!(rs = pstmt.executeQuery()).next()) break block5;
                string = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    throw new AdempiereException(e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            return string;
        }
        DB.close(rs, pstmt);
        return null;
    }

    private static List<MRelationType> evalResultSet(PO po, int windowId, ResultSet rs) throws SQLException {
        ArrayList<MRelationType> result = new ArrayList<MRelationType>();
        HashSet<Integer> alreadySeen = new HashSet<Integer>();
        while (rs.next()) {
            MRefTable sourceRefTable;
            int relTypeId = rs.getInt("AD_RelationType_ID");
            if (!alreadySeen.add(relTypeId)) continue;
            MRelationType newType = new MRelationType(po.getCtx(), relTypeId, po.get_TrxName());
            newType.destinationRefId = newType.isDirected() ? newType.getAD_Reference_Target_ID() : (newType.retrieveSourceTableName().equals(newType.retrieveTargetTableName()) ? (windowId == newType.retrieveWindowID(po, sourceRefTable = MRelationType.retrieveRefTable(po.getCtx(), newType.getAD_Reference_Source_ID(), po.get_TrxName())) ? newType.getAD_Reference_Target_ID() : newType.getAD_Reference_Source_ID()) : (po.get_TableName().equals(newType.retrieveSourceTableName()) ? newType.getAD_Reference_Target_ID() : newType.getAD_Reference_Source_ID()));
            result.add(newType);
        }
        return result;
    }

    protected static boolean whereClauseMatches(PO po, String where) {
        boolean match;
        if (Util.isEmpty(where, true)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("whereClause is empty. Returning true");
            }
            return true;
        }
        String parsedWhere = MRelationType.parseWhereClause(po, where);
        if (Util.isEmpty(parsedWhere)) {
            return false;
        }
        Object result = new Query(po.getCtx(), po.get_TableName(), parsedWhere, po.get_TrxName()).first();
        boolean bl = match = result != null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("whereClause='" + parsedWhere + "' matches po='" + String.valueOf(po) + "':" + match);
        }
        return match;
    }

    public static String parseWhereClause(PO po, String where) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("building private ctx instance containing the PO's String and int values");
        }
        Properties privateCtx = new Properties();
        privateCtx.putAll((Map<?, ?>)po.getCtx());
        int i2 = 0;
        while (i2 < po.get_ColumnCount()) {
            Object val = po.get_Value(i2);
            if (val != null) {
                if (val instanceof Integer) {
                    Env.setContext(privateCtx, "#" + po.get_ColumnName(i2), (Integer)val);
                    Env.setContext(privateCtx, po.get_ColumnName(i2), (Integer)val);
                } else if (val instanceof String) {
                    Env.setContext(privateCtx, "#" + po.get_ColumnName(i2), (String)val);
                    Env.setContext(privateCtx, po.get_ColumnName(i2), (String)val);
                }
            }
            ++i2;
        }
        String parsedWhere = Env.parseContext(privateCtx, -1, where, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("whereClause='" + where + "'; parsedWhere='" + parsedWhere + "'");
        }
        return parsedWhere;
    }

    public void checkDestinationRefId() {
        if (this.destinationRefId == 0) {
            throw new IllegalStateException("Can't create a destination query when I don't know which one of the two AD_Reference_ID is the destination.");
        }
    }

    @Override
    public List<ZoomInfoFactory.ZoomInfo> retrieveZoomInfos(PO po) {
        this.checkDestinationRefId();
        MRefTable refTable = MRelationType.retrieveRefTable(this.getCtx(), this.destinationRefId, this.get_TrxName());
        MQuery query = new MQuery();
        query.addRestriction(MRelationType.parseWhereClause(po, refTable.getWhereClause()));
        query.setZoomTableName(this.retrieveDestinationTableName());
        query.setZoomColumnName(this.retrieveDestinationKeyColName());
        MRelationType.evaluateQuery(query);
        int windowId = this.retrieveWindowID(po, refTable);
        String display = this.getDestinationRoleDisplay();
        if (Util.isEmpty(display)) {
            display = this.retrieveWindowName(windowId);
        }
        assert (!Util.isEmpty(display));
        return Collections.singletonList(new ZoomInfoFactory.ZoomInfo(windowId, query, display));
    }

    public int retrieveWindowID(PO po, MRefTable refTable) {
        MTable table2 = null;
        int windowId = refTable.getAD_Window_ID();
        if (windowId == 0) {
            int tableId = refTable.getAD_Table_ID();
            table2 = MTable.get(po.getCtx(), tableId);
            windowId = Env.isSOTrx(po.getCtx()) ? table2.getAD_Window_ID() : table2.getPO_Window_ID();
        }
        if (windowId == 0) {
            PORelationException.throwMissingWindowId(po, this.getAD_Reference_Target().getName(), table2.getName(), Env.isSOTrx(po.getCtx()));
        }
        return windowId;
    }

    public static MRefTable retrieveRefTable(Properties ctx, int referenceId, String trxName) {
        Object[] params = new Object[]{referenceId};
        MRefTable refTable = (MRefTable)new Query(ctx, "AD_Ref_Table", "AD_Reference_ID=?", trxName).setParameters(params).firstOnly();
        return refTable;
    }

    private static void evaluateQuery(MQuery query) {
        StringBuilder sqlCommon = new StringBuilder(" FROM ").append(query.getZoomTableName()).append(" WHERE ").append(query.getWhereClause(false));
        String sqlCount = "SELECT COUNT(*) " + String.valueOf(sqlCommon);
        int count = DB.getSQLValueEx(null, sqlCount, new Object[0]);
        query.setRecordCount(count);
        if (count > 0) {
            StringBuilder sqlFirstKey = new StringBuilder("SELECT ").append(query.getZoomColumnName()).append((CharSequence)sqlCommon);
            int firstKey = DB.getSQLValueEx(null, sqlFirstKey.toString(), new Object[0]);
            query.setZoomValue(firstKey);
        }
    }

    private String retrieveSourceTableName() {
        return this.retrieveTableName(this.getAD_Reference_Source_ID());
    }

    private String retrieveTargetTableName() {
        return this.retrieveTableName(this.getAD_Reference_Target_ID());
    }

    public String retrieveDestinationTableName() {
        return this.retrieveTableName(this.destinationRefId);
    }

    private String retrieveTableName(int refId) {
        return MRelationType.retrieveRefTable(this.getCtx(), refId, this.get_TrxName()).getAD_Table().getTableName();
    }

    public String retrieveDestinationKeyColName() {
        int keyColumnId = MRelationType.retrieveRefTable(this.getCtx(), this.destinationRefId, this.get_TrxName()).getAD_Key();
        return MColumn.getColumnName(this.getCtx(), keyColumnId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRelationType[");
        sb.append(this.get_ID());
        sb.append(", Name=").append(this.getName());
        sb.append(", Type=").append(this.getType());
        sb.append(", AD_Reference_Destination_RefId=").append(this.destinationRefId);
        sb.append(", AD_Reference_Source_ID=").append(this.getAD_Reference_Source_ID());
        sb.append(", Role_Source=").append(this.getRole_Source());
        sb.append(", AD_Reference_Target_ID=").append(this.getAD_Reference_Target_ID());
        sb.append(", Role_Target=").append(this.getRole_Target());
        sb.append("]");
        return sb.toString();
    }
}

