/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeplot.data;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.zkforge.json.simple.JSONObject;

public class PlotData {
    private static int count = 0;
    private int _id = count++;
    private Date _time = new Date();
    private Float _value = new Float(0.0f);
    private String _format = "yyyy-MM-dd'T'HH:mm:ss";
    private Map _customValues;
    private boolean isCustomFormat = false;

    public String toString() {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)String.valueOf(this._id));
        json.put((Object)"time", (Object)this.getDefaultFormat().format(this._time));
        json.put((Object)"value", (Object)String.valueOf(this._value));
        if (this.isCustomFormat) {
            json.put((Object)"format", (Object)this._format);
        }
        if (this._customValues != null) {
            json.put((Object)"customValues", (Object)this.enclossMapToJason(this._customValues));
        }
        return json.toString();
    }

    public void setFormat(String format) {
        if (format == null || format.length() == 0) {
            format = "yyyy-MM-dd'T'HH:mm:ss";
        }
        this._format = format;
        this.isCustomFormat = true;
    }

    public String getFormat() {
        return this._format;
    }

    protected DateFormat getDefaultFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public Date getTime() {
        return this._time;
    }

    public void setTime(Date time) {
        this._time = time;
    }

    public Float getValue() {
        return this._value;
    }

    public void setValue(Float value) {
        this._value = value;
    }

    public void setCustomValues(Map _customValues) {
        this._customValues = _customValues;
    }

    public Map getCustomValues() {
        return this._customValues;
    }

    private String enclossMapToJason(Map map) {
        JSONObject json = new JSONObject();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            json.put(me.getKey(), me.getValue());
        }
        return json.toString();
    }
}

