/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeplot;

import java.io.IOException;
import java.util.List;
import org.zkforge.timeline.data.OccurEvent;
import org.zkforge.timeplot.Plotinfo;
import org.zkforge.timeplot.data.PlotData;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ListModel;

public class Timeplot
extends HtmlBasedComponent {
    private String _height = "200px";
    private String _width;
    private boolean _hideTimeFlag = false;
    private String _timeFlagFormat;

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (!Objects.equals((Object)this._height, (Object)height)) {
            this._height = height;
            this.smartUpdate("height", height);
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.smartUpdate("width", width);
        }
    }

    public boolean isHideTimeFlag() {
        return this._hideTimeFlag;
    }

    public void setHideTimeFlag(boolean hideTimeFlag) {
        if (this._hideTimeFlag != hideTimeFlag) {
            this._hideTimeFlag = hideTimeFlag;
            this.smartUpdate("hideTimeFlag", this._hideTimeFlag);
            this.repaint();
        }
    }

    public void setTimeFlagFormat(String timeFlagFormat) {
        if (this._timeFlagFormat != timeFlagFormat) {
            this._timeFlagFormat = timeFlagFormat;
        }
        this.smartUpdate("timeFlagFormat", this._timeFlagFormat);
        this.repaint();
    }

    public String getTimeFlagFormat() {
        return this._timeFlagFormat;
    }

    public void repaint() {
        if (this.isInvalidated()) {
            return;
        }
        this.response("repaint" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "repaint", null));
        List children = this.getChildren();
        int j = children.size();
        for (int i = 0; i < j; ++i) {
            ListModel eventModel;
            Plotinfo plot = (Plotinfo)((Object)children.get(i));
            ListModel dateModel = plot.getDataModel();
            if (dateModel != null) {
                int l = dateModel.getSize();
                for (int k = 0; k < l; ++k) {
                    plot.addPlotData((PlotData)dateModel.getElementAt(k));
                }
            }
            if ((eventModel = plot.getEventModel()) == null) continue;
            int l = eventModel.getSize();
            for (int k = 0; k < l; ++k) {
                plot.addPlotEvent((OccurEvent)eventModel.getElementAt(k));
            }
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Plotinfo)) {
            throw new UiException("Unsupported child for timeplot: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"200px".equals(this._height)) {
            this.render(renderer, "height", this._height);
        }
        this.render(renderer, "width", this._width);
        if (this._hideTimeFlag) {
            renderer.render("hideTimeFlag", this._hideTimeFlag);
        }
        if (this._timeFlagFormat != null) {
            renderer.render("timeFlagFormat", this._timeFlagFormat);
        }
    }
}

