/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps.event;

import java.util.Map;
import org.zkoss.gmaps.LatLng;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.DropEvent;

public class MapDropEvent
extends DropEvent {
    private LatLng _latLng;

    public static final MapDropEvent getMapDropEvent(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        Map data = request.getData();
        if (data == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        Component ref = request.getDesktop().getComponentByUuidIfAny((String)data.get("dragged"));
        double lat = ((Number)data.get("lat")).doubleValue();
        double lng = ((Number)data.get("lng")).doubleValue();
        Number xn = (Number)data.get("x");
        Number yn = (Number)data.get("y");
        Number pxn = (Number)data.get("pageX");
        Number pyn = (Number)data.get("pageY");
        int x = xn instanceof Double ? (int)Math.round((Double)xn) : xn.intValue();
        int y = yn instanceof Double ? (int)Math.round((Double)yn) : yn.intValue();
        int pageX = pxn instanceof Double ? (int)Math.round((Double)pxn) : pxn.intValue();
        int pageY = pyn instanceof Double ? (int)Math.round((Double)pyn) : pyn.intValue();
        return new MapDropEvent(request.getCommand(), comp, ref, new LatLng(lat, lng), x, y, pageX, pageY, AuRequests.parseKeys((Map)data));
    }

    public MapDropEvent(String name, Component target, Component dragged, LatLng latLng, int x, int y, int pageX, int pageY, int keys) {
        super(name, target, dragged, x, y, pageX, pageY, keys);
        this._latLng = latLng;
    }

    public MapDropEvent(String name, Component target, Component dragged, double lat, double lng, int x, int y, int pageX, int pageY, int keys) {
        this(name, target, dragged, new LatLng(lat, lng), x, y, pageX, pageY, keys);
    }

    public LatLng getLatLng() {
        return this._latLng;
    }

    public double getLat() {
        return this._latLng.getLatitude();
    }

    public double getLng() {
        return this._latLng.getLongitude();
    }

    public final int getClientX() {
        return this.getPageX();
    }

    public final int getClientY() {
        return this.getPageY();
    }
}

