/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromPackageShipment;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageMPS;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MShipper;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromPackageShipmentFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromShipmentLine() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        orderLine.setQty(new BigDecimal("1"));
        orderLine.setDatePromised(today);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(orderLine, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        MShipper shipper = new MShipper(Env.getCtx(), DictionaryIDs.M_Shipper.UPS.id, this.getTrxName());
        MPackage mPackage = new MPackage(shipment, shipper);
        mPackage.setBoxCount(1);
        mPackage.saveEx();
        Query q = new Query(Env.getCtx(), "M_PackageMPS", "M_Package_ID=?", this.getTrxName());
        MPackageMPS mps = (MPackageMPS)q.setParameters(new Object[]{mPackage.getM_Package_ID()}).first();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)169);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Shipment (Customer)");
        int index = -1;
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            gridWindow.initTab(i);
            GridTab gt = gridWindow.getTab(i);
            if (gt.getAD_Table_ID() == 200044) {
                index = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0, (String)"Failed to find Grid Tab for MPackageMPS");
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", shipment.get_ID());
        gridWindow.getTab(0).setQuery(query);
        gridWindow.getTab(0).getTableModel().setImportingMode(false, this.getTrxName());
        gridWindow.getTab(0).query(false);
        Assertions.assertEquals((int)1, (int)gridWindow.getTab(0).getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)shipment.get_ID(), (int)gridWindow.getTab(0).getRecord_ID(), (String)"Wrong shipment record id");
        ArrayList<GridTab> gtabs = new ArrayList<GridTab>();
        gtabs.add(gridWindow.getTab(index));
        int currentLevel = gridWindow.getTab(index).getTabLevel();
        int i2 = index - 1;
        while (i2 > 0) {
            int level = gridWindow.getTab(i2).getTabLevel();
            if (level > currentLevel) break;
            if (level != currentLevel) {
                currentLevel = level;
                gtabs.add(gridWindow.getTab(i2));
            }
            --i2;
        }
        i2 = gtabs.size() - 1;
        while (i2 >= 0) {
            ((GridTab)gtabs.get(i2)).getTableModel().setImportingMode(false, this.getTrxName());
            ((GridTab)gtabs.get(i2)).query(false);
            --i2;
        }
        Assertions.assertEquals((Object)mps.get_ID(), (Object)gridWindow.getTab(index).getValue("M_PackageMPS_ID"), (String)"Wrong MPackageMPS record id");
        CreateFromPackageShipmentImpl form = new CreateFromPackageShipmentImpl(gridWindow.getTab(index));
        form.setTrxName(this.getTrxName());
        form.loadShipmentLines(shipment.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i3 = 0;
        while (i3 < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i3, 1);
            if (pp.getKey() == shipmentLine.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i3, 0);
                form.minitable.setSelectedRow(i3);
                break;
            }
            ++i3;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find shipment line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        q = new Query(Env.getCtx(), "M_PackageLine", "M_PackageMPS_ID=?", this.getTrxName());
        List pls = q.setParameters(new Object[]{mps.get_ID()}).list();
        Assertions.assertTrue((pls.size() > 0 ? 1 : 0) != 0, (String)"Failed to create new MPackageLine record");
    }

    private static class CreateFromPackageShipmentImpl
    extends CreateFromPackageShipment {
        private MiniTableImpl minitable = null;

        public CreateFromPackageShipmentImpl(GridTab gridTab) {
            super(gridTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return this;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public void loadShipmentLines(int M_InOut_ID) {
            Vector datas = super.getShipmentData(M_InOut_ID);
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

