/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONs;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class JsContentRenderer
implements ContentRenderer {
    private final StringBuilder _buf = new StringBuilder(128);

    public CharSequence getBuffer() {
        return this._buf;
    }

    @Override
    public void render(String name, String value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, Date value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, Object value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, int value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, long value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, short value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, byte value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, boolean value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, double value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, float value) {
        this.renderName(name);
        this.renderValue(value);
    }

    @Override
    public void render(String name, char value) {
        this.renderName(name);
        this.renderValue(value);
    }

    private void renderName(String name) {
        if (this._buf.length() > 0) {
            this._buf.append(',');
        }
        this._buf.append(name).append(':');
    }

    private void renderValue(String value) {
        if (value == null) {
            this._buf.append((String)null);
        } else {
            this._buf.append('\'');
            this._buf.append(Strings.escapeJavaScript((String)value));
            this._buf.append('\'');
        }
    }

    private void renderValue(Date value) {
        if (value == null) {
            this._buf.append((String)null);
        } else {
            this._buf.append("jq.j2d('").append(JSONs.d2j((Date)value)).append("')");
        }
    }

    private void renderValue(Component value) {
        if (value == null || value.getPage() == null) {
            this._buf.append((String)null);
        } else {
            this._buf.append("{$u:'").append(value.getUuid()).append("'}");
        }
    }

    private void renderValue(Object value) {
        if (value == null || value instanceof String) {
            this.renderValue((String)value);
            return;
        }
        if (value instanceof Date) {
            this.renderValue((Date)value);
            return;
        }
        if (value instanceof Component) {
            this.renderValue((Component)value);
            return;
        }
        if (value instanceof Integer) {
            this.renderValue((Integer)value);
            return;
        }
        if (value instanceof Long) {
            this.renderValue((Long)value);
            return;
        }
        if (value instanceof Double) {
            this.renderValue((Double)value);
            return;
        }
        if (value instanceof Short) {
            this.renderValue((Short)value);
            return;
        }
        if (value instanceof Byte) {
            this.renderValue((Byte)value);
            return;
        }
        if (value instanceof Boolean) {
            this.renderValue((Boolean)value);
            return;
        }
        if (value instanceof Float) {
            this.renderValue(((Float)value).floatValue());
            return;
        }
        if (value instanceof Character) {
            this.renderValue(((Character)value).charValue());
            return;
        }
        if (value instanceof BigDecimal) {
            this.renderValue(((BigDecimal)value).toString());
            return;
        }
        if (value instanceof Map) {
            this._buf.append('{');
            boolean first = true;
            for (Map.Entry me : ((Map)value).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this._buf.append(',');
                }
                this._buf.append('\'').append(me.getKey()).append("':");
                this.renderValue(me.getValue());
            }
            this._buf.append('}');
            return;
        }
        if (value instanceof List) {
            this._buf.append('[');
            int j = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(it.next());
                ++j;
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof Object[]) {
            this._buf.append('[');
            Object[] ary = (Object[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof int[]) {
            this._buf.append('[');
            int[] ary = (int[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof long[]) {
            this._buf.append('[');
            long[] ary = (long[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof short[]) {
            this._buf.append('[');
            short[] ary = (short[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof float[]) {
            this._buf.append('[');
            float[] ary = (float[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof double[]) {
            this._buf.append('[');
            double[] ary = (double[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof byte[]) {
            this._buf.append('[');
            byte[] ary = (byte[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof char[]) {
            this._buf.append('[');
            char[] ary = (char[])value;
            for (int j = 0; j < ary.length; ++j) {
                if (j > 0) {
                    this._buf.append(',');
                }
                this.renderValue(ary[j]);
            }
            this._buf.append(']');
            return;
        }
        if (value instanceof JSONAware) {
            this._buf.append(((JSONAware)value).toJSONString());
        } else {
            this.renderValue(value.toString());
        }
    }

    private void renderValue(int value) {
        this._buf.append(value);
    }

    private void renderValue(long value) {
        this._buf.append(value);
    }

    private void renderValue(short value) {
        this._buf.append(value);
    }

    private void renderValue(byte value) {
        this._buf.append(value);
    }

    private void renderValue(boolean value) {
        this._buf.append(value);
    }

    private void renderValue(double value) {
        this._buf.append(value);
    }

    private void renderValue(float value) {
        this._buf.append(value);
    }

    private void renderValue(char value) {
        this._buf.append('\'');
        switch (value) {
            case '\'': 
            case '\\': {
                this._buf.append('\\');
                break;
            }
            case '\n': {
                this._buf.append('\\');
                value = (char)110;
                break;
            }
            case '\t': {
                this._buf.append('\\');
                value = (char)116;
                break;
            }
            case '\r': {
                this._buf.append('\\');
                value = (char)114;
                break;
            }
            case '\f': {
                this._buf.append('\\');
                value = (char)102;
            }
        }
        this._buf.append(value).append('\'');
    }

    @Override
    public void renderDirectly(String name, Object value) {
        this.renderName(name);
        if (value != null && !(value instanceof String)) {
            throw new UnsupportedOperationException("Only String or null allowed, not " + value.toString());
        }
        this._buf.append((String)value);
    }

    @Override
    public void renderWidgetListeners(Map<String, String> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        this.renderName("listeners");
        this._buf.append('{');
        for (Map.Entry<String, String> me : listeners.entrySet()) {
            this._buf.append((Object)me.getKey()).append(":function(event){\n").append((Object)me.getValue()).append("\n},");
        }
        this._buf.setCharAt(this._buf.length() - 1, '}');
    }

    @Override
    public void renderWidgetOverrides(Map<String, String> overrides) {
        if (overrides == null || overrides.isEmpty()) {
            return;
        }
        this.renderName("overrides");
        this._buf.append('{');
        for (Map.Entry<String, String> me : overrides.entrySet()) {
            char cc;
            String v;
            String name = me.getKey();
            String value = me.getValue();
            if (value != null && (v = value.trim()).length() != 0 && ((cc = v.charAt(v.length() - 1)) == ';' || cc == ',' || v.indexOf("function") < 0 && v.indexOf(59) >= 0)) {
                throw new UiException("Illegal client override: " + v + (name.startsWith("on") ? "\nTo listen an event, remember to captalize the third letter, such as onClick" : "\nIt must be a legal JavaScript expression (not statement)"));
            }
            this._buf.append(name).append(":\n").append(value.length() == 0 ? "''" : value).append("\n,");
        }
        this._buf.setCharAt(this._buf.length() - 1, '}');
    }

    @Override
    public void renderWidgetAttributes(Map<String, String> attrs) {
        this.renderClientAttributes(attrs);
    }

    @Override
    public void renderClientAttributes(Map<String, String> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        this.renderName("domExtraAttrs");
        this._buf.append('{');
        for (Map.Entry<String, String> me : attrs.entrySet()) {
            this.renderValue((Object)me.getKey());
            this._buf.append(':');
            this.renderValue((Object)me.getValue());
            this._buf.append("\n,");
        }
        this._buf.setCharAt(this._buf.length() - 1, '}');
    }
}

