/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.ConditionLeafInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.Utils;

public class VariablesInfo
extends ConditionLeafInfo {
    private final Map<String, Object> _vars;
    private final int _composite;
    private final boolean _local;

    public VariablesInfo(NodeInfo parent, Map<String, String> vars, boolean local, String composite, ConditionImpl cond) {
        super(parent, cond);
        if (composite == null || composite.length() == 0 || composite.equals("none")) {
            this._composite = 0;
        } else if (composite.equals("list")) {
            this._composite = 1;
        } else if (composite.equals("map")) {
            this._composite = 2;
        } else {
            throw new IllegalArgumentException("Unkonwn composite: " + composite);
        }
        if (vars != null) {
            this._vars = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> me : vars.entrySet()) {
                this._vars.put(me.getKey(), Utils.parseComposite(me.getValue(), Object.class, this._composite));
            }
        } else {
            this._vars = null;
        }
        this._local = local;
    }

    public VariablesInfo(NodeInfo parent, Map<String, String> vars, boolean local, ConditionImpl cond) {
        this(parent, vars, local, null, cond);
    }

    public boolean isLocal() {
        return this._local;
    }

    public String getComposite() {
        return this._composite == 1 ? "list" : (this._composite == 2 ? "map" : "none");
    }

    public void apply(Component comp) {
        if (this._vars != null && this.isEffective(comp)) {
            Evaluator eval = this.getEvaluator();
            for (Map.Entry<String, Object> me : this._vars.entrySet()) {
                String name = me.getKey();
                Object value = me.getValue();
                comp.getSpaceOwner().setAttribute(name, Utils.evaluateComposite(eval, comp, value), !this._local);
            }
        }
    }

    public void apply(Page page) {
        if (this._vars != null && this.isEffective(page)) {
            Evaluator eval = this.getEvaluator();
            for (Map.Entry<String, Object> me : this._vars.entrySet()) {
                String name = me.getKey();
                Object value = me.getValue();
                page.setAttribute(name, Utils.evaluateComposite(eval, page, value), !this._local);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40).append("[variables:");
        if (this._vars != null) {
            for (String name : this._vars.keySet()) {
                sb.append(' ').append(name);
            }
        }
        return sb.append(']').toString();
    }
}

