/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.EventHandler;

public class EventHandlerMap
implements Cloneable,
Serializable {
    private Map<String, List<EventHandler>> _evthds;

    public boolean isEmpty() {
        return this._evthds == null || this._evthds.isEmpty();
    }

    public EventHandler get(Component comp, String evtnm) {
        List<EventHandler> ehl;
        if (this._evthds != null && (ehl = this._evthds.get(evtnm)) != null) {
            for (EventHandler eh : ehl) {
                if (!eh.isEffective(comp)) continue;
                return eh;
            }
        }
        return null;
    }

    public Set<String> getEventNames() {
        if (this._evthds != null) {
            return this._evthds.keySet();
        }
        return Collections.emptySet();
    }

    public List<EventHandler> getAll(String evtnm) {
        if (this._evthds != null) {
            return this._evthds.get(evtnm);
        }
        return null;
    }

    public void add(String evtnm, EventHandler evthd) {
        List<EventHandler> ehl;
        if (evtnm == null || evthd == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._evthds == null) {
            this._evthds = new HashMap<String, List<EventHandler>>(4);
        }
        if ((ehl = this._evthds.get(evtnm)) == null) {
            ehl = new LinkedList<EventHandler>();
            this._evthds.put(evtnm, ehl);
        } else {
            Iterator<EventHandler> it = ehl.iterator();
            while (it.hasNext()) {
                EventHandler eh = it.next();
                if (!Objects.equals((Object)eh.getCondition(), (Object)evthd.getCondition())) continue;
                it.remove();
            }
        }
        ehl.add(evthd);
    }

    public void addAll(EventHandlerMap src) {
        if (src != null && !src.isEmpty()) {
            for (Map.Entry<String, List<EventHandler>> me : src._evthds.entrySet()) {
                String evtnm = me.getKey();
                for (EventHandler eh : me.getValue()) {
                    this.add(evtnm, eh);
                }
            }
        }
    }

    public Object clone() {
        EventHandlerMap clone = new EventHandlerMap();
        clone.addAll(this);
        return clone;
    }

    public String toString() {
        return "[evthd:" + this._evthds + ']';
    }
}

