/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.CacheMap;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.impl.UiVisualizer;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopRecycle;
import org.zkoss.zk.ui.util.Monitor;

public class SimpleDesktopCache
implements DesktopCache,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(SimpleDesktopCache.class);
    private static final long serialVersionUID = 20060622L;
    private final Cache _desktops;
    private int _nextKey;

    public SimpleDesktopCache(Configuration config) {
        this._desktops = new Cache(config);
        if (!config.isRepeatUuid()) {
            this._nextKey = (int)System.currentTimeMillis() & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextKey() {
        SimpleDesktopCache simpleDesktopCache = this;
        synchronized (simpleDesktopCache) {
            return this._nextKey++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Desktop getDesktopIfAny(String desktopId) {
        boolean old = this._desktops.disableExpunge(true);
        try {
            Cache cache = this._desktops;
            synchronized (cache) {
                Desktop desktop = (Desktop)this._desktops.get(desktopId);
                return desktop;
            }
        }
        finally {
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Desktop getDesktop(String desktopId) {
        Desktop desktop;
        Cache cache = this._desktops;
        synchronized (cache) {
            desktop = (Desktop)this._desktops.get(desktopId);
        }
        if (desktop == null) {
            throw new ComponentNotFoundException("Desktop not found: " + desktopId);
        }
        return desktop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDesktop(Desktop desktop) {
        Desktop old;
        Cache cache = this._desktops;
        synchronized (cache) {
            old = (Desktop)this._desktops.put(desktop.getId(), desktop);
        }
        if (old != null) {
            this._desktops.put(old.getId(), old);
            if (log.isWarnEnabled()) {
                log.warn(desktop == old ? "Register a desktop twice: " + desktop : "Replicated ID: " + desktop + "; already used by " + old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDesktop(Desktop desktop) {
        boolean oldexp = this._desktops.disableExpunge(true);
        try {
            Desktop old;
            Cache cache = this._desktops;
            synchronized (cache) {
                old = (Desktop)this._desktops.remove(desktop.getId());
            }
            if (old == null) {
                log.warn("Removing non-existent desktop: " + desktop);
            } else {
                SimpleDesktopCache.desktopDestroyed(desktop);
            }
        }
        finally {
            this._desktops.disableExpunge(oldexp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void desktopDestroyed(Desktop desktop) {
        Execution currentExec;
        Visualizer oldVi;
        Execution oldExec;
        DesktopCtrl desktopCtrl;
        Session sess;
        block7: {
            sess = desktop.getSession();
            ExecutionImpl exec = new ExecutionImpl(desktop.getWebApp().getServletContext(), null, null, desktop, null);
            desktopCtrl = (DesktopCtrl)((Object)desktop);
            oldExec = desktop.getExecution();
            oldVi = desktopCtrl.getVisualizer();
            currentExec = Executions.getCurrent();
            try {
                DesktopRecycle dtrc;
                ExecutionsCtrl.setCurrent(exec);
                UiVisualizer uv = new UiVisualizer(exec, true, false);
                desktopCtrl.setVisualizer(uv);
                desktopCtrl.setExecution(exec);
                WebApp wapp = desktop.getWebApp();
                ((DesktopCtrl)((Object)desktop)).invokeDesktopCleanups();
                Configuration config = wapp.getConfiguration();
                config.invokeDesktopCleanups(desktop);
                ((WebAppCtrl)((Object)wapp)).getUiEngine().desktopDestroyed(desktop);
                Monitor monitor = desktop.getWebApp().getConfiguration().getMonitor();
                if (monitor != null) {
                    try {
                        monitor.desktopDestroyed(desktop);
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                }
                if ((dtrc = config.getDesktopRecycle()) == null) break block7;
                try {
                    dtrc.afterRemove(sess, desktop);
                }
                catch (Throwable ex) {
                    log.error("", ex);
                }
            }
            catch (Throwable throwable) {
                ExecutionsCtrl.setCurrent(sess != Sessions.getCurrent() || oldVi != null && oldVi.isRecovering() ? currentExec : null);
                desktopCtrl.setVisualizer(oldVi);
                desktopCtrl.setExecution(oldExec);
                throw throwable;
            }
        }
        ExecutionsCtrl.setCurrent(sess != Sessions.getCurrent() || oldVi != null && oldVi.isRecovering() ? currentExec : null);
        desktopCtrl.setVisualizer(oldVi);
        desktopCtrl.setExecution(oldExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionWillPassivate(Session sess) {
        boolean old = this._desktops.disableExpunge(true);
        try {
            ArrayList desktops = null;
            Cache cache = this._desktops;
            synchronized (cache) {
                desktops = new ArrayList(this._desktops.values());
            }
            for (Desktop desktop : desktops) {
                ((DesktopCtrl)((Object)desktop)).sessionWillPassivate(sess);
            }
        }
        finally {
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionDidActivate(Session sess) {
        boolean old = this._desktops.disableExpunge(true);
        try {
            ArrayList desktops = null;
            Cache cache = this._desktops;
            synchronized (cache) {
                desktops = new ArrayList(this._desktops.values());
            }
            for (Desktop desktop : desktops) {
                ((DesktopCtrl)((Object)desktop)).sessionDidActivate(sess);
            }
        }
        finally {
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("Invalidated and remove: " + (Object)((Object)this._desktops));
        }
        boolean old = this._desktops.disableExpunge(true);
        try {
            ArrayList desktops = null;
            Cache cache = this._desktops;
            synchronized (cache) {
                desktops = new ArrayList(this._desktops.values());
                this._desktops.clear();
            }
            for (Desktop desktop : desktops) {
                SimpleDesktopCache.desktopDestroyed(desktop);
            }
        }
        finally {
            this._desktops.disableExpunge(old);
        }
    }

    private static class Cache
    extends CacheMap<String, Desktop> {
        private AtomicBoolean _expungeDisabled = new AtomicBoolean(false);

        private Cache(Configuration config) {
            super(16);
            int v = config.getSessionMaxDesktops();
            this.setMaxSize(v >= 0 ? v : 0x1FFFFFFF);
            v = config.getDesktopMaxInactiveInterval();
            this.setLifetime(v >= 0 ? v * 1000 : 0x1FFFFFFF);
        }

        private boolean disableExpunge(boolean disable) {
            return this._expungeDisabled.getAndSet(disable);
        }

        protected boolean shallExpunge() {
            return !this._expungeDisabled.get() && (super.shallExpunge() || this.sizeWithoutExpunge() > this.getMaxSize() / 2);
        }

        protected int canExpunge(int size, CacheMap.Value<Desktop> v) {
            if (((Desktop)v.getValue()).getExecution() != null) {
                return 0;
            }
            return super.canExpunge(size, v);
        }

        protected void onExpunge(CacheMap.Value<Desktop> v) {
            super.onExpunge(v);
            SimpleDesktopCache.desktopDestroyed((Desktop)v.getValue());
            if (log.isDebugEnabled()) {
                log.debug("Expunge desktop: " + v.getValue());
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.disableExpunge(false);
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            boolean old = this.disableExpunge(true);
            try {
                s.defaultWriteObject();
            }
            finally {
                this.disableExpunge(old);
            }
        }
    }
}

