/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.mesg.Messages;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.WpdExtendlet;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);

    public static void updateDebugJS(WebApp wapp, boolean debug) {
        WebManager wm = WebManager.getWebManagerIfAny(wapp);
        if (wm != null) {
            ClassWebResource cwr = wm.getClassWebResource();
            cwr.setDebugJS(debug);
            Extendlet ext = cwr.getExtendlet("wpd");
            if (ext instanceof WpdExtendlet) {
                ((WpdExtendlet)ext).setDebugJS(debug);
            }
        }
    }

    public static final int getFirstDayOfWeek() {
        return Utils.getFirstDayOfWeek(Sessions.getCurrent());
    }

    public static final int getFirstDayOfWeek(Session sess) {
        int firstDayOfWeek = -1;
        try {
            Object hsess;
            Object o = null;
            if (sess != null && (o = sess.getAttribute("org.zkoss.web.preferred.firstDayOfWeek")) == null && (hsess = sess.getNativeSession()) instanceof HttpSession) {
                o = ((HttpSession)hsess).getServletContext().getAttribute("org.zkoss.web.preferred.firstDayOfWeek");
            }
            if (o == null) {
                o = Library.getProperty((String)"org.zkoss.web.preferred.firstDayOfWeek");
            }
            if (o instanceof Integer) {
                firstDayOfWeek = (Integer)o;
            } else if (o instanceof String) {
                firstDayOfWeek = Integer.parseInt((String)o);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            firstDayOfWeek = -1;
        }
        return firstDayOfWeek;
    }

    public static final int get2DigitYearStart() throws NumberFormatException {
        String value = Library.getProperty((String)"org.zkoss.web.preferred.2DigitYearStart", (String)"1929");
        int yearStart = Integer.parseInt(value);
        if (yearStart < 0) {
            throw new IllegalArgumentException("Library property: 2DigitYearStart should not be negative");
        }
        return yearStart;
    }

    static void handleError(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String path, Throwable err) throws ServletException, IOException {
        if (Servlets.isIncluded((ServletRequest)request)) {
            String msg = err != null ? Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{path, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)}) : Messages.get((int)MZk.PAGE_NOT_FOUND, (Object[])new Object[]{path});
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("px_alert_type", "error");
            attrs.put("px_alert", msg);
            Servlets.include((ServletContext)ctx, (ServletRequest)request, (ServletResponse)response, (String)"~./html/alert.dsp", attrs, (int)3);
        } else {
            if (err != null) {
                if (err instanceof ServletException) {
                    throw (ServletException)err;
                }
                if (err instanceof IOException) {
                    throw (IOException)err;
                }
                throw UiException.Aide.wrap(err);
            }
            response.sendError(404, path);
        }
    }

    static void resetOwner() {
        Component comp;
        Execution exec = Executions.getCurrent();
        if (exec != null && (comp = ((ExecutionCtrl)((Object)exec)).getVisualizer().getOwner()) instanceof Includer) {
            ((Includer)((Object)comp)).setChildPage(null);
        }
    }

    static Page getMainPage(Desktop desktop) {
        for (Page page : desktop.getPages()) {
            if (((PageCtrl)((Object)page)).getOwner() != null) continue;
            return page;
        }
        return null;
    }

    public static final String checkUpdateURI(String updateURI, String info) throws ServletException {
        if (updateURI == null || (updateURI = updateURI.trim()).length() == 0 || updateURI.charAt(0) != '/') {
            throw new ServletException(info + " must be specified and starts with /");
        }
        if (updateURI.indexOf(59) >= 0 || updateURI.indexOf(63) >= 0) {
            throw new ServletException(info + " cannot contain ';' or '?'");
        }
        if (updateURI.charAt(updateURI.length() - 1) == '\\') {
            if (updateURI.length() == 1) {
                throw new ServletException(info + " cannot contain only '/'");
            }
            updateURI = updateURI.substring(0, updateURI.length() - 1);
        }
        return updateURI;
    }

    static String obfuscateHashWithSalt(Object obj, String salt) {
        return Integer.toHexString(37 * obj.hashCode() + salt.hashCode());
    }
}

