/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.ext;

import java.util.HashMap;
import org.zkoss.lang.Strings;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;

public class Uploads {
    private Uploads() {
    }

    public static void parseUpload(Component comp, String upload) {
        if (!Strings.isEmpty((String)upload)) {
            HashMap args = new HashMap();
            Maps.parse(args, (String)upload, (char)',', (char)'\u0001');
            String maxsize = (String)args.get("maxsize");
            if (!Strings.isEmpty((String)maxsize)) {
                try {
                    Integer maxsz = Integer.parseInt(maxsize);
                    comp.setAttribute("org.zkoss.zk.upload.maxsize", maxsz);
                }
                catch (NumberFormatException e) {
                    throw new UiException("The upload max size should be a positive integer.");
                }
            }
            if (args.containsKey("native")) {
                comp.setAttribute("org.zkoss.zk.upload.native", true);
            } else {
                comp.removeAttribute("org.zkoss.zk.upload.native");
            }
        }
    }

    public static String getRealUpload(Component comp, String upload) {
        Desktop desktop = comp.getDesktop();
        if (desktop != null && !Strings.isEmpty((String)upload) && !upload.contains("maxsize=")) {
            upload = upload.concat(",maxsize=" + desktop.getWebApp().getConfiguration().getMaxUploadSize());
        }
        return upload;
    }
}

