/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.SingletonExtensionRegistry;
import net.sf.jasperreports.web.util.RequirejsConfigContributor;
import net.sf.jasperreports.web.util.RequirejsConfigContributorSwitchDecorator;
import net.sf.jasperreports.web.util.RequirejsTemplateConfigContributor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequirejsConfigTemplateExtensionFactory
implements ExtensionsRegistryFactory {
    private static final Log log = LogFactory.getLog(RequirejsConfigTemplateExtensionFactory.class);
    public static final String EXTENSION_PROPERTY_TEMPLATE_PREFIX = "net.sf.jasperreports.requirejs.config.template.";
    public static final String EXTENSION_PROPERTY_ENABLED_PREFIX = "net.sf.jasperreports.requirejs.config.enabled.";
    public static final String EXTENSION_PROPERTY_PATH_PREFIX = "net.sf.jasperreports.requirejs.config.path.";
    public static final String EXTENSION_PROPERTY_RESOURCE_PREFIX = "net.sf.jasperreports.requirejs.config.resource.";
    public static final String PROPERTY_ENABLED_PREFIX = "net.sf.jasperreports.requirejs.config.enabled.";

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        String template = properties.getProperty(EXTENSION_PROPERTY_TEMPLATE_PREFIX + registryId);
        String enabledProp = properties.getProperty("net.sf.jasperreports.requirejs.config.enabled." + registryId);
        boolean enabled = JRPropertiesUtil.asBoolean(enabledProp, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating requirejs template contributor " + registryId + ", template: " + template + ", enabled: " + enabled));
        }
        RequirejsTemplateConfigContributor templateContributor = new RequirejsTemplateConfigContributor();
        templateContributor.setTemplateName(template);
        this.setPaths(registryId, properties, templateContributor);
        this.setResources(registryId, properties, templateContributor);
        RequirejsConfigContributorSwitchDecorator switchDecorator = new RequirejsConfigContributorSwitchDecorator();
        switchDecorator.setDefaultEnabled(enabled);
        switchDecorator.setPropertyName("net.sf.jasperreports.requirejs.config.enabled." + registryId);
        switchDecorator.setContributor(templateContributor);
        SingletonExtensionRegistry<RequirejsConfigContributorSwitchDecorator> registry = new SingletonExtensionRegistry<RequirejsConfigContributorSwitchDecorator>(RequirejsConfigContributor.class, switchDecorator);
        return registry;
    }

    protected void setPaths(String registryId, JRPropertiesMap properties, RequirejsTemplateConfigContributor templateContributor) {
        String pathPropPrefix = EXTENSION_PROPERTY_PATH_PREFIX + registryId + ".";
        List<JRPropertiesUtil.PropertySuffix> pathProps = JRPropertiesUtil.getProperties(properties, pathPropPrefix);
        for (JRPropertiesUtil.PropertySuffix pathProp : pathProps) {
            String suffix = pathProp.getSuffix();
            String path = pathProp.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting path " + suffix + " to " + path));
            }
            templateContributor.addPath(suffix, path);
        }
    }

    protected void setResources(String registryId, JRPropertiesMap properties, RequirejsTemplateConfigContributor templateContributor) {
        String pathPropPrefix = EXTENSION_PROPERTY_RESOURCE_PREFIX + registryId + ".";
        List<JRPropertiesUtil.PropertySuffix> pathProps = JRPropertiesUtil.getProperties(properties, pathPropPrefix);
        for (JRPropertiesUtil.PropertySuffix pathProp : pathProps) {
            String suffix = pathProp.getSuffix();
            String path = pathProp.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting resource " + suffix + " to " + path));
            }
            templateContributor.addResourcePath(suffix, path);
        }
    }
}

