/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Box
extends XulElement {
    private String _spacing;
    private String _align = "start";
    private String _pack = "start";
    private String[] _sizes;
    private boolean _sizedByContent = true;

    public Box() {
        this("vertical");
    }

    public Box(String orient) {
        this.setOrient(orient);
    }

    public Box(Component[] children) {
        this("vertical", children);
    }

    public Box(String orient, Component[] children) {
        this(orient);
        if (children != null) {
            for (int j = 0; j < children.length; ++j) {
                this.appendChild(children[j]);
            }
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public String getOrient() {
        return this.getMold();
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        this.setMold(orient);
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null && spacing.length() == 0) {
            spacing = null;
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.smartUpdate("spacing", this._spacing);
        }
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getPack() {
        return this._pack;
    }

    public void setPack(String pack) {
        if (pack != null && pack.length() == 0) {
            pack = null;
        }
        if (!Objects.equals((Object)this._pack, (Object)pack)) {
            this._pack = pack;
            this.smartUpdate("pack", this._pack);
        }
    }

    public String getWidths() {
        return Utils.arrayToString(this._sizes);
    }

    public String getHeights() {
        return this.getWidths();
    }

    public void setWidths(String widths) throws WrongValueException {
        String[] sizes = Utils.stringToArray(widths, null);
        if (!Objects.equals((Object)sizes, (Object)this._sizes)) {
            this._sizes = sizes;
            this.smartUpdate("widths", this._sizes);
        }
    }

    public void setHeights(String heights) throws WrongValueException {
        this.setWidths(heights);
    }

    public void setSizedByContent(boolean byContent) {
        if (this._sizedByContent != byContent) {
            this._sizedByContent = byContent;
            this.smartUpdate("sizedByContent", byContent);
        }
    }

    public boolean isSizedByContent() {
        return this._sizedByContent;
    }

    public boolean evalCSSFlex() {
        return false;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "spacing", this._spacing);
        this.render(renderer, "_sizes", this._sizes);
        if (!"start".equals(this._align)) {
            this.render(renderer, "align", this._align);
        }
        if (!"start".equals(this._pack)) {
            this.render(renderer, "pack", this._pack);
        }
        if (!this.isSizedByContent()) {
            renderer.render("sizedByContent", false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? (this.isVertical() ? "z-vbox" : "z-hbox") : this._zclass;
    }
}

