/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.util.BigDecimalHandler;

public class Java15BigDecimalHandler
implements BigDecimalHandler {
    public static final String PROPERTY_MINIMUM_PRECISION = "net.sf.jasperreports.big.decimal.minimum.precision";
    private final int minPrecision;
    private final ThreadLocal<MathContext[]> mathContexts;

    public Java15BigDecimalHandler() {
        this(Java15BigDecimalHandler.readConfiguredPrecision());
    }

    public Java15BigDecimalHandler(int minPrecision) {
        if (minPrecision <= 0) {
            throw new IllegalArgumentException("minPrecision must be positive");
        }
        this.minPrecision = minPrecision;
        this.mathContexts = new ThreadLocal();
    }

    private static int readConfiguredPrecision() {
        return JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getIntegerProperty(PROPERTY_MINIMUM_PRECISION);
    }

    @Override
    public BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        int precision = this.getDivisionPrecision(dividend, divisor);
        MathContext mathContext = this.getMathContext(precision);
        return dividend.divide(divisor, mathContext);
    }

    protected int getDivisionPrecision(BigDecimal dividend, BigDecimal divisor) {
        int precision = this.minPrecision;
        if (dividend.precision() > precision) {
            precision = dividend.precision();
        }
        if (divisor.precision() > precision) {
            precision = divisor.precision();
        }
        return precision;
    }

    protected MathContext getMathContext(int precision) {
        MathContext mathContext;
        MathContext[] contexts = this.mathContexts.get();
        int idx = precision - this.minPrecision;
        if (contexts == null || contexts.length < idx + 1) {
            MathContext[] newContexts = new MathContext[idx + 1];
            if (contexts != null) {
                System.arraycopy(contexts, 0, newContexts, 0, contexts.length);
            }
            this.mathContexts.set(newContexts);
            contexts = newContexts;
        }
        if ((mathContext = contexts[idx]) == null) {
            contexts[idx] = mathContext = new MathContext(precision, RoundingMode.HALF_UP);
        }
        return mathContext;
    }
}

