/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionResolver;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.Monitor;

public class SessionsCtrl
extends Sessions {
    private static final Logger log = LoggerFactory.getLogger(SessionsCtrl.class);
    private static final String ATTR_REQUEST_COUNT = "org.zkoss.zk.ui.sys.RequestCount";

    protected SessionsCtrl() {
    }

    public static final void setCurrent(Session sess) {
        _sess.set(sess);
    }

    public static final void setCurrent(SessionResolver sr) {
        _sess.set(sr);
    }

    public static final SessionCtrl getCurrentCtrl() {
        return (SessionCtrl)((Object)SessionsCtrl.getCurrent());
    }

    public static final Object getRawCurrent() {
        return _sess.get();
    }

    public static final void setRawCurrent(Object rawsess) {
        if (rawsess != null && !(rawsess instanceof Session) && !(rawsess instanceof SessionResolver)) {
            throw new IllegalArgumentException(rawsess.getClass().getName());
        }
        _sess.set(rawsess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateCount(boolean inc) {
        Class<SessionsCtrl> clazz = SessionsCtrl.class;
        synchronized (SessionsCtrl.class) {
            _cnt = inc ? ++_cnt : --_cnt;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean requestEnter(Session sess) {
        Integer v = (Integer)sess.getAttribute(ATTR_REQUEST_COUNT);
        int i = v != null ? v + 1 : 1;
        int max = sess.getWebApp().getConfiguration().getSessionMaxRequests();
        if (max < 0 || i <= max) {
            sess.setAttribute(ATTR_REQUEST_COUNT, new Integer(i));
            return true;
        }
        return false;
    }

    public static void requestExit(Session sess) {
        Integer v = (Integer)sess.getAttribute(ATTR_REQUEST_COUNT);
        int i = v != null ? v - 1 : 0;
        sess.setAttribute(ATTR_REQUEST_COUNT, new Integer(i >= 0 ? i : 0));
    }

    public static final Session getSession(WebApp wapp, Object navsess) {
        SessionCache sc = ((WebAppCtrl)((Object)wapp)).getSessionCache();
        if (sc == null) {
            return null;
        }
        Session sess = sc.get(navsess);
        if (sess != null && sess.getNativeSession() != navsess) {
            ((SessionCtrl)((Object)sess)).recover(navsess);
        }
        return sess;
    }

    public static final Session newSession(WebApp wapp, Object navsess, Object request) {
        int v;
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Session sess = wappc.getUiFactory().newSession(wapp, navsess, request);
        wappc.getSessionCache().put(sess);
        Configuration config = wapp.getConfiguration();
        config.invokeSessionInits(sess, request);
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionCreated(sess);
            }
            catch (Throwable ex) {
                log.error("", ex);
            }
        }
        if ((v = wapp.getConfiguration().getSessionMaxInactiveInterval()) != 0) {
            sess.setMaxInactiveInterval(v);
        }
        return sess;
    }
}

