/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.sys.StubComponent;

public class StubEvent
extends Event {
    private final String _cmd;
    private final String _uuid;
    private final String _id;
    private final Map<String, Object> _data;

    public static final StubEvent getStubEvent(AuRequest request) {
        Component target = request.getComponent();
        Map<String, Object> data = request.getData();
        String uuid = request.getUuid();
        return new StubEvent("onStub", target, request.getCommand(), uuid, StubEvent.getId(target, uuid), data);
    }

    private static final String getId(Component comp, String uuid) {
        String id;
        if (comp instanceof StubComponent) {
            return ((StubComponent)comp).getId(uuid);
        }
        if (comp != null && (id = comp.getId()) != null && id.length() > 0) {
            return id;
        }
        return null;
    }

    public String getId() {
        return this._id;
    }

    public StubEvent(String name, Component target, String cmd, String uuid, String id, Map<String, Object> data) {
        super(name, target);
        this._cmd = cmd;
        this._uuid = uuid;
        this._id = id;
        this._data = data;
    }

    public StubEvent(StubEvent evt, Component target) {
        this(evt.getName(), target, evt._cmd, evt._uuid, evt._id, evt._data);
    }

    public String getCommand() {
        return this._cmd;
    }

    public String getUuid() {
        return this._uuid;
    }

    public Map<String, Object> getRequestData() {
        return this._data;
    }
}

