/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.ext.NonFellow;
import org.zkoss.zk.ui.ext.ScopeListener;

class VirtualIdSpace
implements IdSpace {
    private final Component _owner;
    private final Map<String, Component> _fellows = new HashMap<String, Component>(2);

    VirtualIdSpace(Component owner) {
        if (owner instanceof IdSpace || owner.getParent() != null || owner.getPage() != null) {
            throw new InternalError("wrong! " + owner + ":" + owner.getParent() + ":" + owner.getPage());
        }
        this._owner = owner;
        VirtualIdSpace.init(this._fellows, this._owner);
    }

    private static void init(Map<String, Component> fellows, Component comp) {
        String compId;
        if (!(comp instanceof NonFellow) && !AbstractComponent.isAutoId(compId = comp.getId())) {
            fellows.put(compId, comp);
        }
        if (!(comp instanceof IdSpace)) {
            for (Component child = comp.getFirstChild(); child != null; child = child.getNextSibling()) {
                VirtualIdSpace.init(fellows, child);
            }
        }
    }

    @Override
    public Component getFellow(String id) throws ComponentNotFoundException {
        Component comp = this.getFellowIfAny(id);
        if (comp == null) {
            throw new ComponentNotFoundException(id);
        }
        return comp;
    }

    @Override
    public Component getFellow(String id, boolean recurse) throws ComponentNotFoundException {
        return this.getFellow(id);
    }

    @Override
    public Component getFellowIfAny(String id) {
        return this._fellows.get(id);
    }

    @Override
    public Component getFellowIfAny(String id, boolean recurse) {
        return this.getFellowIfAny(id);
    }

    @Override
    public Collection<Component> getFellows() {
        return this._fellows.values();
    }

    @Override
    public boolean hasFellow(String id) {
        return this._fellows.containsKey(id);
    }

    @Override
    public boolean hasFellow(String id, boolean recurse) {
        return this.hasFellow(id);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._owner.getAttributes();
    }

    @Override
    public Object getAttribute(String name) {
        return this._owner.getAttribute(name);
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        return this._owner.getAttribute(name, recurse);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this._owner.hasAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        return this._owner.hasAttribute(name, recurse);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return this._owner.setAttribute(name, value);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        return this._owner.setAttribute(name, value, recurse);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._owner.removeAttribute(name);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        return this._owner.removeAttribute(name, recurse);
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._owner.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._owner.removeScopeListener(listener);
    }
}

