/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.extensions;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.zkoss.poi.ss.usermodel.BorderStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.xssf.model.ThemesTable;
import org.zkoss.poi.xssf.usermodel.XSSFColor;

public class XSSFCellBorder {
    private ThemesTable _theme;
    private CTBorder border;

    public XSSFCellBorder(CTBorder border, ThemesTable theme) {
        this(border);
        this._theme = theme;
    }

    public XSSFCellBorder(CTBorder border) {
        this.border = border;
    }

    public XSSFCellBorder() {
        this.border = CTBorder.Factory.newInstance();
    }

    public void setThemesTable(ThemesTable themes) {
        this._theme = themes;
    }

    @Internal
    public CTBorder getCTBorder() {
        return this.border;
    }

    public BorderStyle getBorderStyle(BorderSide side) {
        CTBorderPr ctBorder = this.getBorder(side);
        STBorderStyle.Enum border = ctBorder == null ? STBorderStyle.NONE : ctBorder.getStyle();
        return BorderStyle.values()[border.intValue() - 1];
    }

    public void setBorderStyle(BorderSide side, BorderStyle style) {
        this.setBorderStyle(side, style.ordinal());
    }

    public void setBorderStyle(BorderSide side, int ordinal) {
        CTBorderPr bpr = this.getBorder(side, true);
        if (ordinal != 0) {
            bpr.setStyle(STBorderStyle.Enum.forInt((int)(ordinal + 1)));
        }
    }

    public XSSFColor getBorderColor(BorderSide side) {
        CTBorderPr borderPr = this.getBorder(side);
        if (borderPr != null && borderPr.isSetColor()) {
            XSSFColor clr = new XSSFColor(borderPr.getColor());
            if (this._theme != null) {
                this._theme.inheritFromThemeAsRequired(clr);
            }
            return clr;
        }
        return null;
    }

    public void setBorderColor(BorderSide side, XSSFColor color) {
        CTBorderPr borderPr = this.getBorder(side, true);
        if (color == null) {
            borderPr.unsetColor();
        } else {
            borderPr.setColor(color.getCTColor());
        }
    }

    private CTBorderPr getBorder(BorderSide side) {
        return this.getBorder(side, false);
    }

    private CTBorderPr getBorder(BorderSide side, boolean ensure) {
        CTBorderPr borderPr;
        switch (side) {
            case TOP: {
                borderPr = this.border.getTop();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewTop();
                break;
            }
            case RIGHT: {
                borderPr = this.border.getRight();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewRight();
                break;
            }
            case BOTTOM: {
                borderPr = this.border.getBottom();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewBottom();
                break;
            }
            case LEFT: {
                borderPr = this.border.getLeft();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewLeft();
                break;
            }
            case DIAGONAL: {
                borderPr = this.border.getDiagonal();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewDiagonal();
                break;
            }
            case HORIZONTAL: {
                borderPr = this.border.getHorizontal();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewHorizontal();
                break;
            }
            case VERTICAL: {
                borderPr = this.border.getVertical();
                if (!ensure || borderPr != null) break;
                borderPr = this.border.addNewVertical();
                break;
            }
            default: {
                throw new IllegalArgumentException("No suitable side specified for the border");
            }
        }
        return borderPr;
    }

    public int hashCode() {
        return this.border.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFCellBorder)) {
            return false;
        }
        XSSFCellBorder cf = (XSSFCellBorder)o;
        return this.border.toString().equals(cf.getCTBorder().toString());
    }

    public void setDiagonalUp(boolean up) {
        this.border.setDiagonalUp(up);
    }

    public boolean isDiagonalUp() {
        return this.border.getDiagonalUp();
    }

    public void setDiagonalDown(boolean down) {
        this.border.setDiagonalDown(down);
    }

    public boolean isDiagonalDown() {
        return this.border.getDiagonalDown();
    }

    public void prepareBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor) {
        this.setBorderStyle(BorderSide.LEFT, left);
        this.setBorderStyle(BorderSide.TOP, top);
        this.setBorderStyle(BorderSide.RIGHT, right);
        this.setBorderStyle(BorderSide.BOTTOM, bottom);
        if (left != 0) {
            this.setBorderColor(BorderSide.LEFT, (XSSFColor)leftColor);
        }
        if (top != 0) {
            this.setBorderColor(BorderSide.TOP, (XSSFColor)topColor);
        }
        if (right != 0) {
            this.setBorderColor(BorderSide.RIGHT, (XSSFColor)rightColor);
        }
        if (bottom != 0) {
            this.setBorderColor(BorderSide.BOTTOM, (XSSFColor)bottomColor);
        }
    }

    public static enum BorderSide {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        DIAGONAL,
        HORIZONTAL,
        VERTICAL;

    }
}

