/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.util;

import org.zkoss.poi.util.POILogger;

public class SystemOutLogger
extends POILogger {
    private String _cat;

    @Override
    public void initialize(String cat) {
        this._cat = cat;
    }

    @Override
    public void log(int level, Object obj1) {
        this.log(level, obj1, null);
    }

    @Override
    public void log(int level, Object obj1, Throwable exception) {
        if (this.check(level)) {
            System.out.println("[" + this._cat + "]" + LEVEL_STRINGS_SHORT[Math.min(LEVEL_STRINGS_SHORT.length - 1, level)] + " " + obj1);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        }
    }

    @Override
    public boolean check(int level) {
        int currentLevel;
        try {
            currentLevel = Integer.parseInt(System.getProperty("poi.log.level", "5"));
        }
        catch (SecurityException e) {
            currentLevel = 1;
        }
        return level >= currentLevel;
    }
}

