/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.ArrayEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.Function2Arg;
import org.zkoss.poi.ss.formula.functions.Operator;

public abstract class Fixed2ArgFunction
implements Function2Arg {
    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval arg0 = args[0];
        ValueEval arg1 = args[1];
        if (this instanceof Operator) {
            if (arg0 instanceof AreaEval) {
                return this.evaluateArray(srcRowIndex, srcColumnIndex, arg0, arg1);
            }
            if (arg1 instanceof AreaEval) {
                return this.evaluateArray(srcRowIndex, srcColumnIndex, arg1, arg0);
            }
        }
        return this.evaluate(srcRowIndex, srcColumnIndex, arg0, arg1);
    }

    protected ValueEval evaluateArray(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        AreaEval ae0 = (AreaEval)arg0;
        int w0 = ae0.getWidth();
        int h0 = ae0.getHeight();
        ValueEval[][] results = new ValueEval[h0][];
        if (!(arg1 instanceof AreaEval)) {
            for (int r = 0; r < h0; ++r) {
                results[r] = new ValueEval[w0];
                for (int c = 0; c < w0; ++c) {
                    ValueEval ve0 = ae0.getRelativeValue(r, c);
                    ValueEval ve = this.evaluate(srcRowIndex, srcColumnIndex, ve0, arg1);
                    if (ve0 instanceof ErrorEval) {
                        return ve0;
                    }
                    if (ve instanceof ErrorEval) {
                        return ve;
                    }
                    results[r][c] = ve;
                }
            }
        } else {
            AreaEval ae1 = (AreaEval)arg1;
            int w1 = ae1.getWidth();
            int h1 = ae1.getHeight();
            if (w1 != w0 || h1 != h0) {
                return ErrorEval.VALUE_INVALID;
            }
            for (int r = 0; r < h0; ++r) {
                results[r] = new ValueEval[w0];
                for (int c = 0; c < w0; ++c) {
                    ValueEval ve0 = ae0.getRelativeValue(r, c);
                    ValueEval ve1 = ae1.getRelativeValue(r, c);
                    ValueEval ve = this.evaluate(srcRowIndex, srcColumnIndex, ve0, ve1);
                    if (ve0 instanceof ErrorEval) {
                        return ve0;
                    }
                    if (ve1 instanceof ErrorEval) {
                        return ve1;
                    }
                    if (ve instanceof ErrorEval) {
                        return ve;
                    }
                    results[r][c] = ve;
                }
            }
        }
        return new ArrayEval(results, ae0.getFirstRow(), ae0.getFirstColumn(), ae0.getLastRow(), ae0.getLastColumn(), ae0.getRefEvaluator());
    }
}

