/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.eval;

import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.usermodel.ErrorConstants;
import org.zkoss.poi.ss.usermodel.Hyperlink;

public final class ErrorEval
implements ValueEval,
HyperlinkEval {
    private static final ErrorConstants EC = null;
    public static final ErrorEval NULL_INTERSECTION = new ErrorEval(0);
    public static final ErrorEval DIV_ZERO = new ErrorEval(7);
    public static final ErrorEval VALUE_INVALID = new ErrorEval(15);
    public static final ErrorEval REF_INVALID = new ErrorEval(23);
    public static final ErrorEval NAME_INVALID = new ErrorEval(29);
    public static final ErrorEval NUM_ERROR = new ErrorEval(36);
    public static final ErrorEval NA = new ErrorEval(42);
    public static final ErrorEval FORMULA_INVALID = new ErrorEval(127);
    private static final int CIRCULAR_REF_ERROR_CODE = -60;
    private static final int FUNCTION_NOT_IMPLEMENTED_CODE = -30;
    public static final ErrorEval CIRCULAR_REF_ERROR = new ErrorEval(-60);
    private int _errorCode;
    private Hyperlink _hyperlink;

    public static ErrorEval valueOf(int errorCode) {
        switch (errorCode) {
            case 0: {
                return NULL_INTERSECTION;
            }
            case 7: {
                return DIV_ZERO;
            }
            case 15: {
                return VALUE_INVALID;
            }
            case 23: {
                return REF_INVALID;
            }
            case 29: {
                return NAME_INVALID;
            }
            case 36: {
                return NUM_ERROR;
            }
            case 42: {
                return NA;
            }
            case -60: {
                return CIRCULAR_REF_ERROR;
            }
            case 127: {
                return FORMULA_INVALID;
            }
        }
        throw new RuntimeException("Unexpected error code (" + errorCode + ")");
    }

    public static String getText(int errorCode) {
        if (ErrorConstants.isValidCode(errorCode)) {
            return ErrorConstants.getText(errorCode);
        }
        switch (errorCode) {
            case -60: {
                return "~CIRCULAR~REF~";
            }
            case -30: {
                return "~FUNCTION~NOT~IMPLEMENTED~";
            }
        }
        return "~non~std~err(" + errorCode + ")~";
    }

    private ErrorEval(int errorCode) {
        this._errorCode = errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(ErrorEval.getText(this._errorCode));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    @Override
    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }

    public static String getTooltip(int errorCode) {
        if (!ErrorConstants.isValidCode(errorCode)) {
            switch (errorCode) {
                case -60: {
                    return "Error: Circular dependency detected";
                }
                case -30: {
                    return "~FUNCTION~NOT~IMPLEMENTED~";
                }
            }
            return "Error: Unknown error code (" + errorCode + ")";
        }
        return null;
    }
}

