/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public class CompressPicturesRecord
extends StandardRecord {
    private static final BitField fAutoCompressPictures = BitFieldFactory.getInstance(1);
    public static final short sid = 2203;
    private FtrHeader futureHeader;
    int bits;

    public CompressPicturesRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2203);
    }

    public CompressPicturesRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.bits = in.readInt();
    }

    @Override
    public short getSid() {
        return 2203;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[COMPRESSPICTURES]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .bits       = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fAutoCompressPictures     = ").append(this.isAutoCompressPictures()).append("\n");
        buffer.append("[/COMPERSSPICTURES]\n");
        return buffer.toString();
    }

    public boolean isAutoCompressPictures() {
        return fAutoCompressPictures.isSet(this.bits);
    }

    public void setAutoCompressPictures(boolean flag) {
        this.bits = fAutoCompressPictures.setBoolean(this.bits, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.bits);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }
}

