/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hmef.attribute;

import java.util.Date;
import org.zkoss.poi.hmef.attribute.MAPIAttribute;
import org.zkoss.poi.hpsf.Util;
import org.zkoss.poi.hsmf.datatypes.MAPIProperty;
import org.zkoss.poi.util.LittleEndian;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class MAPIDateAttribute
extends MAPIAttribute {
    private static POILogger logger = POILogFactory.getLogger(MAPIDateAttribute.class);
    private Date data;

    protected MAPIDateAttribute(MAPIProperty property, int type, byte[] data) {
        super(property, type, data);
        this.data = Util.filetimeToDate(LittleEndian.getLong(data, 0));
    }

    public Date getDate() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.getProperty().toString() + " " + this.data.toString();
    }

    public static Date getAsDate(MAPIAttribute attr) {
        if (attr == null) {
            return null;
        }
        if (attr instanceof MAPIDateAttribute) {
            return ((MAPIDateAttribute)attr).getDate();
        }
        logger.log(5, "Warning, non date property found: " + attr.toString());
        return null;
    }
}

