


zcss = {
	p2saReg : /(-[a-z])/gi
};

zcss.nonNegativeAttr = ["width", "height"];


zcss.getSSheet = function (id) {
	var node = document.getElementById(id);
	if(node && node.type == "text/css"){
		return zcss._getElementSheet(node);
	}
	return null;
};



zcss.findRule = function (selector, id) {
	var ss;
	if (id) {
		ss = zcss.getSSheet(id);
		if(!ss) return null;
		ss = [ss];
	} else {
		ss = document.styleSheets;	
	}
	
	for (var i = ss.length - 1; i >= 0; i--) {
		var r = zcss._findRuleInStyleSheet(selector, ss[i]); 
		if (r) {
			return r;
		}
	}
	return null;
};


zcss._findRuleInStyleSheet = function (selector, ss) {
	var r = zcss._matchRule(selector, ss);
	if (r) {
		return r;
	}
	
	
	var imports = ss.imports;
	if (imports) {
		for (var j = imports.length; --j >=0;) {
			r = zcss._findRuleInStyleSheet(selector, imports[j]); 
			if (r) {
				return r;
			}
		}
	}
	return null;
};


zcss._matchRule = function (selector, ss) {
	var rules = zcss._getSSRules(ss);
	if (rules) {
		for (var j = rules.length - 1; j >= 0; j--) {
			var r = rules[j];
			if(selector.toLowerCase() == r.selectorText.toLowerCase()) {
				return r;
			}
		}
	}
	return null;
};


zcss._findRuleIndex = function (sheetobj, selector) {
	
	
	var rules = zcss._getSSRules(sheetobj);
	if(!rules) return -1;
	for(var j=rules.length-1;j>=0;j--){
		var r = rules[j];
		if(selector.toLowerCase() == r.selectorText.toLowerCase()){
			return j; 
		}
	}
	return -1;
};



zcss.addRule = function (selector, props, id, before) {
	var sheetobj;
	if (id) {
		sheetobj = zcss.getSSheet(id);
		if(!sheetobj) return null;
	} else {
		sheetobj = document.styleSheets;
		sheetobj = sheetobj[sheetobj.length - 1];
	}
	
	var rules = zcss._getSSRules(sheetobj);
	if(!rules) return null; 
	var index;
	
	if (sheetobj && before && typeof before == "string") {
		index = zcss._findRuleIndex(sheetobj , before);
		if (index < 0)
			index = rules.length;

	} else
		index  = rules.length;
	
	if (!(selector instanceof Array)) {
		var rule = zcss._insertRule2Sheet(sheetobj, selector, (props ? props : ""), index);
		return rule;
	} else {
		var rules = [],
			size = selector.length;
		for (var i = 0; i < size; i++) {
			rules[i] = zcss._insertRule2Sheet(sheetobj, selector[i], (props ? props : ""), index);
			index++;
		}
		return rules;
	}
	
	
	
	
};



zcss.setRule = function (selector, prop, value, create, id) {
	
	if (!(selector instanceof Array))
		selector = [selector];

	var result = false;
	for (var i = 0; i < selector.length; i++) {
		var rule = zcss.findRule(selector[i], id);
		if (!rule && create)
			rule = zcss.addRule(selector[i], "", id, create);

		if (rule) {
			if (prop instanceof Array) {
				for (var j = 0; j < prop.length; j++) {
					zcss._setRuleProperty(rule, prop[j], value[j]);
				}
			} else {
				zcss._setRuleProperty(rule, prop, value);
			}
			result = true;
		} else {
			result = false;
		}
	}
	return result;
};


zcss.removeRule = function (selector, id) {
	if(!id) return;
	var sheetobj = zcss.getSSheet(id);
	if (!sheetobj) return;
	
	if (!(selector instanceof Array))
		selector = [selector];

	zcss._removeRulesFromSheet(sheetobj,selector);
};




zcss._porp2attr = function (prop) {
	return prop.$camel();
};



zcss._getSSRules = function (){
	if ((zk.ie && zk.ie < 11) || zk.safari) {
		return function(styleSheet) {
			return styleSheet.rules;
		};
	} else {
		return function(styleSheet){
			try {
				return styleSheet.cssRules;
			} catch (e) {
				return null;
			}
		};
	}
}();

zcss._getElementSheet = function () {
	if (zk.ie && zk.ie < 11) {
		return function(element){
			return element.styleSheet;
		};
	} else {
		return function(element){
			return element.sheet;
		};
	}
}();


zcss._insertRule2Sheet = function () {
	if (zk.ie && zk.ie < 11) {
		return function(sheetobj, selector, style, index) {
			sheetobj.addRule(selector, "{"+style+"}", index);
			return sheetobj.rules[index];
		};
	}
	if (zk.opera) {
		return function(sheetobj, selector, style, index) {
			
			var len = sheetobj.cssRules.length;
			sheetobj.insertRule(selector+" {"+style+"}",index);
			return sheetobj.cssRules[index];
		};
	} else {
		return function(sheetobj, selector, style, index) {
			sheetobj.insertRule(selector + "{" + style + "}", index);
			return sheetobj.cssRules[index];
		};
	}
}();


zcss._removeRulesFromSheet = function () {
	if (zk.ie && zk.ie < 11) {
		return function(sheetobj, selectors) {
			
			var rules = zcss._getSSRules(sheetobj);
			if (!rules) return;
			for (var i = rules.length - 1; i >= 0; i--) {
				for (var j = selectors.length - 1; j >= 0; j--) {
					if (selectors[j] == rules[i].selectorText) {
						sheetobj.removeRule(i);
						break;
					}
				}
			}
		};
	} else {
		return function(sheetobj, selectors) {
			var rules = zcss._getSSRules(sheetobj);
			if (!rules) return;
			for (var i = rules.length - 1; i >= 0; i--) {
				for(var j = selectors.length - 1; j >= 0; j--) {
					if (selectors[j] == rules[i].selectorText){
						sheetobj.deleteRule(i);
						break;
					}
				}
			}
		};
	}
}();


zcss._setRuleProperty = function (){
	if (zk.ie && zk.ie < 11) {
		return function (rule, prop, value) {
			prop = zcss._porp2attr(prop);
			rule.style[prop]=value;
		};
	} else {
		return function (rule, prop, value) {
			rule.style.setProperty(prop, value, "");
		};
	}
}();

zcss._setStyleProperty = function(){
	if (zk.ie && zk.ie < 11) {
		return function (style, prop, value, comp) {
			if (zcss.nonNegativeAttr.$contains(prop) && typeof value == "string" && value.indexOf("-") == 0) {
				value = "0" + zcss._trimPrefixNumber(value);
			}
			prop = zcss._porp2attr(prop);
			style[prop] = value;
		};
	} else {
		return function (style, prop, value, comp) {
			if (zcss.nonNegativeAttr.$contains(prop) &&  typeof value == "string" && value.indexOf("-") == 0) {
				value = "0" + zcss._trimPrefixNumber(value);
			}
			style.setProperty(prop, value, "");
		};
	}
}();

zcss._trimPrefixNumber = function (str) {
	var regexp = /[^-+0-9]/,
		index = str.search(regexp);
	if (index > 0) {
		return str.substr(index, str.length);
	}
	return str;
};

zcss.setStyle = function (cmp, prop, value) {
	if (prop instanceof Array) {
		for(var j = 0; j < prop.length; j++) {
			zcss._setStyleProperty(cmp.style, prop[j], value[j], cmp);
		}
	} else {
		zcss._setStyleProperty(cmp.style, prop, value, cmp);
	}
};

zcss.copyStyle = function (src, target, styles, clear) {
	var size = styles.length,
		st,
		nm;
	for (var i = 0; i < size; i++) {
		nm = zcss._porp2attr(styles[i]);
		st = src.style[nm];
		if (st) {
			target.style[nm] = st;
		} else if(clear) {
			target.style[nm] = "";
		}
	}	
};